/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui;

import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DisplayElement
extends JPanel
implements PropertyHolder {
    private Point savedLocation = new Point(0, 0);
    private Dimension savedDimension = new Dimension(-1, -1);
    private Map<String, Property> properties = new LinkedHashMap<String, Property>();
    private boolean resizable = true;
    private boolean obstruction = true;

    public DisplayElement() {
        this.setOpaque(false);
    }

    public abstract void init();

    public void disconnect() {
    }

    @Override
    public boolean validatePropertyChange(Property property, Object value) {
        return true;
    }

    public boolean isObstruction() {
        return this.obstruction;
    }

    public void setObstruction(boolean obstruction) {
        this.obstruction = obstruction;
    }

    @Override
    public abstract void propertyChanged(Property var1);

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    protected void setDefault(String propertyName, String propertyType, Object value) {
        throw new UnsupportedOperationException("Deprecated");
    }

    protected Object getPropertyValue(String name) {
        return this.properties.get(name).getValue();
    }

    public Point getSavedLocation() {
        return new Point(this.savedLocation);
    }

    public Dimension getSavedSize() {
        return new Dimension(this.savedDimension);
    }

    public void setSavedLocation(Point p) {
        this.savedLocation = p;
    }

    public void setSavedSize(Dimension d) {
        this.savedDimension = new Dimension(d);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    protected void update(Property property, Object defaultValue) {
        if (property.hasDefault()) {
            this.propertyChanged(property);
        } else if (property.hasValue()) {
            property.setDefault(defaultValue);
            this.propertyChanged(property);
        } else {
            property.setDefault(defaultValue);
        }
    }

    public static String getName(Class<? extends DisplayElement> clazz) {
        try {
            Field field = clazz.getDeclaredField("NAME");
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new RuntimeException("TYPES must be static");
            }
            if (!Modifier.isFinal(modifiers)) {
                throw new RuntimeException("TYPES must be final");
            }
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                return (String)field.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz.getSimpleName();
    }
}

