/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.cpp.opencv_core;

public interface ImageTransformer {
    public Parameters createParameters();

    public void transform(Data[] var1, opencv_core.CvRect var2, Parameters[] var3, boolean[] var4);

    public void transform(opencv_core.CvMat var1, opencv_core.CvMat var2, Parameters var3, boolean var4);

    public static interface Parameters
    extends Cloneable {
        public int size();

        public double[] get();

        public double get(int var1);

        public void set(double ... var1);

        public void set(int var1, double var2);

        public void set(Parameters var1);

        public void reset(boolean var1);

        public double getConstraintError();

        public void compose(Parameters var1, boolean var2, Parameters var3, boolean var4);

        public boolean preoptimize();

        public double[] getSubspace();

        public void setSubspace(double ... var1);

        public Parameters clone();
    }

    public static class Data {
        public opencv_core.IplImage srcImg = null;
        public opencv_core.IplImage subImg = null;
        public opencv_core.IplImage srcDotImg = null;
        public opencv_core.IplImage mask = null;
        public double zeroThreshold = 0.0;
        public double outlierThreshold = 0.0;
        public int pyramidLevel = 0;
        public opencv_core.IplImage transImg = null;
        public opencv_core.IplImage dstImg = null;
        public int dstCount = 0;
        public int dstCountZero = 0;
        public int dstCountOutlier = 0;
        public double srcDstDot = 0.0;
        public double[] dstDstDot = null;
        protected Object cache = null;

        public Data(opencv_core.IplImage srcImg, opencv_core.IplImage subImg, opencv_core.IplImage srcDotImg, opencv_core.IplImage mask, double zeroThreshold, double outlierThreshold, int pyramidLevel, opencv_core.IplImage transImg, opencv_core.IplImage dstImg, int dstDstDotLength) {
            this.srcImg = srcImg;
            this.subImg = subImg;
            this.srcDotImg = srcDotImg;
            this.mask = mask;
            this.zeroThreshold = zeroThreshold;
            this.outlierThreshold = outlierThreshold;
            this.pyramidLevel = pyramidLevel;
            this.transImg = transImg;
            this.dstImg = dstImg;
            this.dstDstDot = dstDstDotLength == 0 ? null : new double[dstDstDotLength];
        }
    }
}

