/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.ImageTransformer;
import com.googlecode.javacv.cpp.opencv_core;

public interface ImageAligner {
    public Settings getSettings();

    public void setSettings(Settings var1);

    public opencv_core.IplImage getTemplateImage();

    public void setTemplateImage(opencv_core.IplImage var1, double[] var2);

    public opencv_core.IplImage getTargetImage();

    public void setTargetImage(opencv_core.IplImage var1);

    public int getPyramidLevel();

    public void setPyramidLevel(int var1);

    public ImageTransformer.Parameters getParameters();

    public void setParameters(ImageTransformer.Parameters var1);

    public double[] getTransformedRoiPts();

    public opencv_core.IplImage getTransformedImage();

    public opencv_core.IplImage getResidualImage();

    public opencv_core.IplImage getRoiMaskImage();

    public double getRMSE();

    public opencv_core.CvRect getRoi();

    public boolean iterate(double[] var1);

    public static class Settings
    extends BaseChildSettings
    implements Cloneable {
        int pyramidLevels = 5;
        opencv_core.CvMat gammaTgamma = null;
        double tikhonovAlpha = 0.0;
        boolean constrained = false;
        double[] zeroThresholds = new double[]{0.04, 0.03, 0.02, 0.01, 0.0};
        double[] outlierThresholds = new double[]{0.1};

        public Settings() {
        }

        public Settings(Settings s) {
            this.pyramidLevels = s.pyramidLevels;
            this.gammaTgamma = s.gammaTgamma;
            this.tikhonovAlpha = s.tikhonovAlpha;
            this.constrained = s.constrained;
            this.zeroThresholds = s.zeroThresholds;
            this.outlierThresholds = s.outlierThresholds;
        }

        public int getPyramidLevels() {
            return this.pyramidLevels;
        }

        public void setPyramidLevels(int pyramidLevels) {
            this.pyramidLevels = pyramidLevels;
        }

        public opencv_core.CvMat getGammaTgamma() {
            return this.gammaTgamma;
        }

        public void setGammaTgamma(opencv_core.CvMat gammaTgamma) {
            this.gammaTgamma = gammaTgamma;
        }

        public double getTikhonovAlpha() {
            return this.tikhonovAlpha;
        }

        public void setTikhonovAlpha(double tikhonovAlpha) {
            this.tikhonovAlpha = tikhonovAlpha;
        }

        public double[] getZeroThresholds() {
            return this.zeroThresholds;
        }

        public void setZeroThresholds(double[] zeroThresholds) {
            this.zeroThresholds = zeroThresholds;
        }

        public double[] getOutlierThresholds() {
            return this.outlierThresholds;
        }

        public void setOutlierThresholds(double[] outlierThresholds) {
            this.outlierThresholds = outlierThresholds;
        }

        public Settings clone() {
            return new Settings(this);
        }
    }
}

