/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.type;

import edu.wpi.first.wpilibj.networktables2.type.BooleanArray;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import edu.wpi.first.wpilibj.networktables2.type.NumberArray;
import edu.wpi.first.wpilibj.networktables2.type.StringArray;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DefaultEntryTypes {
    private static final byte BOOLEAN_RAW_ID = 0;
    private static final byte DOUBLE_RAW_ID = 1;
    private static final byte STRING_RAW_ID = 2;
    public static final NetworkTableEntryType BOOLEAN = new NetworkTableEntryType(0, "Boolean"){

        @Override
        public void sendValue(Object object, DataOutputStream dataOutputStream) throws IOException {
            if (!(object instanceof Boolean)) {
                throw new IOException("Cannot write " + object + " as " + this.name);
            }
            dataOutputStream.writeBoolean((Boolean)object);
        }

        @Override
        public Object readValue(DataInputStream dataInputStream) throws IOException {
            return dataInputStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
    };
    public static final NetworkTableEntryType DOUBLE = new NetworkTableEntryType(1, "Double"){

        @Override
        public void sendValue(Object object, DataOutputStream dataOutputStream) throws IOException {
            if (!(object instanceof Double)) {
                throw new IOException("Cannot write " + object + " as " + this.name);
            }
            dataOutputStream.writeDouble((Double)object);
        }

        @Override
        public Object readValue(DataInputStream dataInputStream) throws IOException {
            return new Double(dataInputStream.readDouble());
        }
    };
    public static final NetworkTableEntryType STRING = new NetworkTableEntryType(2, "String"){

        @Override
        public void sendValue(Object object, DataOutputStream dataOutputStream) throws IOException {
            if (!(object instanceof String)) {
                throw new IOException("Cannot write " + object + " as " + this.name);
            }
            dataOutputStream.writeUTF((String)object);
        }

        @Override
        public Object readValue(DataInputStream dataInputStream) throws IOException {
            return dataInputStream.readUTF();
        }
    };

    public static void registerTypes(NetworkTableEntryTypeManager networkTableEntryTypeManager) {
        networkTableEntryTypeManager.registerType(BOOLEAN);
        networkTableEntryTypeManager.registerType(DOUBLE);
        networkTableEntryTypeManager.registerType(STRING);
        networkTableEntryTypeManager.registerType(BooleanArray.TYPE);
        networkTableEntryTypeManager.registerType(NumberArray.TYPE);
        networkTableEntryTypeManager.registerType(StringArray.TYPE);
    }
}

