/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.type;

import edu.wpi.first.wpilibj.networktables2.type.ArrayEntryType;
import edu.wpi.first.wpilibj.networktables2.type.ComplexData;

public class ArrayData
extends ComplexData {
    private final ArrayEntryType type;
    private Object[] data = new Object[0];

    public ArrayData(ArrayEntryType arrayEntryType) {
        super(arrayEntryType);
        this.type = arrayEntryType;
    }

    protected Object getAsObject(int n) {
        return this.data[n];
    }

    protected void _set(int n, Object object) {
        this.data[n] = object;
    }

    protected void _add(Object object) {
        this.setSize(this.size() + 1);
        this.data[this.size() - 1] = object;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n < this.size() - 1) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size() - n - 1);
        }
        this.setSize(this.size() - 1);
    }

    public void setSize(int n) {
        if (n == this.data.length) {
            return;
        }
        Object[] objectArray = new Object[n];
        if (n < this.data.length) {
            System.arraycopy(this.data, 0, objectArray, 0, n);
        } else {
            System.arraycopy(this.data, 0, objectArray, 0, this.data.length);
            for (int i = this.data.length; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
        }
        this.data = objectArray;
    }

    public int size() {
        return this.data.length;
    }

    Object[] getDataArray() {
        return this.data;
    }
}

