/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.AbstractNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.TableKeyExistsWithDifferentTypeException;
import edu.wpi.first.wpilibj.networktables2.client.ClientConnectionListenerManager;
import edu.wpi.first.wpilibj.networktables2.type.ComplexData;
import edu.wpi.first.wpilibj.networktables2.type.ComplexEntryType;
import edu.wpi.first.wpilibj.networktables2.type.DefaultEntryTypes;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.util.List;
import edu.wpi.first.wpilibj.tables.IRemote;
import edu.wpi.first.wpilibj.tables.IRemoteConnectionListener;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;

public abstract class NetworkTableNode
implements AbstractNetworkTableEntryStore.TableListenerManager,
ClientConnectionListenerManager,
IRemote {
    protected AbstractNetworkTableEntryStore entryStore;
    private final List remoteListeners = new List();
    private final List tableListeners = new List();

    protected final void init(AbstractNetworkTableEntryStore abstractNetworkTableEntryStore) {
        this.entryStore = abstractNetworkTableEntryStore;
    }

    public AbstractNetworkTableEntryStore getEntryStore() {
        return this.entryStore;
    }

    public void putBoolean(String string, boolean bl) {
        this.putValue(string, DefaultEntryTypes.BOOLEAN, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getBoolean(String string) throws TableKeyNotDefinedException {
        NetworkTableEntry networkTableEntry = this.entryStore.getEntry(string);
        if (networkTableEntry == null) {
            throw new TableKeyNotDefinedException(string);
        }
        return (Boolean)networkTableEntry.getValue();
    }

    public void putDouble(String string, double d) {
        this.putValue(string, DefaultEntryTypes.DOUBLE, new Double(d));
    }

    public double getDouble(String string) throws TableKeyNotDefinedException {
        NetworkTableEntry networkTableEntry = this.entryStore.getEntry(string);
        if (networkTableEntry == null) {
            throw new TableKeyNotDefinedException(string);
        }
        return (Double)networkTableEntry.getValue();
    }

    public void putString(String string, String string2) {
        this.putValue(string, DefaultEntryTypes.STRING, string2);
    }

    public String getString(String string) throws TableKeyNotDefinedException {
        NetworkTableEntry networkTableEntry = this.entryStore.getEntry(string);
        if (networkTableEntry == null) {
            throw new TableKeyNotDefinedException(string);
        }
        return (String)networkTableEntry.getValue();
    }

    public void putComplex(String string, ComplexData complexData) {
        this.putValue(string, complexData.getType(), complexData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveValue(String string, Object object) throws TableKeyNotDefinedException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry networkTableEntry = this.entryStore.getEntry(string);
            if (networkTableEntry == null) {
                throw new TableKeyNotDefinedException(string);
            }
            NetworkTableEntryType networkTableEntryType = networkTableEntry.getType();
            if (!(networkTableEntryType instanceof ComplexEntryType)) {
                throw new TableKeyExistsWithDifferentTypeException(string, networkTableEntryType, "Is not a complex data type");
            }
            ComplexEntryType complexEntryType = (ComplexEntryType)networkTableEntryType;
            complexEntryType.exportValue(string, networkTableEntry.getValue(), object);
        }
    }

    public void putValue(String string, Object object) throws IllegalArgumentException {
        if (object instanceof Double) {
            this.putValue(string, DefaultEntryTypes.DOUBLE, object);
        } else if (object instanceof String) {
            this.putValue(string, DefaultEntryTypes.STRING, object);
        } else if (object instanceof Boolean) {
            this.putValue(string, DefaultEntryTypes.BOOLEAN, object);
        } else if (object instanceof ComplexData) {
            this.putValue(string, ((ComplexData)object).getType(), object);
        } else {
            if (object == null) {
                throw new NullPointerException("Cannot put a null value into networktables");
            }
            throw new IllegalArgumentException("Invalid Type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(String string, NetworkTableEntryType networkTableEntryType, Object object) {
        if (networkTableEntryType instanceof ComplexEntryType) {
            AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                ComplexEntryType complexEntryType = (ComplexEntryType)networkTableEntryType;
                NetworkTableEntry networkTableEntry = this.entryStore.getEntry(string);
                if (networkTableEntry != null) {
                    this.entryStore.putOutgoing(networkTableEntry, complexEntryType.internalizeValue(networkTableEntry.name, object, networkTableEntry.getValue()));
                } else {
                    this.entryStore.putOutgoing(string, networkTableEntryType, complexEntryType.internalizeValue(string, object, null));
                }
            }
        } else {
            this.entryStore.putOutgoing(string, networkTableEntryType, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(NetworkTableEntry networkTableEntry, Object object) {
        if (networkTableEntry.getType() instanceof ComplexEntryType) {
            AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                ComplexEntryType complexEntryType = (ComplexEntryType)networkTableEntry.getType();
                this.entryStore.putOutgoing(networkTableEntry, complexEntryType.internalizeValue(networkTableEntry.name, object, networkTableEntry.getValue()));
            }
        } else {
            this.entryStore.putOutgoing(networkTableEntry, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String string) throws TableKeyNotDefinedException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry networkTableEntry = this.entryStore.getEntry(string);
            if (networkTableEntry == null) {
                throw new TableKeyNotDefinedException(string);
            }
            return networkTableEntry.getValue();
        }
    }

    public boolean containsKey(String string) {
        return this.entryStore.getEntry(string) != null;
    }

    public abstract void close();

    @Override
    public void addConnectionListener(IRemoteConnectionListener iRemoteConnectionListener, boolean bl) {
        this.remoteListeners.add(iRemoteConnectionListener);
        if (this.isConnected()) {
            iRemoteConnectionListener.connected(this);
        } else {
            iRemoteConnectionListener.disconnected(this);
        }
    }

    @Override
    public void removeConnectionListener(IRemoteConnectionListener iRemoteConnectionListener) {
        this.remoteListeners.remove(iRemoteConnectionListener);
    }

    @Override
    public void fireConnectedEvent() {
        for (int i = 0; i < this.remoteListeners.size(); ++i) {
            ((IRemoteConnectionListener)this.remoteListeners.get(i)).connected(this);
        }
    }

    @Override
    public void fireDisconnectedEvent() {
        for (int i = 0; i < this.remoteListeners.size(); ++i) {
            ((IRemoteConnectionListener)this.remoteListeners.get(i)).disconnected(this);
        }
    }

    public void addTableListener(ITableListener iTableListener, boolean bl) {
        this.tableListeners.add(iTableListener);
        if (bl) {
            this.entryStore.notifyEntries(null, iTableListener);
        }
    }

    public void removeTableListener(ITableListener iTableListener) {
        this.tableListeners.remove(iTableListener);
    }

    @Override
    public void fireTableListeners(String string, Object object, boolean bl) {
        for (int i = 0; i < this.tableListeners.size(); ++i) {
            ((ITableListener)this.tableListeners.get(i)).valueChanged(null, string, object, bl);
        }
    }
}

