###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run //wasm_bindgen/3rdparty:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependnecies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normla dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({_CONDITIONS[condition]: deps.values()})

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normla dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": common_items}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        if condition_triples in crate_aliases:
            crate_aliases[condition_triples].update(deps)
        else:
            crate_aliases.update({_CONDITIONS[condition]: dict(deps.items() + common_items)})

    return selects.with_or(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "anyhow": "@rules_rust_wasm_bindgen__anyhow-1.0.58//:anyhow",
            "curl": "@rules_rust_wasm_bindgen__curl-0.4.43//:curl",
            "docopt": "@rules_rust_wasm_bindgen__docopt-1.1.1//:docopt",
            "env_logger": "@rules_rust_wasm_bindgen__env_logger-0.8.4//:env_logger",
            "log": "@rules_rust_wasm_bindgen__log-0.4.17//:log",
            "rouille": "@rules_rust_wasm_bindgen__rouille-3.5.0//:rouille",
            "serde": "@rules_rust_wasm_bindgen__serde-1.0.139//:serde",
            "serde_json": "@rules_rust_wasm_bindgen__serde_json-1.0.82//:serde_json",
            "walrus": "@rules_rust_wasm_bindgen__walrus-0.19.0//:walrus",
            "wasm-bindgen": "@rules_rust_wasm_bindgen__wasm-bindgen-0.2.81//:wasm_bindgen",
            "wasm-bindgen-cli-support": "@rules_rust_wasm_bindgen__wasm-bindgen-cli-support-0.2.81//:wasm_bindgen_cli_support",
            "wasm-bindgen-shared": "@rules_rust_wasm_bindgen__wasm-bindgen-shared-0.2.81//:wasm_bindgen_shared",
        },
    },
}

_NORMAL_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "assert_cmd": "@rules_rust_wasm_bindgen__assert_cmd-1.0.8//:assert_cmd",
            "diff": "@rules_rust_wasm_bindgen__diff-0.1.13//:diff",
            "predicates": "@rules_rust_wasm_bindgen__predicates-1.0.8//:predicates",
            "rayon": "@rules_rust_wasm_bindgen__rayon-1.5.3//:rayon",
            "tempfile": "@rules_rust_wasm_bindgen__tempfile-3.3.0//:tempfile",
            "wasmprinter": "@rules_rust_wasm_bindgen__wasmprinter-0.2.33//:wasmprinter",
            "wit-printer": "@rules_rust_wasm_bindgen__wit-printer-0.2.0//:wit_printer",
            "wit-text": "@rules_rust_wasm_bindgen__wit-text-0.8.0//:wit_text",
            "wit-validator": "@rules_rust_wasm_bindgen__wit-validator-0.2.1//:wit_validator",
            "wit-walrus": "@rules_rust_wasm_bindgen__wit-walrus-0.6.0//:wit_walrus",
        },
    },
}

_NORMAL_DEV_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "": {
        _COMMON_CONDITION: {
            "serde_derive": "@rules_rust_wasm_bindgen__serde_derive-1.0.139//:serde_derive",
        },
    },
}

_PROC_MACRO_ALIASES = {
    "": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "": {
        _COMMON_CONDITION: {
        },
    },
}

_BUILD_DEPENDENCIES = {
    "": {
    },
}

_BUILD_ALIASES = {
    "": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "": {
    },
}

_CONDITIONS = {
    "aarch64-pc-windows-msvc": [],
    "aarch64-uwp-windows-msvc": [],
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"aarch64\"), target_os = \"hermit\"))": [],
    "cfg(all(unix, not(target_os = \"macos\")))": ["aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "x86_64-apple-ios", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(any(target_os = \"macos\", target_os = \"ios\", target_os = \"freebsd\"))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "i686-apple-darwin", "i686-unknown-freebsd", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-unknown-freebsd"],
    "cfg(any(unix, target_os = \"wasi\"))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(not(windows))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "s390x-unknown-linux-gnu", "wasm32-unknown-unknown", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(target_arch = \"wasm32\")": ["wasm32-unknown-unknown", "wasm32-wasi"],
    "cfg(target_env = \"msvc\")": ["i686-pc-windows-msvc", "x86_64-pc-windows-msvc"],
    "cfg(target_family = \"unix\")": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"wasi\")": ["wasm32-wasi"],
    "cfg(unix)": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(windows)": ["i686-pc-windows-msvc", "x86_64-pc-windows-msvc"],
    "i686-pc-windows-gnu": [],
    "i686-pc-windows-msvc": ["i686-pc-windows-msvc"],
    "i686-uwp-windows-gnu": [],
    "i686-uwp-windows-msvc": [],
    "x86_64-pc-windows-gnu": [],
    "x86_64-pc-windows-msvc": ["x86_64-pc-windows-msvc"],
    "x86_64-uwp-windows-gnu": [],
    "x86_64-uwp-windows-msvc": [],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates"""
    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__aho-corasick-0.7.18",
        sha256 = "1e37cfd5e7657ada45f742d6e99ca5788580b5c529dc78faf11ece6dc702656f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/aho-corasick/0.7.18/download"],
        strip_prefix = "aho-corasick-0.7.18",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.aho-corasick-0.7.18.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__anyhow-1.0.58",
        sha256 = "bb07d2053ccdbe10e2af2995a2f116c1330396493dc1269f6a91d0ae82e19704",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/anyhow/1.0.58/download"],
        strip_prefix = "anyhow-1.0.58",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.anyhow-1.0.58.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__ascii-1.0.0",
        sha256 = "bbf56136a5198c7b01a49e3afcbef6cf84597273d298f54432926024107b0109",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ascii/1.0.0/download"],
        strip_prefix = "ascii-1.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.ascii-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__assert_cmd-1.0.8",
        sha256 = "c98233c6673d8601ab23e77eb38f999c51100d46c5703b17288c57fddf3a1ffe",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/assert_cmd/1.0.8/download"],
        strip_prefix = "assert_cmd-1.0.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.assert_cmd-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__atty-0.2.14",
        sha256 = "d9b39be18770d11421cdb1b9947a45dd3f37e93092cbf377614828a319d5fee8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/atty/0.2.14/download"],
        strip_prefix = "atty-0.2.14",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.atty-0.2.14.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__base64-0.13.0",
        sha256 = "904dfeac50f3cdaba28fc6f57fdcddb75f49ed61346676a78c4ffe55877802fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/base64/0.13.0/download"],
        strip_prefix = "base64-0.13.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.base64-0.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__base64-0.9.3",
        sha256 = "489d6c0ed21b11d038c31b6ceccca973e65d73ba3bd8ecb9a2babf5546164643",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/base64/0.9.3/download"],
        strip_prefix = "base64-0.9.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.base64-0.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__bstr-0.2.17",
        sha256 = "ba3569f383e8f1598449f1a423e72e99569137b47740b1da11ef19af3d5c3223",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bstr/0.2.17/download"],
        strip_prefix = "bstr-0.2.17",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.bstr-0.2.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__buf_redux-0.8.4",
        sha256 = "b953a6887648bb07a535631f2bc00fbdb2a2216f135552cb3f534ed136b9c07f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/buf_redux/0.8.4/download"],
        strip_prefix = "buf_redux-0.8.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.buf_redux-0.8.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__bumpalo-3.10.0",
        sha256 = "37ccbd214614c6783386c1af30caf03192f17891059cecc394b4fb119e363de3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bumpalo/3.10.0/download"],
        strip_prefix = "bumpalo-3.10.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.bumpalo-3.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__byteorder-1.4.3",
        sha256 = "14c189c53d098945499cdfa7ecc63567cf3886b3332b312a5b4585d8d3a6a610",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/byteorder/1.4.3/download"],
        strip_prefix = "byteorder-1.4.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.byteorder-1.4.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cc-1.0.73",
        sha256 = "2fff2a6927b3bb87f9595d67196a70493f627687a71d87a0d692242c33f58c11",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cc/1.0.73/download"],
        strip_prefix = "cc-1.0.73",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cc-1.0.73.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__chrono-0.4.19",
        sha256 = "670ad68c9088c2a963aaa298cb369688cf3f9465ce5e2d4ca10e6e0098a1ce73",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/chrono/0.4.19/download"],
        strip_prefix = "chrono-0.4.19",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.chrono-0.4.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__chunked_transfer-1.4.0",
        sha256 = "fff857943da45f546682664a79488be82e69e43c1a7a2307679ab9afb3a66d2e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/chunked_transfer/1.4.0/download"],
        strip_prefix = "chunked_transfer-1.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.chunked_transfer-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-channel-0.5.5",
        sha256 = "4c02a4d71819009c192cf4872265391563fd6a84c81ff2c0f2a7026ca4c1d85c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-channel/0.5.5/download"],
        strip_prefix = "crossbeam-channel-0.5.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-channel-0.5.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-deque-0.8.1",
        sha256 = "6455c0ca19f0d2fbf751b908d5c55c1f5cbc65e03c4225427254b46890bdde1e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-deque/0.8.1/download"],
        strip_prefix = "crossbeam-deque-0.8.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-deque-0.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-epoch-0.9.9",
        sha256 = "07db9d94cbd326813772c968ccd25999e5f8ae22f4f8d1b11effa37ef6ce281d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-epoch/0.9.9/download"],
        strip_prefix = "crossbeam-epoch-0.9.9",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-epoch-0.9.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__crossbeam-utils-0.8.10",
        sha256 = "7d82ee10ce34d7bc12c2122495e7593a9c41347ecdd64185af4ecf72cb1a7f83",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/crossbeam-utils/0.8.10/download"],
        strip_prefix = "crossbeam-utils-0.8.10",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.crossbeam-utils-0.8.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__curl-0.4.43",
        sha256 = "37d855aeef205b43f65a5001e0997d81f8efca7badad4fad7d897aa7f0d0651f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/curl/0.4.43/download"],
        strip_prefix = "curl-0.4.43",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.curl-0.4.43.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__curl-sys-0.4.55-curl-7.83.1",
        sha256 = "23734ec77368ec583c2e61dd3f0b0e5c98b93abe6d2a004ca06b91dd7e3e2762",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/curl-sys/0.4.55+curl-7.83.1/download"],
        strip_prefix = "curl-sys-0.4.55+curl-7.83.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.curl-sys-0.4.55+curl-7.83.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__diff-0.1.13",
        sha256 = "56254986775e3233ffa9c4d7d3faaf6d36a2c09d30b20687e9f88bc8bafc16c8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/diff/0.1.13/download"],
        strip_prefix = "diff-0.1.13",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.diff-0.1.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__difference-2.0.0",
        sha256 = "524cbf6897b527295dff137cec09ecf3a05f4fddffd7dfcd1585403449e74198",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/difference/2.0.0/download"],
        strip_prefix = "difference-2.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.difference-2.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__difflib-0.4.0",
        sha256 = "6184e33543162437515c2e2b48714794e37845ec9851711914eec9d308f6ebe8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/difflib/0.4.0/download"],
        strip_prefix = "difflib-0.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.difflib-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__doc-comment-0.3.3",
        sha256 = "fea41bba32d969b513997752735605054bc0dfa92b4c56bf1189f2e174be7a10",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/doc-comment/0.3.3/download"],
        strip_prefix = "doc-comment-0.3.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.doc-comment-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__docopt-1.1.1",
        sha256 = "7f3f119846c823f9eafcf953a8f6ffb6ed69bf6240883261a7f13b634579a51f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/docopt/1.1.1/download"],
        strip_prefix = "docopt-1.1.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.docopt-1.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__either-1.7.0",
        sha256 = "3f107b87b6afc2a64fd13cac55fe06d6c8859f12d4b14cbcdd2c67d0976781be",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/either/1.7.0/download"],
        strip_prefix = "either-1.7.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.either-1.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__env_logger-0.8.4",
        sha256 = "a19187fea3ac7e84da7dacf48de0c45d63c6a76f9490dae389aead16c243fce3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/env_logger/0.8.4/download"],
        strip_prefix = "env_logger-0.8.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.env_logger-0.8.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__fastrand-1.7.0",
        sha256 = "c3fcf0cee53519c866c09b5de1f6c56ff9d647101f81c1964fa632e148896cdf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fastrand/1.7.0/download"],
        strip_prefix = "fastrand-1.7.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.fastrand-1.7.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__filetime-0.2.17",
        sha256 = "e94a7bbaa59354bc20dd75b67f23e2797b4490e9d6928203fb105c79e448c86c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/filetime/0.2.17/download"],
        strip_prefix = "filetime-0.2.17",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.filetime-0.2.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__float-cmp-0.8.0",
        sha256 = "e1267f4ac4f343772758f7b1bdcbe767c218bbab93bb432acbf5162bbf85a6c4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/float-cmp/0.8.0/download"],
        strip_prefix = "float-cmp-0.8.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.float-cmp-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__form_urlencoded-1.0.1",
        sha256 = "5fc25a87fa4fd2094bffb06925852034d90a17f0d1e05197d4956d3555752191",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/form_urlencoded/1.0.1/download"],
        strip_prefix = "form_urlencoded-1.0.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.form_urlencoded-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__getrandom-0.2.7",
        sha256 = "4eb1a864a501629691edf6c15a593b7a51eebaa1e8468e9ddc623de7c9b58ec6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/getrandom/0.2.7/download"],
        strip_prefix = "getrandom-0.2.7",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.getrandom-0.2.7.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__heck-0.3.3",
        sha256 = "6d621efb26863f0e9924c6ac577e8275e5e6b77455db64ffa6c65c904e9e132c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/heck/0.3.3/download"],
        strip_prefix = "heck-0.3.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.heck-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__hermit-abi-0.1.19",
        sha256 = "62b467343b94ba476dcb2500d242dadbb39557df889310ac77c5d99100aaac33",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.1.19/download"],
        strip_prefix = "hermit-abi-0.1.19",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.hermit-abi-0.1.19.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__httparse-1.7.1",
        sha256 = "496ce29bb5a52785b44e0f7ca2847ae0bb839c9bd28f69acac9b99d461c0c04c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/httparse/1.7.1/download"],
        strip_prefix = "httparse-1.7.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.httparse-1.7.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__humantime-2.1.0",
        sha256 = "9a3a5bfb195931eeb336b2a7b4d761daec841b97f947d34394601737a7bba5e4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/humantime/2.1.0/download"],
        strip_prefix = "humantime-2.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.humantime-2.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__id-arena-2.2.1",
        sha256 = "25a2bc672d1148e28034f176e01fffebb08b35768468cc954630da77a1449005",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/id-arena/2.2.1/download"],
        strip_prefix = "id-arena-2.2.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.id-arena-2.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__idna-0.2.3",
        sha256 = "418a0a6fab821475f634efe3ccc45c013f742efe03d853e8d3355d5cb850ecf8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/idna/0.2.3/download"],
        strip_prefix = "idna-0.2.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.idna-0.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__instant-0.1.12",
        sha256 = "7a5bbe824c507c5da5956355e86a746d82e0e1464f65d862cc5e71da70e94b2c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/instant/0.1.12/download"],
        strip_prefix = "instant-0.1.12",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.instant-0.1.12.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__itertools-0.10.3",
        sha256 = "a9a9d19fa1e79b6215ff29b9d6880b706147f16e9b1dbb1e4e5947b5b02bc5e3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/itertools/0.10.3/download"],
        strip_prefix = "itertools-0.10.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.itertools-0.10.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__itoa-1.0.2",
        sha256 = "112c678d4050afce233f4f2852bb2eb519230b3cf12f33585275537d7e41578d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/itoa/1.0.2/download"],
        strip_prefix = "itoa-1.0.2",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.itoa-1.0.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__lazy_static-1.4.0",
        sha256 = "e2abad23fbc42b3700f2f279844dc832adb2b2eb069b2df918f455c4e18cc646",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lazy_static/1.4.0/download"],
        strip_prefix = "lazy_static-1.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.lazy_static-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__leb128-0.2.5",
        sha256 = "884e2677b40cc8c339eaefcb701c32ef1fd2493d71118dc0ca4b6a736c93bd67",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/leb128/0.2.5/download"],
        strip_prefix = "leb128-0.2.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.leb128-0.2.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__libc-0.2.126",
        sha256 = "349d5a591cd28b49e1d1037471617a32ddcda5731b99419008085f72d5a53836",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libc/0.2.126/download"],
        strip_prefix = "libc-0.2.126",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.libc-0.2.126.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__libz-sys-1.1.8",
        sha256 = "9702761c3935f8cc2f101793272e202c72b99da8f4224a19ddcf1279a6450bbf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libz-sys/1.1.8/download"],
        strip_prefix = "libz-sys-1.1.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.libz-sys-1.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__log-0.4.17",
        sha256 = "abb12e687cfb44aa40f41fc3978ef76448f9b6038cad6aef4259d3c095a2382e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/log/0.4.17/download"],
        strip_prefix = "log-0.4.17",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.log-0.4.17.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__matches-0.1.9",
        sha256 = "a3e378b66a060d48947b590737b30a1be76706c8dd7b8ba0f2fe3989c68a853f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/matches/0.1.9/download"],
        strip_prefix = "matches-0.1.9",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.matches-0.1.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__memchr-2.5.0",
        sha256 = "2dffe52ecf27772e601905b7522cb4ef790d2cc203488bbd0e2fe85fcb74566d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/memchr/2.5.0/download"],
        strip_prefix = "memchr-2.5.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.memchr-2.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__memoffset-0.6.5",
        sha256 = "5aa361d4faea93603064a027415f07bd8e1d5c88c9fbf68bf56a285428fd79ce",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/memoffset/0.6.5/download"],
        strip_prefix = "memoffset-0.6.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.memoffset-0.6.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__mime-0.3.16",
        sha256 = "2a60c7ce501c71e03a9c9c0d35b861413ae925bd979cc7a4e30d060069aaac8d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mime/0.3.16/download"],
        strip_prefix = "mime-0.3.16",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.mime-0.3.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__mime_guess-2.0.4",
        sha256 = "4192263c238a5f0d0c6bfd21f336a313a4ce1c450542449ca191bb657b4642ef",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mime_guess/2.0.4/download"],
        strip_prefix = "mime_guess-2.0.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.mime_guess-2.0.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__multipart-0.18.0",
        sha256 = "00dec633863867f29cb39df64a397cdf4a6354708ddd7759f70c7fb51c5f9182",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/multipart/0.18.0/download"],
        strip_prefix = "multipart-0.18.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.multipart-0.18.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__normalize-line-endings-0.3.0",
        sha256 = "61807f77802ff30975e01f4f071c8ba10c022052f98b3294119f3e615d13e5be",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/normalize-line-endings/0.3.0/download"],
        strip_prefix = "normalize-line-endings-0.3.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.normalize-line-endings-0.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num-integer-0.1.45",
        sha256 = "225d3389fb3509a24c93f5c29eb6bde2586b98d9f016636dff58d7c6f7569cd9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-integer/0.1.45/download"],
        strip_prefix = "num-integer-0.1.45",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num-integer-0.1.45.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num-traits-0.2.15",
        sha256 = "578ede34cf02f8924ab9447f50c28075b4d3e5b269972345e7e0372b38c6cdcd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num-traits/0.2.15/download"],
        strip_prefix = "num-traits-0.2.15",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num-traits-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num_cpus-1.13.1",
        sha256 = "19e64526ebdee182341572e50e9ad03965aa510cd94427a4549448f285e957a1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_cpus/1.13.1/download"],
        strip_prefix = "num_cpus-1.13.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num_cpus-1.13.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__num_threads-0.1.6",
        sha256 = "2819ce041d2ee131036f4fc9d6ae7ae125a3a40e97ba64d04fe799ad9dabbb44",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_threads/0.1.6/download"],
        strip_prefix = "num_threads-0.1.6",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.num_threads-0.1.6.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__once_cell-1.13.0",
        sha256 = "18a6dbe30758c9f83eb00cbea4ac95966305f5a7772f3f42ebfc7fc7eddbd8e1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/once_cell/1.13.0/download"],
        strip_prefix = "once_cell-1.13.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.once_cell-1.13.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__openssl-probe-0.1.5",
        sha256 = "ff011a302c396a5197692431fc1948019154afc178baf7d8e37367442a4601cf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/openssl-probe/0.1.5/download"],
        strip_prefix = "openssl-probe-0.1.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.openssl-probe-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__openssl-sys-0.9.75",
        sha256 = "e5f9bd0c2710541a3cda73d6f9ac4f1b240de4ae261065d309dbe73d9dceb42f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/openssl-sys/0.9.75/download"],
        strip_prefix = "openssl-sys-0.9.75",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.openssl-sys-0.9.75.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__percent-encoding-2.1.0",
        sha256 = "d4fd5641d01c8f18a23da7b6fe29298ff4b55afcccdf78973b24cf3175fee32e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/percent-encoding/2.1.0/download"],
        strip_prefix = "percent-encoding-2.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.percent-encoding-2.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__pkg-config-0.3.25",
        sha256 = "1df8c4ec4b0627e53bdf214615ad287367e482558cf84b109250b37464dc03ae",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pkg-config/0.3.25/download"],
        strip_prefix = "pkg-config-0.3.25",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.pkg-config-0.3.25.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__ppv-lite86-0.2.16",
        sha256 = "eb9f9e6e233e5c4a35559a617bf40a4ec447db2e84c20b55a6f83167b7e57872",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ppv-lite86/0.2.16/download"],
        strip_prefix = "ppv-lite86-0.2.16",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.ppv-lite86-0.2.16.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-1.0.8",
        sha256 = "f49cfaf7fdaa3bfacc6fa3e7054e65148878354a5cfddcf661df4c851f8021df",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates/1.0.8/download"],
        strip_prefix = "predicates-1.0.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-1.0.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-2.1.1",
        sha256 = "a5aab5be6e4732b473071984b3164dbbfb7a3674d30ea5ff44410b6bcd960c3c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates/2.1.1/download"],
        strip_prefix = "predicates-2.1.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-2.1.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-core-1.0.3",
        sha256 = "da1c2388b1513e1b605fcec39a95e0a9e8ef088f71443ef37099fa9ae6673fcb",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates-core/1.0.3/download"],
        strip_prefix = "predicates-core-1.0.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-core-1.0.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__predicates-tree-1.0.5",
        sha256 = "4d86de6de25020a36c6d3643a86d9a6a9f552107c0559c60ea03551b5e16c032",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/predicates-tree/1.0.5/download"],
        strip_prefix = "predicates-tree-1.0.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.predicates-tree-1.0.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__proc-macro2-1.0.40",
        sha256 = "dd96a1e8ed2596c337f8eae5f24924ec83f5ad5ab21ea8e455d3566c69fbcaf7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro2/1.0.40/download"],
        strip_prefix = "proc-macro2-1.0.40",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.proc-macro2-1.0.40.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__quick-error-1.2.3",
        sha256 = "a1d01941d82fa2ab50be1e79e6714289dd7cde78eba4c074bc5a4374f650dfe0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quick-error/1.2.3/download"],
        strip_prefix = "quick-error-1.2.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.quick-error-1.2.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__quote-1.0.20",
        sha256 = "3bcdf212e9776fbcb2d23ab029360416bb1706b1aea2d1a5ba002727cbcab804",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quote/1.0.20/download"],
        strip_prefix = "quote-1.0.20",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.quote-1.0.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rand-0.8.5",
        sha256 = "34af8d1a0e25924bc5b7c43c079c942339d8f0a8b57c39049bef581b46327404",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand/0.8.5/download"],
        strip_prefix = "rand-0.8.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rand-0.8.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rand_chacha-0.3.1",
        sha256 = "e6c10a63a0fa32252be49d21e7709d4d4baf8d231c2dbce1eaa8141b9b127d88",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_chacha/0.3.1/download"],
        strip_prefix = "rand_chacha-0.3.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rand_chacha-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rand_core-0.6.3",
        sha256 = "d34f1408f55294453790c48b2f1ebbb1c5b4b7563eb1f418bcfcfdbb06ebb4e7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rand_core/0.6.3/download"],
        strip_prefix = "rand_core-0.6.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rand_core-0.6.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rayon-1.5.3",
        sha256 = "bd99e5772ead8baa5215278c9b15bf92087709e9c1b2d1f97cdb5a183c933a7d",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rayon/1.5.3/download"],
        strip_prefix = "rayon-1.5.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rayon-1.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rayon-core-1.9.3",
        sha256 = "258bcdb5ac6dad48491bb2992db6b7cf74878b0384908af124823d118c99683f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rayon-core/1.9.3/download"],
        strip_prefix = "rayon-core-1.9.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rayon-core-1.9.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__redox_syscall-0.2.13",
        sha256 = "62f25bc4c7e55e0b0b7a1d43fb893f4fa1361d0abe38b9ce4f323c2adfe6ef42",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/redox_syscall/0.2.13/download"],
        strip_prefix = "redox_syscall-0.2.13",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.redox_syscall-0.2.13.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__regex-1.6.0",
        sha256 = "4c4eb3267174b8c6c2f654116623910a0fef09c4753f8dd83db29c48a0df988b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex/1.6.0/download"],
        strip_prefix = "regex-1.6.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.regex-1.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__regex-automata-0.1.10",
        sha256 = "6c230d73fb8d8c1b9c0b3135c5142a8acee3a0558fb8db5cf1cb65f8d7862132",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex-automata/0.1.10/download"],
        strip_prefix = "regex-automata-0.1.10",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.regex-automata-0.1.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__regex-syntax-0.6.27",
        sha256 = "a3f87b73ce11b1619a3c6332f45341e0047173771e8b8b73f87bfeefb7b56244",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/regex-syntax/0.6.27/download"],
        strip_prefix = "regex-syntax-0.6.27",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.regex-syntax-0.6.27.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__remove_dir_all-0.5.3",
        sha256 = "3acd125665422973a33ac9d3dd2df85edad0f4ae9b00dafb1a05e43a9f5ef8e7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/remove_dir_all/0.5.3/download"],
        strip_prefix = "remove_dir_all-0.5.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.remove_dir_all-0.5.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rouille-3.5.0",
        sha256 = "18b2380c42510ef4a28b5f228a174c801e0dec590103e215e60812e2e2f34d05",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rouille/3.5.0/download"],
        strip_prefix = "rouille-3.5.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rouille-3.5.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__rustc-demangle-0.1.21",
        sha256 = "7ef03e0a2b150c7a90d01faf6254c9c48a41e95fb2a8c2ac1c6f0d2b9aefc342",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rustc-demangle/0.1.21/download"],
        strip_prefix = "rustc-demangle-0.1.21",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.rustc-demangle-0.1.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__ryu-1.0.10",
        sha256 = "f3f6f92acf49d1b98f7a81226834412ada05458b7364277387724a237f062695",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/ryu/1.0.10/download"],
        strip_prefix = "ryu-1.0.10",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.ryu-1.0.10.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__safemem-0.3.3",
        sha256 = "ef703b7cb59335eae2eb93ceb664c0eb7ea6bf567079d843e09420219668e072",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/safemem/0.3.3/download"],
        strip_prefix = "safemem-0.3.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.safemem-0.3.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__schannel-0.1.20",
        sha256 = "88d6731146462ea25d9244b2ed5fd1d716d25c52e4d54aa4fb0f3c4e9854dbe2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/schannel/0.1.20/download"],
        strip_prefix = "schannel-0.1.20",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.schannel-0.1.20.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__scopeguard-1.1.0",
        sha256 = "d29ab0c6d3fc0ee92fe66e2d99f700eab17a8d57d1c1d3b748380fb20baa78cd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/scopeguard/1.1.0/download"],
        strip_prefix = "scopeguard-1.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.scopeguard-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__serde-1.0.139",
        sha256 = "0171ebb889e45aa68b44aee0859b3eede84c6f5f5c228e6f140c0b2a0a46cad6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde/1.0.139/download"],
        strip_prefix = "serde-1.0.139",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.serde-1.0.139.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__serde_derive-1.0.139",
        sha256 = "dc1d3230c1de7932af58ad8ffbe1d784bd55efd5a9d84ac24f69c72d83543dfb",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_derive/1.0.139/download"],
        strip_prefix = "serde_derive-1.0.139",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.serde_derive-1.0.139.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__serde_json-1.0.82",
        sha256 = "82c2c1fdcd807d1098552c5b9a36e425e42e9fbd7c6a37a8425f390f781f7fa7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/serde_json/1.0.82/download"],
        strip_prefix = "serde_json-1.0.82",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.serde_json-1.0.82.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__sha1-0.6.1",
        sha256 = "c1da05c97445caa12d05e848c4a4fcbbea29e748ac28f7e80e9b010392063770",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sha1/0.6.1/download"],
        strip_prefix = "sha1-0.6.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.sha1-0.6.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__sha1_smol-1.0.0",
        sha256 = "ae1a47186c03a32177042e55dbc5fd5aee900b8e0069a8d70fba96a9375cd012",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/sha1_smol/1.0.0/download"],
        strip_prefix = "sha1_smol-1.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.sha1_smol-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__socket2-0.4.4",
        sha256 = "66d72b759436ae32898a2af0a14218dbf55efde3feeb170eb623637db85ee1e0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/socket2/0.4.4/download"],
        strip_prefix = "socket2-0.4.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.socket2-0.4.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__strsim-0.10.0",
        sha256 = "73473c0e59e6d5812c5dfe2a064a6444949f089e20eec9a2e5506596494e4623",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/strsim/0.10.0/download"],
        strip_prefix = "strsim-0.10.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.strsim-0.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__syn-1.0.98",
        sha256 = "c50aef8a904de4c23c788f104b7dddc7d6f79c647c7c8ce4cc8f73eb0ca773dd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/syn/1.0.98/download"],
        strip_prefix = "syn-1.0.98",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.syn-1.0.98.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tempfile-3.3.0",
        sha256 = "5cdb1ef4eaeeaddc8fbd371e5017057064af0911902ef36b39801f67cc6d79e4",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tempfile/3.3.0/download"],
        strip_prefix = "tempfile-3.3.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tempfile-3.3.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__termcolor-1.1.3",
        sha256 = "bab24d30b911b2376f3a13cc2cd443142f0c81dda04c118693e35b3835757755",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/termcolor/1.1.3/download"],
        strip_prefix = "termcolor-1.1.3",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.termcolor-1.1.3.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__termtree-0.2.4",
        sha256 = "507e9898683b6c43a9aa55b64259b721b52ba226e0f3779137e50ad114a4c90b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/termtree/0.2.4/download"],
        strip_prefix = "termtree-0.2.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.termtree-0.2.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__threadpool-1.8.1",
        sha256 = "d050e60b33d41c19108b32cea32164033a9013fe3b46cbd4457559bfbf77afaa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/threadpool/1.8.1/download"],
        strip_prefix = "threadpool-1.8.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.threadpool-1.8.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__time-0.3.11",
        sha256 = "72c91f41dcb2f096c05f0873d667dceec1087ce5bcf984ec8ffb19acddbb3217",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/time/0.3.11/download"],
        strip_prefix = "time-0.3.11",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.time-0.3.11.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tiny_http-0.8.2",
        sha256 = "9ce51b50006056f590c9b7c3808c3bd70f0d1101666629713866c227d6e58d39",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tiny_http/0.8.2/download"],
        strip_prefix = "tiny_http-0.8.2",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tiny_http-0.8.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tinyvec-1.6.0",
        sha256 = "87cc5ceb3875bb20c2890005a4e226a4651264a5c75edb2421b52861a0a0cb50",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tinyvec/1.6.0/download"],
        strip_prefix = "tinyvec-1.6.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tinyvec-1.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__tinyvec_macros-0.1.0",
        sha256 = "cda74da7e1a664f795bb1f8a87ec406fb89a02522cf6e50620d016add6dbbf5c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tinyvec_macros/0.1.0/download"],
        strip_prefix = "tinyvec_macros-0.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.tinyvec_macros-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__twoway-0.1.8",
        sha256 = "59b11b2b5241ba34be09c3cc85a36e56e48f9888862e19cedf23336d35316ed1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/twoway/0.1.8/download"],
        strip_prefix = "twoway-0.1.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.twoway-0.1.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicase-2.6.0",
        sha256 = "50f37be617794602aabbeee0be4f259dc1778fabe05e2d67ee8f79326d5cb4f6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicase/2.6.0/download"],
        strip_prefix = "unicase-2.6.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicase-2.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-bidi-0.3.8",
        sha256 = "099b7128301d285f79ddd55b9a83d5e6b9e97c92e0ea0daebee7263e932de992",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-bidi/0.3.8/download"],
        strip_prefix = "unicode-bidi-0.3.8",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-bidi-0.3.8.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-ident-1.0.1",
        sha256 = "5bd2fe26506023ed7b5e1e315add59d6f584c621d037f9368fea9cfb988f368c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-ident/1.0.1/download"],
        strip_prefix = "unicode-ident-1.0.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-ident-1.0.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-normalization-0.1.21",
        sha256 = "854cbdc4f7bc6ae19c820d44abdc3277ac3e1b2b93db20a636825d9322fb60e6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-normalization/0.1.21/download"],
        strip_prefix = "unicode-normalization-0.1.21",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-normalization-0.1.21.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__unicode-segmentation-1.9.0",
        sha256 = "7e8820f5d777f6224dc4be3632222971ac30164d4a258d595640799554ebfd99",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-segmentation/1.9.0/download"],
        strip_prefix = "unicode-segmentation-1.9.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.unicode-segmentation-1.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__url-2.2.2",
        sha256 = "a507c383b2d33b5fc35d1861e77e6b383d158b2da5e14fe51b83dfedf6fd578c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/url/2.2.2/download"],
        strip_prefix = "url-2.2.2",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.url-2.2.2.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__vcpkg-0.2.15",
        sha256 = "accd4ea62f7bb7a82fe23066fb0957d48ef677f6eeb8215f372f52e48bb32426",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/vcpkg/0.2.15/download"],
        strip_prefix = "vcpkg-0.2.15",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.vcpkg-0.2.15.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__version_check-0.9.4",
        sha256 = "49874b5167b65d7193b8aba1567f5c7d93d001cafc34600cee003eda787e483f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/version_check/0.9.4/download"],
        strip_prefix = "version_check-0.9.4",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.version_check-0.9.4.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wait-timeout-0.2.0",
        sha256 = "9f200f5b12eb75f8c1ed65abd4b2db8a6e1b138a20de009dacee265a2498f3f6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wait-timeout/0.2.0/download"],
        strip_prefix = "wait-timeout-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wait-timeout-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__walrus-0.19.0",
        sha256 = "4eb08e48cde54c05f363d984bb54ce374f49e242def9468d2e1b6c2372d291f8",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/walrus/0.19.0/download"],
        strip_prefix = "walrus-0.19.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.walrus-0.19.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__walrus-macro-0.19.0",
        sha256 = "0a6e5bd22c71e77d60140b0bd5be56155a37e5bd14e24f5f87298040d0cc40d7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/walrus-macro/0.19.0/download"],
        strip_prefix = "walrus-macro-0.19.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.walrus-macro-0.19.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasi-0.11.0-wasi-snapshot-preview1",
        sha256 = "9c8d87e72b64a3b4db28d11ce29237c246188f4f51057d65a7eab63b7987e423",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasi/0.11.0+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.0+wasi-snapshot-preview1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasi-0.11.0+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-0.2.81",
        sha256 = "7c53b543413a17a202f4be280a7e5c62a1c69345f5de525ee64f8cfdbc954994",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen/0.2.81/download"],
        strip_prefix = "wasm-bindgen-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-backend-0.2.81",
        sha256 = "5491a68ab4500fa6b4d726bd67408630c3dbe9c4fe7bda16d5c82a1fd8c7340a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-backend/0.2.81/download"],
        strip_prefix = "wasm-bindgen-backend-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-backend-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-cli-support-0.2.81",
        sha256 = "4016fbd42224de21aab2f009aeaec61067d278a298ba7f8f7f8d40fbffea0822",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-cli-support/0.2.81/download"],
        strip_prefix = "wasm-bindgen-cli-support-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-cli-support-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-externref-xform-0.2.81",
        sha256 = "f33c8e2d3f3b6f6647f982911eb4cb44998c8cca97a4fe7afc99f616ebb33a73",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-externref-xform/0.2.81/download"],
        strip_prefix = "wasm-bindgen-externref-xform-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-externref-xform-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-macro-0.2.81",
        sha256 = "c441e177922bc58f1e12c022624b6216378e5febc2f0533e41ba443d505b80aa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-macro/0.2.81/download"],
        strip_prefix = "wasm-bindgen-macro-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-macro-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-macro-support-0.2.81",
        sha256 = "7d94ac45fcf608c1f45ef53e748d35660f168490c10b23704c7779ab8f5c3048",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-macro-support/0.2.81/download"],
        strip_prefix = "wasm-bindgen-macro-support-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-macro-support-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-multi-value-xform-0.2.81",
        sha256 = "7015b54357604811162710d5cf274ab85d974fe1e324222dd5b2133afdefe9b9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-multi-value-xform/0.2.81/download"],
        strip_prefix = "wasm-bindgen-multi-value-xform-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-multi-value-xform-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-shared-0.2.81",
        sha256 = "6a89911bd99e5f3659ec4acf9c4d93b0a90fe4a2a11f15328472058edc5261be",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-shared/0.2.81/download"],
        strip_prefix = "wasm-bindgen-shared-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-shared-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-threads-xform-0.2.81",
        sha256 = "6961b838d9a9c121ba4a1eea1628014cc759469e3defb42bbac9c5ed0f65be14",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-threads-xform/0.2.81/download"],
        strip_prefix = "wasm-bindgen-threads-xform-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-threads-xform-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-wasm-conventions-0.2.81",
        sha256 = "c0a0eca38fe89471f57d6903f3e17e732d2d6f995a7af5b23f27df7fee0f0d18",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-wasm-conventions/0.2.81/download"],
        strip_prefix = "wasm-bindgen-wasm-conventions-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-wasm-conventions-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasm-bindgen-wasm-interpreter-0.2.81",
        sha256 = "0b1c9fb7f71137840932bbb853ef1f83d68c88584b716c9bbae38675c9fb8b86",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasm-bindgen-wasm-interpreter/0.2.81/download"],
        strip_prefix = "wasm-bindgen-wasm-interpreter-0.2.81",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasm-bindgen-wasm-interpreter-0.2.81.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmparser-0.59.0",
        sha256 = "a950e6a618f62147fd514ff445b2a0b53120d382751960797f85f058c7eda9b9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmparser/0.59.0/download"],
        strip_prefix = "wasmparser-0.59.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmparser-0.59.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmparser-0.77.0",
        sha256 = "b35c86d22e720a07d954ebbed772d01180501afe7d03d464f413bb5f8914a8d6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmparser/0.77.0/download"],
        strip_prefix = "wasmparser-0.77.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmparser-0.77.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmparser-0.83.0",
        sha256 = "718ed7c55c2add6548cca3ddd6383d738cd73b892df400e96b9aa876f0141d7a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmparser/0.83.0/download"],
        strip_prefix = "wasmparser-0.83.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmparser-0.83.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wasmprinter-0.2.33",
        sha256 = "f973822fb3ca7e03ab421910274514b405df19a3d53acb131ae4df3a2fc4eb58",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasmprinter/0.2.33/download"],
        strip_prefix = "wasmprinter-0.2.33",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wasmprinter-0.2.33.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wast-21.0.0",
        sha256 = "0b1844f66a2bc8526d71690104c0e78a8e59ffa1597b7245769d174ebb91deb5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wast/21.0.0/download"],
        strip_prefix = "wast-21.0.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wast-21.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-util-0.1.5",
        sha256 = "70ec6ce85bb158151cae5e5c87f95a8e97d2c0c4b001223f33a334e3ce5de178",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-util/0.1.5/download"],
        strip_prefix = "winapi-util-0.1.5",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-util-0.1.5.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows-sys-0.36.1",
        sha256 = "ea04155a16a59f9eab786fe12a4a450e75cdb175f9e0d80da1e17db09f55b8d2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-sys/0.36.1/download"],
        strip_prefix = "windows-sys-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows-sys-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_aarch64_msvc-0.36.1",
        sha256 = "9bb8c3fd39ade2d67e9874ac4f3db21f0d710bee00fe7cab16949ec184eeaa47",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_msvc/0.36.1/download"],
        strip_prefix = "windows_aarch64_msvc-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_aarch64_msvc-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_i686_gnu-0.36.1",
        sha256 = "180e6ccf01daf4c426b846dfc66db1fc518f074baa793aa7d9b9aaeffad6a3b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_gnu/0.36.1/download"],
        strip_prefix = "windows_i686_gnu-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_i686_gnu-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_i686_msvc-0.36.1",
        sha256 = "e2e7917148b2812d1eeafaeb22a97e4813dfa60a3f8f78ebe204bcc88f12f024",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_msvc/0.36.1/download"],
        strip_prefix = "windows_i686_msvc-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_i686_msvc-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_x86_64_gnu-0.36.1",
        sha256 = "4dcd171b8776c41b97521e5da127a2d86ad280114807d0b2ab1e462bc764d9e1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnu/0.36.1/download"],
        strip_prefix = "windows_x86_64_gnu-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_x86_64_gnu-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__windows_x86_64_msvc-0.36.1",
        sha256 = "c811ca4a8c853ef420abd8592ba53ddbbac90410fab6903b3e79972a631f7680",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_msvc/0.36.1/download"],
        strip_prefix = "windows_x86_64_msvc-0.36.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.windows_x86_64_msvc-0.36.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-parser-0.2.0",
        sha256 = "3f5fd97866f4b9c8e1ed57bcf9446f3d0d8ba37e2dd01c3c612c046c053b06f7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-parser/0.2.0/download"],
        strip_prefix = "wit-parser-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-parser-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-printer-0.2.0",
        sha256 = "93f19ca44555a3c14d69acee6447a6e4f52771b0c6e5d8db3e42db3b90f6fce9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-printer/0.2.0/download"],
        strip_prefix = "wit-printer-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-printer-0.2.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-schema-version-0.1.0",
        sha256 = "bfee4a6a4716eefa0682e7a3b836152e894a3e4f34a9d6c2c3e1c94429bfe36a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-schema-version/0.1.0/download"],
        strip_prefix = "wit-schema-version-0.1.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-schema-version-0.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-text-0.8.0",
        sha256 = "33358e95c77d660f1c7c07f4a93c2bd89768965e844e3c50730bb4b42658df5f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-text/0.8.0/download"],
        strip_prefix = "wit-text-0.8.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-text-0.8.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-validator-0.2.1",
        sha256 = "3c11d93d925420e7872b226c4161849c32be38385ccab026b88df99d8ddc6ba6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-validator/0.2.1/download"],
        strip_prefix = "wit-validator-0.2.1",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-validator-0.2.1.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-walrus-0.6.0",
        sha256 = "ad559e3e4c6404b2a6a675d44129d62a3836e3b951b90112fa1c5feb852757cd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-walrus/0.6.0/download"],
        strip_prefix = "wit-walrus-0.6.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-walrus-0.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "rules_rust_wasm_bindgen__wit-writer-0.2.0",
        sha256 = "c2ad01ba5e9cbcff799a0689e56a153776ea694cec777f605938cb9880d41a09",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wit-writer/0.2.0/download"],
        strip_prefix = "wit-writer-0.2.0",
        build_file = Label("@rules_rust//wasm_bindgen/3rdparty/crates:BUILD.wit-writer-0.2.0.bazel"),
    )
