/*----------------------------------------------------------------------------*/
/* Copyright (c) FIRST 2008. All Rights Reserved.							  */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in $(WIND_BASE)/WPILib.  */
/*----------------------------------------------------------------------------*/

#ifndef __TASK_H__
#define __TASK_H__

#include "ErrorBase.h"
#include <vxWorks.h>
#include "Synchronized.h"

/**
 * WPI task is a wrapper for a native VxWorks task.
 *
 * Some functions (documented) are guaranteed not to use any floating point so
 * that it is safe to use them from tasks that do not have the VX_FP_TASK flag
 * set (like during startup).
 **/
class Task : public ErrorBase
{
public:
	static const uint32_t kDefaultPriority = 101;
	static const int32_t kInvalidTaskID = -1;

	Task(const char* name, FUNCPTR function, int32_t priority = kDefaultPriority, uint32_t stackSize = 20000);
	virtual ~Task();

	bool Start(uint32_t arg0 = 0, uint32_t arg1 = 0, uint32_t arg2 = 0, uint32_t arg3 = 0, uint32_t arg4 = 0, 
			uint32_t arg5 = 0, uint32_t arg6 = 0, uint32_t arg7 = 0, uint32_t arg8 = 0, uint32_t arg9 = 0);
	bool Restart();
	bool Stop();

	bool IsReady();
	bool IsSuspended();

	bool Suspend();
	bool Resume();

	bool Verify();

	int32_t GetPriority();
	bool SetPriority(int32_t priority);
	const char* GetName();
	int32_t GetID();

private:
	FUNCPTR m_function;
	char* m_taskName;
	int32_t m_taskID;
	uint32_t m_stackSize;
	int m_priority;
  ReentrantSemaphore m_prioritySemaphore;
	bool HandleError(STATUS results);
	DISALLOW_COPY_AND_ASSIGN(Task);
};

#endif // __TASK_H__
