// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

#include "frc/controller/BangBangController.h"
#include "gtest/gtest.h"

class BangBangToleranceTest : public testing::Test {
 protected:
  frc::BangBangController controller{0.1};
};

TEST_F(BangBangToleranceTest, InTolerance) {
  controller.SetSetpoint(1);
  controller.Calculate(1);
  EXPECT_TRUE(controller.AtSetpoint());
}

TEST_F(BangBangToleranceTest, OutOfTolerance) {
  controller.SetSetpoint(1);
  controller.Calculate(0);
  EXPECT_FALSE(controller.AtSetpoint());
}
