// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

#pragma once

#include <string_view>
#include <utility>

#include <imgui.h>
#include <wpi/StringMap.h>

#include "glass/support/IniSaverBase.h"

namespace glass {

template <typename Info>
class IniSaverString : public IniSaverBase {
 public:
  explicit IniSaverString(std::string_view typeName,
                          IniSaverBackend* backend = nullptr)
      : IniSaverBase(typeName, backend) {}

  // pass through useful functions to map
  Info& operator[](std::string_view key) { return m_map[key]; }

  template <typename... ArgsTy>
  auto try_emplace(std::string_view key, ArgsTy&&... args) {
    return m_map.try_emplace(key, std::forward<ArgsTy>(args)...);
  }

  void erase(typename wpi::StringMap<Info>::iterator it) { m_map.erase(it); }
  auto erase(std::string_view key) { return m_map.erase(key); }

  auto begin() { return m_map.begin(); }
  auto end() { return m_map.end(); }
  auto find(std::string_view key) { return m_map.find(key); }

  auto begin() const { return m_map.begin(); }
  auto end() const { return m_map.end(); }
  auto find(std::string_view key) const { return m_map.find(key); }

  bool empty() const { return m_map.empty(); }

 private:
  void* IniReadOpen(const char* name) override;
  void IniReadLine(void* entry, const char* lineStr) override;
  void IniWriteAll(ImGuiTextBuffer* out_buf) override;

  wpi::StringMap<Info> m_map;
};

}  // namespace glass

#include "IniSaverString.inc"
