/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2019 Erik Moqvist
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * This file was generated by cantools version
 */

#include <string.h>

#include "PDHFrames.h"

static inline uint8_t pack_left_shift_u8(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value << shift) & mask);
}

static inline uint8_t pack_left_shift_u16(
    uint16_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value << shift) & mask);
}

static inline uint8_t pack_left_shift_u32(
    uint32_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value << shift) & mask);
}

static inline uint8_t pack_right_shift_u16(
    uint16_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value >> shift) & mask);
}

static inline uint8_t pack_right_shift_u32(
    uint32_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value >> shift) & mask);
}

static inline uint16_t unpack_left_shift_u16(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint16_t)((uint16_t)(value & mask) << shift);
}

static inline uint32_t unpack_left_shift_u32(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint32_t)((uint32_t)(value & mask) << shift);
}

static inline uint8_t unpack_right_shift_u8(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value & mask) >> shift);
}

static inline uint16_t unpack_right_shift_u16(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint16_t)((uint16_t)(value & mask) >> shift);
}

static inline uint32_t unpack_right_shift_u32(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint32_t)((uint32_t)(value & mask) >> shift);
}

int PDH_switch_channel_set_pack(
    uint8_t *dst_p,
    const struct PDH_switch_channel_set_t *src_p,
    size_t size)
{
    if (size < 1u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 1);

    dst_p[0] |= pack_left_shift_u8(src_p->output_set_value, 0u, 0x01u);
    dst_p[0] |= pack_left_shift_u8(src_p->use_system_enable, 1u, 0x02u);

    return (1);
}

int PDH_switch_channel_set_unpack(
    struct PDH_switch_channel_set_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 1u) {
        return (-EINVAL);
    }

    dst_p->output_set_value = unpack_right_shift_u8(src_p[0], 0u, 0x01u);
    dst_p->use_system_enable = unpack_right_shift_u8(src_p[0], 1u, 0x02u);

    return (0);
}

uint8_t PDH_switch_channel_set_output_set_value_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_switch_channel_set_output_set_value_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_switch_channel_set_output_set_value_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_switch_channel_set_use_system_enable_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_switch_channel_set_use_system_enable_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_switch_channel_set_use_system_enable_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

int PDH_status0_pack(
    uint8_t *dst_p,
    const struct PDH_status0_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u16(src_p->channel_0_current, 0u, 0xffu);
    dst_p[1] |= pack_right_shift_u16(src_p->channel_0_current, 8u, 0x03u);
    dst_p[1] |= pack_left_shift_u16(src_p->channel_1_current, 2u, 0xfcu);
    dst_p[2] |= pack_right_shift_u16(src_p->channel_1_current, 6u, 0x0fu);
    dst_p[2] |= pack_left_shift_u16(src_p->channel_2_current, 4u, 0xf0u);
    dst_p[3] |= pack_right_shift_u16(src_p->channel_2_current, 4u, 0x3fu);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_0_brownout, 6u, 0x40u);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_1_brownout, 7u, 0x80u);
    dst_p[4] |= pack_left_shift_u16(src_p->channel_3_current, 0u, 0xffu);
    dst_p[5] |= pack_right_shift_u16(src_p->channel_3_current, 8u, 0x03u);
    dst_p[5] |= pack_left_shift_u16(src_p->channel_4_current, 2u, 0xfcu);
    dst_p[6] |= pack_right_shift_u16(src_p->channel_4_current, 6u, 0x0fu);
    dst_p[6] |= pack_left_shift_u16(src_p->channel_5_current, 4u, 0xf0u);
    dst_p[7] |= pack_right_shift_u16(src_p->channel_5_current, 4u, 0x3fu);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_2_brownout, 6u, 0x40u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_3_brownout, 7u, 0x80u);

    return (8);
}

int PDH_status0_unpack(
    struct PDH_status0_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->channel_0_current = unpack_right_shift_u16(src_p[0], 0u, 0xffu);
    dst_p->channel_0_current |= unpack_left_shift_u16(src_p[1], 8u, 0x03u);
    dst_p->channel_1_current = unpack_right_shift_u16(src_p[1], 2u, 0xfcu);
    dst_p->channel_1_current |= unpack_left_shift_u16(src_p[2], 6u, 0x0fu);
    dst_p->channel_2_current = unpack_right_shift_u16(src_p[2], 4u, 0xf0u);
    dst_p->channel_2_current |= unpack_left_shift_u16(src_p[3], 4u, 0x3fu);
    dst_p->channel_0_brownout = unpack_right_shift_u8(src_p[3], 6u, 0x40u);
    dst_p->channel_1_brownout = unpack_right_shift_u8(src_p[3], 7u, 0x80u);
    dst_p->channel_3_current = unpack_right_shift_u16(src_p[4], 0u, 0xffu);
    dst_p->channel_3_current |= unpack_left_shift_u16(src_p[5], 8u, 0x03u);
    dst_p->channel_4_current = unpack_right_shift_u16(src_p[5], 2u, 0xfcu);
    dst_p->channel_4_current |= unpack_left_shift_u16(src_p[6], 6u, 0x0fu);
    dst_p->channel_5_current = unpack_right_shift_u16(src_p[6], 4u, 0xf0u);
    dst_p->channel_5_current |= unpack_left_shift_u16(src_p[7], 4u, 0x3fu);
    dst_p->channel_2_brownout = unpack_right_shift_u8(src_p[7], 6u, 0x40u);
    dst_p->channel_3_brownout = unpack_right_shift_u8(src_p[7], 7u, 0x80u);

    return (0);
}

uint16_t PDH_status0_channel_0_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status0_channel_0_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status0_channel_0_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status0_channel_1_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status0_channel_1_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status0_channel_1_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status0_channel_2_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status0_channel_2_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status0_channel_2_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint8_t PDH_status0_channel_0_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status0_channel_0_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status0_channel_0_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status0_channel_1_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status0_channel_1_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status0_channel_1_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint16_t PDH_status0_channel_3_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status0_channel_3_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status0_channel_3_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status0_channel_4_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status0_channel_4_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status0_channel_4_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status0_channel_5_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status0_channel_5_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status0_channel_5_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint8_t PDH_status0_channel_2_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status0_channel_2_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status0_channel_2_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status0_channel_3_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status0_channel_3_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status0_channel_3_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

int PDH_status1_pack(
    uint8_t *dst_p,
    const struct PDH_status1_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u16(src_p->channel_6_current, 0u, 0xffu);
    dst_p[1] |= pack_right_shift_u16(src_p->channel_6_current, 8u, 0x03u);
    dst_p[1] |= pack_left_shift_u16(src_p->channel_7_current, 2u, 0xfcu);
    dst_p[2] |= pack_right_shift_u16(src_p->channel_7_current, 6u, 0x0fu);
    dst_p[2] |= pack_left_shift_u16(src_p->channel_8_current, 4u, 0xf0u);
    dst_p[3] |= pack_right_shift_u16(src_p->channel_8_current, 4u, 0x3fu);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_4_brownout, 6u, 0x40u);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_5_brownout, 7u, 0x80u);
    dst_p[4] |= pack_left_shift_u16(src_p->channel_9_current, 0u, 0xffu);
    dst_p[5] |= pack_right_shift_u16(src_p->channel_9_current, 8u, 0x03u);
    dst_p[5] |= pack_left_shift_u16(src_p->channel_10_current, 2u, 0xfcu);
    dst_p[6] |= pack_right_shift_u16(src_p->channel_10_current, 6u, 0x0fu);
    dst_p[6] |= pack_left_shift_u16(src_p->channel_11_current, 4u, 0xf0u);
    dst_p[7] |= pack_right_shift_u16(src_p->channel_11_current, 4u, 0x3fu);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_6_brownout, 6u, 0x40u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_7_brownout, 7u, 0x80u);

    return (8);
}

int PDH_status1_unpack(
    struct PDH_status1_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->channel_6_current = unpack_right_shift_u16(src_p[0], 0u, 0xffu);
    dst_p->channel_6_current |= unpack_left_shift_u16(src_p[1], 8u, 0x03u);
    dst_p->channel_7_current = unpack_right_shift_u16(src_p[1], 2u, 0xfcu);
    dst_p->channel_7_current |= unpack_left_shift_u16(src_p[2], 6u, 0x0fu);
    dst_p->channel_8_current = unpack_right_shift_u16(src_p[2], 4u, 0xf0u);
    dst_p->channel_8_current |= unpack_left_shift_u16(src_p[3], 4u, 0x3fu);
    dst_p->channel_4_brownout = unpack_right_shift_u8(src_p[3], 6u, 0x40u);
    dst_p->channel_5_brownout = unpack_right_shift_u8(src_p[3], 7u, 0x80u);
    dst_p->channel_9_current = unpack_right_shift_u16(src_p[4], 0u, 0xffu);
    dst_p->channel_9_current |= unpack_left_shift_u16(src_p[5], 8u, 0x03u);
    dst_p->channel_10_current = unpack_right_shift_u16(src_p[5], 2u, 0xfcu);
    dst_p->channel_10_current |= unpack_left_shift_u16(src_p[6], 6u, 0x0fu);
    dst_p->channel_11_current = unpack_right_shift_u16(src_p[6], 4u, 0xf0u);
    dst_p->channel_11_current |= unpack_left_shift_u16(src_p[7], 4u, 0x3fu);
    dst_p->channel_6_brownout = unpack_right_shift_u8(src_p[7], 6u, 0x40u);
    dst_p->channel_7_brownout = unpack_right_shift_u8(src_p[7], 7u, 0x80u);

    return (0);
}

uint16_t PDH_status1_channel_6_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status1_channel_6_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status1_channel_6_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status1_channel_7_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status1_channel_7_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status1_channel_7_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status1_channel_8_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status1_channel_8_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status1_channel_8_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint8_t PDH_status1_channel_4_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status1_channel_4_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status1_channel_4_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status1_channel_5_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status1_channel_5_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status1_channel_5_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint16_t PDH_status1_channel_9_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status1_channel_9_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status1_channel_9_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status1_channel_10_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status1_channel_10_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status1_channel_10_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status1_channel_11_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status1_channel_11_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status1_channel_11_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint8_t PDH_status1_channel_6_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status1_channel_6_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status1_channel_6_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status1_channel_7_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status1_channel_7_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status1_channel_7_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

int PDH_status2_pack(
    uint8_t *dst_p,
    const struct PDH_status2_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u16(src_p->channel_12_current, 0u, 0xffu);
    dst_p[1] |= pack_right_shift_u16(src_p->channel_12_current, 8u, 0x03u);
    dst_p[1] |= pack_left_shift_u16(src_p->channel_13_current, 2u, 0xfcu);
    dst_p[2] |= pack_right_shift_u16(src_p->channel_13_current, 6u, 0x0fu);
    dst_p[2] |= pack_left_shift_u16(src_p->channel_14_current, 4u, 0xf0u);
    dst_p[3] |= pack_right_shift_u16(src_p->channel_14_current, 4u, 0x3fu);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_8_brownout, 6u, 0x40u);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_9_brownout, 7u, 0x80u);
    dst_p[4] |= pack_left_shift_u16(src_p->channel_15_current, 0u, 0xffu);
    dst_p[5] |= pack_right_shift_u16(src_p->channel_15_current, 8u, 0x03u);
    dst_p[5] |= pack_left_shift_u16(src_p->channel_16_current, 2u, 0xfcu);
    dst_p[6] |= pack_right_shift_u16(src_p->channel_16_current, 6u, 0x0fu);
    dst_p[6] |= pack_left_shift_u16(src_p->channel_17_current, 4u, 0xf0u);
    dst_p[7] |= pack_right_shift_u16(src_p->channel_17_current, 4u, 0x3fu);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_10_brownout, 6u, 0x40u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_11_brownout, 7u, 0x80u);

    return (8);
}

int PDH_status2_unpack(
    struct PDH_status2_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->channel_12_current = unpack_right_shift_u16(src_p[0], 0u, 0xffu);
    dst_p->channel_12_current |= unpack_left_shift_u16(src_p[1], 8u, 0x03u);
    dst_p->channel_13_current = unpack_right_shift_u16(src_p[1], 2u, 0xfcu);
    dst_p->channel_13_current |= unpack_left_shift_u16(src_p[2], 6u, 0x0fu);
    dst_p->channel_14_current = unpack_right_shift_u16(src_p[2], 4u, 0xf0u);
    dst_p->channel_14_current |= unpack_left_shift_u16(src_p[3], 4u, 0x3fu);
    dst_p->channel_8_brownout = unpack_right_shift_u8(src_p[3], 6u, 0x40u);
    dst_p->channel_9_brownout = unpack_right_shift_u8(src_p[3], 7u, 0x80u);
    dst_p->channel_15_current = unpack_right_shift_u16(src_p[4], 0u, 0xffu);
    dst_p->channel_15_current |= unpack_left_shift_u16(src_p[5], 8u, 0x03u);
    dst_p->channel_16_current = unpack_right_shift_u16(src_p[5], 2u, 0xfcu);
    dst_p->channel_16_current |= unpack_left_shift_u16(src_p[6], 6u, 0x0fu);
    dst_p->channel_17_current = unpack_right_shift_u16(src_p[6], 4u, 0xf0u);
    dst_p->channel_17_current |= unpack_left_shift_u16(src_p[7], 4u, 0x3fu);
    dst_p->channel_10_brownout = unpack_right_shift_u8(src_p[7], 6u, 0x40u);
    dst_p->channel_11_brownout = unpack_right_shift_u8(src_p[7], 7u, 0x80u);

    return (0);
}

uint16_t PDH_status2_channel_12_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status2_channel_12_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status2_channel_12_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status2_channel_13_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status2_channel_13_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status2_channel_13_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status2_channel_14_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status2_channel_14_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status2_channel_14_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint8_t PDH_status2_channel_8_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status2_channel_8_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status2_channel_8_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status2_channel_9_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status2_channel_9_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status2_channel_9_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint16_t PDH_status2_channel_15_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status2_channel_15_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status2_channel_15_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status2_channel_16_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status2_channel_16_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status2_channel_16_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status2_channel_17_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status2_channel_17_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status2_channel_17_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint8_t PDH_status2_channel_10_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status2_channel_10_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status2_channel_10_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status2_channel_11_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status2_channel_11_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status2_channel_11_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

int PDH_status3_pack(
    uint8_t *dst_p,
    const struct PDH_status3_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u16(src_p->channel_18_current, 0u, 0xffu);
    dst_p[1] |= pack_right_shift_u16(src_p->channel_18_current, 8u, 0x03u);
    dst_p[1] |= pack_left_shift_u16(src_p->channel_19_current, 2u, 0xfcu);
    dst_p[2] |= pack_right_shift_u16(src_p->channel_19_current, 6u, 0x0fu);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_12_brownout, 4u, 0x10u);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_13_brownout, 5u, 0x20u);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_14_brownout, 6u, 0x40u);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_15_brownout, 7u, 0x80u);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_20_current, 0u, 0xffu);
    dst_p[4] |= pack_left_shift_u8(src_p->channel_21_current, 0u, 0xffu);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_22_current, 0u, 0xffu);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_23_current, 0u, 0xffu);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_16_brownout, 0u, 0x01u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_17_brownout, 1u, 0x02u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_18_brownout, 2u, 0x04u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_19_brownout, 3u, 0x08u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_20_brownout, 4u, 0x10u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_21_brownout, 5u, 0x20u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_22_brownout, 6u, 0x40u);
    dst_p[7] |= pack_left_shift_u8(src_p->channel_23_brownout, 7u, 0x80u);

    return (8);
}

int PDH_status3_unpack(
    struct PDH_status3_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->channel_18_current = unpack_right_shift_u16(src_p[0], 0u, 0xffu);
    dst_p->channel_18_current |= unpack_left_shift_u16(src_p[1], 8u, 0x03u);
    dst_p->channel_19_current = unpack_right_shift_u16(src_p[1], 2u, 0xfcu);
    dst_p->channel_19_current |= unpack_left_shift_u16(src_p[2], 6u, 0x0fu);
    dst_p->channel_12_brownout = unpack_right_shift_u8(src_p[2], 4u, 0x10u);
    dst_p->channel_13_brownout = unpack_right_shift_u8(src_p[2], 5u, 0x20u);
    dst_p->channel_14_brownout = unpack_right_shift_u8(src_p[2], 6u, 0x40u);
    dst_p->channel_15_brownout = unpack_right_shift_u8(src_p[2], 7u, 0x80u);
    dst_p->channel_20_current = unpack_right_shift_u8(src_p[3], 0u, 0xffu);
    dst_p->channel_21_current = unpack_right_shift_u8(src_p[4], 0u, 0xffu);
    dst_p->channel_22_current = unpack_right_shift_u8(src_p[5], 0u, 0xffu);
    dst_p->channel_23_current = unpack_right_shift_u8(src_p[6], 0u, 0xffu);
    dst_p->channel_16_brownout = unpack_right_shift_u8(src_p[7], 0u, 0x01u);
    dst_p->channel_17_brownout = unpack_right_shift_u8(src_p[7], 1u, 0x02u);
    dst_p->channel_18_brownout = unpack_right_shift_u8(src_p[7], 2u, 0x04u);
    dst_p->channel_19_brownout = unpack_right_shift_u8(src_p[7], 3u, 0x08u);
    dst_p->channel_20_brownout = unpack_right_shift_u8(src_p[7], 4u, 0x10u);
    dst_p->channel_21_brownout = unpack_right_shift_u8(src_p[7], 5u, 0x20u);
    dst_p->channel_22_brownout = unpack_right_shift_u8(src_p[7], 6u, 0x40u);
    dst_p->channel_23_brownout = unpack_right_shift_u8(src_p[7], 7u, 0x80u);

    return (0);
}

uint16_t PDH_status3_channel_18_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status3_channel_18_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status3_channel_18_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint16_t PDH_status3_channel_19_current_encode(double value)
{
    return (uint16_t)(value / 0.125);
}

double PDH_status3_channel_19_current_decode(uint16_t value)
{
    return ((double)value * 0.125);
}

bool PDH_status3_channel_19_current_is_in_range(uint16_t value)
{
    return (value <= 1023u);
}

uint8_t PDH_status3_channel_12_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_12_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_12_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_13_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_13_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_13_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_14_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_14_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_14_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_15_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_15_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_15_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_20_current_encode(double value)
{
    return (uint8_t)(value / 0.0625);
}

double PDH_status3_channel_20_current_decode(uint8_t value)
{
    return ((double)value * 0.0625);
}

bool PDH_status3_channel_20_current_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PDH_status3_channel_21_current_encode(double value)
{
    return (uint8_t)(value / 0.0625);
}

double PDH_status3_channel_21_current_decode(uint8_t value)
{
    return ((double)value * 0.0625);
}

bool PDH_status3_channel_21_current_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PDH_status3_channel_22_current_encode(double value)
{
    return (uint8_t)(value / 0.0625);
}

double PDH_status3_channel_22_current_decode(uint8_t value)
{
    return ((double)value * 0.0625);
}

bool PDH_status3_channel_22_current_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PDH_status3_channel_23_current_encode(double value)
{
    return (uint8_t)(value / 0.0625);
}

double PDH_status3_channel_23_current_decode(uint8_t value)
{
    return ((double)value * 0.0625);
}

bool PDH_status3_channel_23_current_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PDH_status3_channel_16_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_16_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_16_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_17_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_17_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_17_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_18_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_18_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_18_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_19_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_19_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_19_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_20_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_20_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_20_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_21_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_21_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_21_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_22_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_22_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_22_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status3_channel_23_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status3_channel_23_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status3_channel_23_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

int PDH_status4_pack(
    uint8_t *dst_p,
    const struct PDH_status4_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u16(src_p->v_bus, 0u, 0xffu);
    dst_p[1] |= pack_right_shift_u16(src_p->v_bus, 8u, 0x0fu);
    dst_p[1] |= pack_left_shift_u8(src_p->system_enable, 4u, 0x10u);
    dst_p[1] |= pack_left_shift_u8(src_p->rsvd0, 5u, 0xe0u);
    dst_p[2] |= pack_left_shift_u8(src_p->brownout, 0u, 0x01u);
    dst_p[2] |= pack_left_shift_u8(src_p->rsvd1, 1u, 0x02u);
    dst_p[2] |= pack_left_shift_u8(src_p->can_warning, 2u, 0x04u);
    dst_p[2] |= pack_left_shift_u8(src_p->hardware_fault, 3u, 0x08u);
    dst_p[2] |= pack_left_shift_u8(src_p->sw_state, 4u, 0x10u);
    dst_p[2] |= pack_left_shift_u8(src_p->sticky_brownout, 5u, 0x20u);
    dst_p[2] |= pack_left_shift_u8(src_p->rsvd2, 6u, 0x40u);
    dst_p[2] |= pack_left_shift_u8(src_p->sticky_can_warning, 7u, 0x80u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_can_bus_off, 0u, 0x01u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_hardware_fault, 1u, 0x02u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_firmware_fault, 2u, 0x04u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_ch20_brownout, 3u, 0x08u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_ch21_brownout, 4u, 0x10u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_ch22_brownout, 5u, 0x20u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_ch23_brownout, 6u, 0x40u);
    dst_p[3] |= pack_left_shift_u8(src_p->sticky_has_reset, 7u, 0x80u);
    dst_p[4] |= pack_left_shift_u8(src_p->total_current, 0u, 0xffu);

    return (8);
}

int PDH_status4_unpack(
    struct PDH_status4_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->v_bus = unpack_right_shift_u16(src_p[0], 0u, 0xffu);
    dst_p->v_bus |= unpack_left_shift_u16(src_p[1], 8u, 0x0fu);
    dst_p->system_enable = unpack_right_shift_u8(src_p[1], 4u, 0x10u);
    dst_p->rsvd0 = unpack_right_shift_u8(src_p[1], 5u, 0xe0u);
    dst_p->brownout = unpack_right_shift_u8(src_p[2], 0u, 0x01u);
    dst_p->rsvd1 = unpack_right_shift_u8(src_p[2], 1u, 0x02u);
    dst_p->can_warning = unpack_right_shift_u8(src_p[2], 2u, 0x04u);
    dst_p->hardware_fault = unpack_right_shift_u8(src_p[2], 3u, 0x08u);
    dst_p->sw_state = unpack_right_shift_u8(src_p[2], 4u, 0x10u);
    dst_p->sticky_brownout = unpack_right_shift_u8(src_p[2], 5u, 0x20u);
    dst_p->rsvd2 = unpack_right_shift_u8(src_p[2], 6u, 0x40u);
    dst_p->sticky_can_warning = unpack_right_shift_u8(src_p[2], 7u, 0x80u);
    dst_p->sticky_can_bus_off = unpack_right_shift_u8(src_p[3], 0u, 0x01u);
    dst_p->sticky_hardware_fault = unpack_right_shift_u8(src_p[3], 1u, 0x02u);
    dst_p->sticky_firmware_fault = unpack_right_shift_u8(src_p[3], 2u, 0x04u);
    dst_p->sticky_ch20_brownout = unpack_right_shift_u8(src_p[3], 3u, 0x08u);
    dst_p->sticky_ch21_brownout = unpack_right_shift_u8(src_p[3], 4u, 0x10u);
    dst_p->sticky_ch22_brownout = unpack_right_shift_u8(src_p[3], 5u, 0x20u);
    dst_p->sticky_ch23_brownout = unpack_right_shift_u8(src_p[3], 6u, 0x40u);
    dst_p->sticky_has_reset = unpack_right_shift_u8(src_p[3], 7u, 0x80u);
    dst_p->total_current = unpack_right_shift_u8(src_p[4], 0u, 0xffu);

    return (0);
}

uint16_t PDH_status4_v_bus_encode(double value)
{
    return (uint16_t)(value / 0.0078125);
}

double PDH_status4_v_bus_decode(uint16_t value)
{
    return ((double)value * 0.0078125);
}

bool PDH_status4_v_bus_is_in_range(uint16_t value)
{
    return (value <= 4095u);
}

uint8_t PDH_status4_system_enable_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_system_enable_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_system_enable_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_rsvd0_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_rsvd0_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_rsvd0_is_in_range(uint8_t value)
{
    return (value <= 7u);
}

uint8_t PDH_status4_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_rsvd1_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_rsvd1_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_rsvd1_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_can_warning_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_can_warning_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_can_warning_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_hardware_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_hardware_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_hardware_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sw_state_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sw_state_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sw_state_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_rsvd2_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_rsvd2_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_rsvd2_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_can_warning_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_can_warning_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_can_warning_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_can_bus_off_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_can_bus_off_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_can_bus_off_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_hardware_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_hardware_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_hardware_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_firmware_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_firmware_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_firmware_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_ch20_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_ch20_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_ch20_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_ch21_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_ch21_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_ch21_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_ch22_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_ch22_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_ch22_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_ch23_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_ch23_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_ch23_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_sticky_has_reset_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_status4_sticky_has_reset_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_status4_sticky_has_reset_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PDH_status4_total_current_encode(double value)
{
    return (uint8_t)(value / 2.0);
}

double PDH_status4_total_current_decode(uint8_t value)
{
    return ((double)value * 2.0);
}

bool PDH_status4_total_current_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

int PDH_clear_faults_pack(
    uint8_t *dst_p,
    const struct PDH_clear_faults_t *src_p,
    size_t size)
{
    (void)dst_p;
    (void)src_p;
    (void)size;

    return (0);
}

int PDH_clear_faults_unpack(
    struct PDH_clear_faults_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    (void)dst_p;
    (void)src_p;
    (void)size;

    return (0);
}

int PDH_identify_pack(
    uint8_t *dst_p,
    const struct PDH_identify_t *src_p,
    size_t size)
{
    (void)dst_p;
    (void)src_p;
    (void)size;

    return (0);
}

int PDH_identify_unpack(
    struct PDH_identify_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    (void)dst_p;
    (void)src_p;
    (void)size;

    return (0);
}

int PDH_version_pack(
    uint8_t *dst_p,
    const struct PDH_version_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u8(src_p->firmware_fix, 0u, 0xffu);
    dst_p[1] |= pack_left_shift_u8(src_p->firmware_minor, 0u, 0xffu);
    dst_p[2] |= pack_left_shift_u8(src_p->firmware_year, 0u, 0xffu);
    dst_p[3] |= pack_left_shift_u8(src_p->hardware_code, 0u, 0xffu);
    dst_p[4] |= pack_left_shift_u32(src_p->unique_id, 0u, 0xffu);
    dst_p[5] |= pack_right_shift_u32(src_p->unique_id, 8u, 0xffu);
    dst_p[6] |= pack_right_shift_u32(src_p->unique_id, 16u, 0xffu);
    dst_p[7] |= pack_right_shift_u32(src_p->unique_id, 24u, 0xffu);

    return (8);
}

int PDH_version_unpack(
    struct PDH_version_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->firmware_fix = unpack_right_shift_u8(src_p[0], 0u, 0xffu);
    dst_p->firmware_minor = unpack_right_shift_u8(src_p[1], 0u, 0xffu);
    dst_p->firmware_year = unpack_right_shift_u8(src_p[2], 0u, 0xffu);
    dst_p->hardware_code = unpack_right_shift_u8(src_p[3], 0u, 0xffu);
    dst_p->unique_id = unpack_right_shift_u32(src_p[4], 0u, 0xffu);
    dst_p->unique_id |= unpack_left_shift_u32(src_p[5], 8u, 0xffu);
    dst_p->unique_id |= unpack_left_shift_u32(src_p[6], 16u, 0xffu);
    dst_p->unique_id |= unpack_left_shift_u32(src_p[7], 24u, 0xffu);

    return (0);
}

uint8_t PDH_version_firmware_fix_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_version_firmware_fix_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_version_firmware_fix_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PDH_version_firmware_minor_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_version_firmware_minor_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_version_firmware_minor_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PDH_version_firmware_year_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_version_firmware_year_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_version_firmware_year_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PDH_version_hardware_code_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_version_hardware_code_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_version_hardware_code_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint32_t PDH_version_unique_id_encode(double value)
{
    return (uint32_t)(value);
}

double PDH_version_unique_id_decode(uint32_t value)
{
    return ((double)value);
}

bool PDH_version_unique_id_is_in_range(uint32_t value)
{
    (void)value;

    return (true);
}

int PDH_configure_hr_channel_pack(
    uint8_t *dst_p,
    const struct PDH_configure_hr_channel_t *src_p,
    size_t size)
{
    if (size < 3u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 3);

    dst_p[0] |= pack_left_shift_u8(src_p->channel, 0u, 0xffu);
    dst_p[1] |= pack_left_shift_u16(src_p->period, 0u, 0xffu);
    dst_p[2] |= pack_right_shift_u16(src_p->period, 8u, 0xffu);

    return (3);
}

int PDH_configure_hr_channel_unpack(
    struct PDH_configure_hr_channel_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 3u) {
        return (-EINVAL);
    }

    dst_p->channel = unpack_right_shift_u8(src_p[0], 0u, 0xffu);
    dst_p->period = unpack_right_shift_u16(src_p[1], 0u, 0xffu);
    dst_p->period |= unpack_left_shift_u16(src_p[2], 8u, 0xffu);

    return (0);
}

uint8_t PDH_configure_hr_channel_channel_encode(double value)
{
    return (uint8_t)(value);
}

double PDH_configure_hr_channel_channel_decode(uint8_t value)
{
    return ((double)value);
}

bool PDH_configure_hr_channel_channel_is_in_range(uint8_t value)
{
    return (value <= 23u);
}

uint16_t PDH_configure_hr_channel_period_encode(double value)
{
    return (uint16_t)(value);
}

double PDH_configure_hr_channel_period_decode(uint16_t value)
{
    return ((double)value);
}

bool PDH_configure_hr_channel_period_is_in_range(uint16_t value)
{
    (void)value;

    return (true);
}

int PDH_enter_bootloader_pack(
    uint8_t *dst_p,
    const struct PDH_enter_bootloader_t *src_p,
    size_t size)
{
    (void)dst_p;
    (void)src_p;
    (void)size;

    return (0);
}

int PDH_enter_bootloader_unpack(
    struct PDH_enter_bootloader_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    (void)dst_p;
    (void)src_p;
    (void)size;

    return (0);
}
