// Generated GRPC code for FlatBuffers swift!
/// The following code is generated by the Flatbuffers library which might not be in sync with grpc-swift
/// in case of an issue please open github issue, though it would be maintained
import Foundation
import GRPC
import NIO
import NIOHTTP1
import FlatBuffers

public protocol GRPCFlatBufPayload: GRPCPayload, FlatBufferGRPCMessage {}
public extension GRPCFlatBufPayload {
    init(serializedByteBuffer: inout NIO.ByteBuffer) throws {
        self.init(byteBuffer: FlatBuffers.ByteBuffer(contiguousBytes: serializedByteBuffer.readableBytesView, count: serializedByteBuffer.readableBytes))
    }
    func serialize(into buffer: inout NIO.ByteBuffer) throws {
        let buf = UnsafeRawBufferPointer(start: self.rawPointer, count: Int(self.size))
        buffer.writeBytes(buf)
    }
}
extension Message: GRPCFlatBufPayload {}

/// Usage: instantiate GreeterServiceClient, then call methods of this protocol to make API calls.
public protocol GreeterService {
	 func SayHello(_ request: Message<HelloRequest>, callOptions: CallOptions?) -> UnaryCall<Message<HelloRequest>,Message<HelloReply>>
	 func SayManyHellos(_ request: Message<ManyHellosRequest>, callOptions: CallOptions?, handler: @escaping (Message<HelloReply>) -> Void) -> ServerStreamingCall<Message<ManyHellosRequest>, Message<HelloReply>>
}

public final class GreeterServiceClient: GRPCClient, GreeterService {
	public let channel: GRPCChannel
	public var defaultCallOptions: CallOptions

	public init(channel: GRPCChannel, defaultCallOptions: CallOptions = CallOptions()) {
		self.channel = channel
		self.defaultCallOptions = defaultCallOptions
	}

	public func SayHello(_ request: Message<HelloRequest>, callOptions: CallOptions? = nil) -> UnaryCall<Message<HelloRequest>,Message<HelloReply>> {
		return self.makeUnaryCall(path: "/Greeter/SayHello", request: request, callOptions: callOptions ?? self.defaultCallOptions)
	}

	public func SayManyHellos(_ request: Message<ManyHellosRequest>, callOptions: CallOptions? = nil, handler: @escaping (Message<HelloReply>) -> Void) -> ServerStreamingCall<Message<ManyHellosRequest>, Message<HelloReply>> {
		return self.makeServerStreamingCall(path: "/Greeter/SayManyHellos", request: request, callOptions: callOptions ?? self.defaultCallOptions, handler: handler)
	}
}

public protocol GreeterProvider: CallHandlerProvider {
	func SayHello(_ request: Message<HelloRequest>, context: StatusOnlyCallContext) -> EventLoopFuture<Message<HelloReply>>
	func SayManyHellos(request: Message<ManyHellosRequest>, context: StreamingResponseCallContext<Message<HelloReply>>) -> EventLoopFuture<GRPCStatus>
}

public extension GreeterProvider {

	var serviceName: Substring { return "Greeter" }

	func handleMethod(_ methodName: Substring, callHandlerContext: CallHandlerContext) -> GRPCCallHandler? {
		switch methodName {
		case "SayHello":
		return CallHandlerFactory.makeUnary(callHandlerContext: callHandlerContext) { context in
			return { request in
				self.SayHello(request, context: context)
			}
		}
		case "SayManyHellos":
		return CallHandlerFactory.makeServerStreaming(callHandlerContext: callHandlerContext) { context in
			return { request in
				self.SayManyHellos(request: request, context: context)
			}
		}
		default: return nil;
		}
	}

}


