###############################################################################
# @generated
# DO NOT MODIFY: This file is auto-generated by a crate_universe tool. To
# regenerate this file, run the following:
#
#     bazel run @//vendor_remote_manifests:crates_vendor
###############################################################################
"""
# `crates_repository` API

- [aliases](#aliases)
- [crate_deps](#crate_deps)
- [all_crate_deps](#all_crate_deps)
- [crate_repositories](#crate_repositories)

"""

load("@bazel_skylib//lib:selects.bzl", "selects")
load("@bazel_tools//tools/build_defs/repo:http.bzl", "http_archive")
load("@bazel_tools//tools/build_defs/repo:utils.bzl", "maybe")

###############################################################################
# MACROS API
###############################################################################

# An identifier that represent common dependencies (unconditional).
_COMMON_CONDITION = ""

def _flatten_dependency_maps(all_dependency_maps):
    """Flatten a list of dependency maps into one dictionary.

    Dependency maps have the following structure:

    ```python
    DEPENDENCIES_MAP = {
        # The first key in the map is a Bazel package
        # name of the workspace this file is defined in.
        "workspace_member_package": {

            # Not all dependencies are supported for all platforms.
            # the condition key is the condition required to be true
            # on the host platform.
            "condition": {

                # An alias to a crate target.     # The label of the crate target the
                # Aliases are only crate names.   # package name refers to.
                "package_name":                   "@full//:label",
            }
        }
    }
    ```

    Args:
        all_dependency_maps (list): A list of dicts as described above

    Returns:
        dict: A dictionary as described above
    """
    dependencies = {}

    for workspace_deps_map in all_dependency_maps:
        for pkg_name, conditional_deps_map in workspace_deps_map.items():
            if pkg_name not in dependencies:
                non_frozen_map = dict()
                for key, values in conditional_deps_map.items():
                    non_frozen_map.update({key: dict(values.items())})
                dependencies.setdefault(pkg_name, non_frozen_map)
                continue

            for condition, deps_map in conditional_deps_map.items():
                # If the condition has not been recorded, do so and continue
                if condition not in dependencies[pkg_name]:
                    dependencies[pkg_name].setdefault(condition, dict(deps_map.items()))
                    continue

                # Alert on any miss-matched dependencies
                inconsistent_entries = []
                for crate_name, crate_label in deps_map.items():
                    existing = dependencies[pkg_name][condition].get(crate_name)
                    if existing and existing != crate_label:
                        inconsistent_entries.append((crate_name, existing, crate_label))
                    dependencies[pkg_name][condition].update({crate_name: crate_label})

    return dependencies

def crate_deps(deps, package_name = None):
    """Finds the fully qualified label of the requested crates for the package where this macro is called.

    Args:
        deps (list): The desired list of crate targets.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()`.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if not deps:
        return []

    if package_name == None:
        package_name = native.package_name()

    # Join both sets of dependencies
    dependencies = _flatten_dependency_maps([
        _NORMAL_DEPENDENCIES,
        _NORMAL_DEV_DEPENDENCIES,
        _PROC_MACRO_DEPENDENCIES,
        _PROC_MACRO_DEV_DEPENDENCIES,
        _BUILD_DEPENDENCIES,
        _BUILD_PROC_MACRO_DEPENDENCIES,
    ]).pop(package_name, {})

    # Combine all conditional packages so we can easily index over a flat list
    # TODO: Perhaps this should actually return select statements and maintain
    # the conditionals of the dependencies
    flat_deps = {}
    for deps_set in dependencies.values():
        for crate_name, crate_label in deps_set.items():
            flat_deps.update({crate_name: crate_label})

    missing_crates = []
    crate_targets = []
    for crate_target in deps:
        if crate_target not in flat_deps:
            missing_crates.append(crate_target)
        else:
            crate_targets.append(flat_deps[crate_target])

    if missing_crates:
        fail("Could not find crates `{}` among dependencies of `{}`. Available dependencies were `{}`".format(
            missing_crates,
            package_name,
            dependencies,
        ))

    return crate_targets

def all_crate_deps(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Finds the fully qualified label of all requested direct crate dependencies \
    for the package where this macro is called.

    If no parameters are set, all normal dependencies are returned. Setting any one flag will
    otherwise impact the contents of the returned list.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        list: A list of labels to generated rust targets (str)
    """

    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_dependency_maps = []
    if normal:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)
    if normal_dev:
        all_dependency_maps.append(_NORMAL_DEV_DEPENDENCIES)
    if proc_macro:
        all_dependency_maps.append(_PROC_MACRO_DEPENDENCIES)
    if proc_macro_dev:
        all_dependency_maps.append(_PROC_MACRO_DEV_DEPENDENCIES)
    if build:
        all_dependency_maps.append(_BUILD_DEPENDENCIES)
    if build_proc_macro:
        all_dependency_maps.append(_BUILD_PROC_MACRO_DEPENDENCIES)

    # Default to always using normal dependencies
    if not all_dependency_maps:
        all_dependency_maps.append(_NORMAL_DEPENDENCIES)

    dependencies = _flatten_dependency_maps(all_dependency_maps).pop(package_name, None)

    if not dependencies:
        if dependencies == None:
            fail("Tried to get all_crate_deps for package " + package_name + " but that package had no Cargo.toml file")
        else:
            return []

    crate_deps = list(dependencies.pop(_COMMON_CONDITION, {}).values())
    for condition, deps in dependencies.items():
        crate_deps += selects.with_or({_CONDITIONS[condition]: deps.values()})

    return crate_deps

def aliases(
        normal = False,
        normal_dev = False,
        proc_macro = False,
        proc_macro_dev = False,
        build = False,
        build_proc_macro = False,
        package_name = None):
    """Produces a map of Crate alias names to their original label

    If no dependency kinds are specified, `normal` and `proc_macro` are used by default.
    Setting any one flag will otherwise determine the contents of the returned dict.

    Args:
        normal (bool, optional): If True, normal dependencies are included in the
            output list.
        normal_dev (bool, optional): If True, normal dev dependencies will be
            included in the output list..
        proc_macro (bool, optional): If True, proc_macro dependencies are included
            in the output list.
        proc_macro_dev (bool, optional): If True, dev proc_macro dependencies are
            included in the output list.
        build (bool, optional): If True, build dependencies are included
            in the output list.
        build_proc_macro (bool, optional): If True, build proc_macro dependencies are
            included in the output list.
        package_name (str, optional): The package name of the set of dependencies to look up.
            Defaults to `native.package_name()` when unset.

    Returns:
        dict: The aliases of all associated packages
    """
    if package_name == None:
        package_name = native.package_name()

    # Determine the relevant maps to use
    all_aliases_maps = []
    if normal:
        all_aliases_maps.append(_NORMAL_ALIASES)
    if normal_dev:
        all_aliases_maps.append(_NORMAL_DEV_ALIASES)
    if proc_macro:
        all_aliases_maps.append(_PROC_MACRO_ALIASES)
    if proc_macro_dev:
        all_aliases_maps.append(_PROC_MACRO_DEV_ALIASES)
    if build:
        all_aliases_maps.append(_BUILD_ALIASES)
    if build_proc_macro:
        all_aliases_maps.append(_BUILD_PROC_MACRO_ALIASES)

    # Default to always using normal aliases
    if not all_aliases_maps:
        all_aliases_maps.append(_NORMAL_ALIASES)
        all_aliases_maps.append(_PROC_MACRO_ALIASES)

    aliases = _flatten_dependency_maps(all_aliases_maps).pop(package_name, None)

    if not aliases:
        return dict()

    common_items = aliases.pop(_COMMON_CONDITION, {}).items()

    # If there are only common items in the dictionary, immediately return them
    if not len(aliases.keys()) == 1:
        return dict(common_items)

    # Build a single select statement where each conditional has accounted for the
    # common set of aliases.
    crate_aliases = {"//conditions:default": common_items}
    for condition, deps in aliases.items():
        condition_triples = _CONDITIONS[condition]
        if condition_triples in crate_aliases:
            crate_aliases[condition_triples].update(deps)
        else:
            crate_aliases.update({_CONDITIONS[condition]: dict(deps.items() + common_items)})

    return selects.with_or(crate_aliases)

###############################################################################
# WORKSPACE MEMBER DEPS AND ALIASES
###############################################################################

_NORMAL_DEPENDENCIES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
            "tokio": "@cvm__tokio-1.28.2//:tokio",
        },
    },
}

_NORMAL_ALIASES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
        },
    },
}

_NORMAL_DEV_DEPENDENCIES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
            "tempfile": "@cvm__tempfile-3.6.0//:tempfile",
            "tokio-test": "@cvm__tokio-test-0.4.2//:tokio_test",
        },
    },
}

_NORMAL_DEV_ALIASES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
        },
    },
}

_PROC_MACRO_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_PROC_MACRO_ALIASES = {
    "vendor_remote_manifests": {
    },
}

_PROC_MACRO_DEV_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_PROC_MACRO_DEV_ALIASES = {
    "vendor_remote_manifests": {
        _COMMON_CONDITION: {
        },
    },
}

_BUILD_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_BUILD_ALIASES = {
    "vendor_remote_manifests": {
    },
}

_BUILD_PROC_MACRO_DEPENDENCIES = {
    "vendor_remote_manifests": {
    },
}

_BUILD_PROC_MACRO_ALIASES = {
    "vendor_remote_manifests": {
    },
}

_CONDITIONS = {
    "cfg(all(any(target_arch = \"x86_64\", target_arch = \"aarch64\"), target_os = \"hermit\"))": [],
    "cfg(all(any(target_os = \"android\", target_os = \"linux\"), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\"))))))))": ["aarch64-linux-android", "armv7-linux-androideabi", "i686-linux-android", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "x86_64-linux-android"],
    "cfg(all(not(rustix_use_libc), not(miri), target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\")))))": ["aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-unknown-linux-gnueabi", "i686-unknown-linux-gnu", "x86_64-unknown-linux-gnu"],
    "cfg(all(not(windows), any(rustix_use_libc, miri, not(all(target_os = \"linux\", any(target_arch = \"x86\", all(target_arch = \"x86_64\", target_pointer_width = \"64\"), all(target_endian = \"little\", any(target_arch = \"arm\", all(target_arch = \"aarch64\", target_pointer_width = \"64\"), target_arch = \"powerpc64\", target_arch = \"riscv64\", target_arch = \"mips\", target_arch = \"mips64\"))))))))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "armv7-linux-androideabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "riscv64gc-unknown-none-elf", "s390x-unknown-linux-gnu", "thumbv7em-none-eabi", "thumbv8m.main-none-eabi", "wasm32-unknown-unknown", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-none"],
    "cfg(all(target_arch = \"aarch64\", target_env = \"gnu\", target_abi = \"llvm\", not(windows_raw_dylib)))": [],
    "cfg(all(target_arch = \"aarch64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["aarch64-pc-windows-msvc"],
    "cfg(all(target_arch = \"wasm32\", not(target_os = \"wasi\")))": ["wasm32-unknown-unknown"],
    "cfg(all(target_arch = \"x86\", target_env = \"gnu\", not(windows_raw_dylib)))": ["i686-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86\", target_env = \"msvc\", not(windows_raw_dylib)))": ["i686-pc-windows-msvc"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", not(target_abi = \"llvm\"), not(windows_raw_dylib)))": ["x86_64-unknown-linux-gnu"],
    "cfg(all(target_arch = \"x86_64\", target_env = \"gnu\", target_abi = \"llvm\", not(windows_raw_dylib)))": [],
    "cfg(all(target_arch = \"x86_64\", target_env = \"msvc\", not(windows_raw_dylib)))": ["x86_64-pc-windows-msvc"],
    "cfg(any(unix, target_os = \"wasi\"))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(docsrs)": [],
    "cfg(not(any(target_arch = \"wasm32\", target_arch = \"wasm64\")))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-pc-windows-msvc", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-pc-windows-msvc", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "riscv64gc-unknown-none-elf", "s390x-unknown-linux-gnu", "thumbv7em-none-eabi", "thumbv8m.main-none-eabi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-pc-windows-msvc", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu", "x86_64-unknown-none"],
    "cfg(not(windows))": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "riscv32imc-unknown-none-elf", "riscv64gc-unknown-none-elf", "s390x-unknown-linux-gnu", "thumbv7em-none-eabi", "thumbv8m.main-none-eabi", "wasm32-unknown-unknown", "wasm32-wasi", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu", "x86_64-unknown-none"],
    "cfg(target_os = \"dragonfly\")": [],
    "cfg(target_os = \"hermit\")": [],
    "cfg(target_os = \"redox\")": [],
    "cfg(target_os = \"wasi\")": ["wasm32-wasi"],
    "cfg(unix)": ["aarch64-apple-darwin", "aarch64-apple-ios", "aarch64-apple-ios-sim", "aarch64-fuchsia", "aarch64-linux-android", "aarch64-unknown-linux-gnu", "arm-unknown-linux-gnueabi", "armv7-linux-androideabi", "armv7-unknown-linux-gnueabi", "i686-apple-darwin", "i686-linux-android", "i686-unknown-freebsd", "i686-unknown-linux-gnu", "powerpc-unknown-linux-gnu", "s390x-unknown-linux-gnu", "x86_64-apple-darwin", "x86_64-apple-ios", "x86_64-fuchsia", "x86_64-linux-android", "x86_64-unknown-freebsd", "x86_64-unknown-linux-gnu"],
    "cfg(windows)": ["aarch64-pc-windows-msvc", "i686-pc-windows-msvc", "x86_64-pc-windows-msvc"],
    "i686-pc-windows-gnu": [],
    "x86_64-pc-windows-gnu": [],
}

###############################################################################

def crate_repositories():
    """A macro for defining repositories for all generated crates"""
    maybe(
        http_archive,
        name = "cvm__async-stream-0.3.5",
        sha256 = "cd56dd203fef61ac097dd65721a419ddccb106b2d2b70ba60a6b529f03961a51",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/async-stream/0.3.5/download"],
        strip_prefix = "async-stream-0.3.5",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.async-stream-0.3.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__async-stream-impl-0.3.5",
        sha256 = "16e62a023e7c117e27523144c5d2459f4397fcc3cab0085af8e2224f643a0193",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/async-stream-impl/0.3.5/download"],
        strip_prefix = "async-stream-impl-0.3.5",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.async-stream-impl-0.3.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__autocfg-1.1.0",
        sha256 = "d468802bab17cbc0cc575e9b053f41e72aa36bfa6b7f55e3529ffa43161b97fa",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/autocfg/1.1.0/download"],
        strip_prefix = "autocfg-1.1.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.autocfg-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__bitflags-1.3.2",
        sha256 = "bef38d45163c2f1dde094a7dfd33ccf595c92905c8f8f4fdc18d06fb1037718a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bitflags/1.3.2/download"],
        strip_prefix = "bitflags-1.3.2",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.bitflags-1.3.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__bytes-1.4.0",
        sha256 = "89b2fd2a0dcf38d7971e2194b6b6eebab45ae01067456a7fd93d5547a61b70be",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/bytes/1.4.0/download"],
        strip_prefix = "bytes-1.4.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.bytes-1.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__cc-1.0.79",
        sha256 = "50d30906286121d95be3d479533b458f87493b30a4b5f79a607db8f5d11aa91f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cc/1.0.79/download"],
        strip_prefix = "cc-1.0.79",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.cc-1.0.79.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__cfg-if-1.0.0",
        sha256 = "baf1de4339761588bc0619e3cbc0120ee582ebb74b53b4efbf79117bd2da40fd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/cfg-if/1.0.0/download"],
        strip_prefix = "cfg-if-1.0.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.cfg-if-1.0.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__errno-0.3.1",
        sha256 = "4bcfec3a70f97c962c307b2d2c56e358cf1d00b558d74262b5f929ee8cc7e73a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/errno/0.3.1/download"],
        strip_prefix = "errno-0.3.1",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.errno-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__errno-dragonfly-0.1.2",
        sha256 = "aa68f1b12764fab894d2755d2518754e71b4fd80ecfb822714a1206c2aab39bf",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/errno-dragonfly/0.1.2/download"],
        strip_prefix = "errno-dragonfly-0.1.2",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.errno-dragonfly-0.1.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__fastrand-1.9.0",
        sha256 = "e51093e27b0797c359783294ca4f0a911c270184cb10f85783b118614a1501be",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/fastrand/1.9.0/download"],
        strip_prefix = "fastrand-1.9.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.fastrand-1.9.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__futures-core-0.3.28",
        sha256 = "4bca583b7e26f571124fe5b7561d49cb2868d79116cfa0eefce955557c6fee8c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/futures-core/0.3.28/download"],
        strip_prefix = "futures-core-0.3.28",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.futures-core-0.3.28.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__hermit-abi-0.2.6",
        sha256 = "ee512640fe35acbfb4bb779db6f0d80704c2cacfa2e39b601ef3e3f47d1ae4c7",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.2.6/download"],
        strip_prefix = "hermit-abi-0.2.6",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.hermit-abi-0.2.6.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__hermit-abi-0.3.1",
        sha256 = "fed44880c466736ef9a5c5b5facefb5ed0785676d0c02d612db14e54f0d84286",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/hermit-abi/0.3.1/download"],
        strip_prefix = "hermit-abi-0.3.1",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.hermit-abi-0.3.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__instant-0.1.12",
        sha256 = "7a5bbe824c507c5da5956355e86a746d82e0e1464f65d862cc5e71da70e94b2c",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/instant/0.1.12/download"],
        strip_prefix = "instant-0.1.12",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.instant-0.1.12.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__io-lifetimes-1.0.11",
        sha256 = "eae7b9aee968036d54dce06cebaefd919e4472e753296daccd6d344e3e2df0c2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/io-lifetimes/1.0.11/download"],
        strip_prefix = "io-lifetimes-1.0.11",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.io-lifetimes-1.0.11.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__libc-0.2.146",
        sha256 = "f92be4933c13fd498862a9e02a3055f8a8d9c039ce33db97306fd5a6caa7f29b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/libc/0.2.146/download"],
        strip_prefix = "libc-0.2.146",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.libc-0.2.146.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__linux-raw-sys-0.3.8",
        sha256 = "ef53942eb7bf7ff43a617b3e2c1c4a5ecf5944a7c1bc12d7ee39bbb15e5c1519",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/linux-raw-sys/0.3.8/download"],
        strip_prefix = "linux-raw-sys-0.3.8",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.linux-raw-sys-0.3.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__lock_api-0.4.10",
        sha256 = "c1cc9717a20b1bb222f333e6a92fd32f7d8a18ddc5a3191a11af45dcbf4dcd16",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/lock_api/0.4.10/download"],
        strip_prefix = "lock_api-0.4.10",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.lock_api-0.4.10.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__mio-0.8.8",
        sha256 = "927a765cd3fc26206e66b296465fa9d3e5ab003e651c1b3c060e7956d96b19d2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/mio/0.8.8/download"],
        strip_prefix = "mio-0.8.8",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.mio-0.8.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__num_cpus-1.15.0",
        sha256 = "0fac9e2da13b5eb447a6ce3d392f23a29d8694bff781bf03a16cd9ac8697593b",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/num_cpus/1.15.0/download"],
        strip_prefix = "num_cpus-1.15.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.num_cpus-1.15.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__parking_lot-0.12.1",
        sha256 = "3742b2c103b9f06bc9fff0a37ff4912935851bee6d36f3c02bcc755bcfec228f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/parking_lot/0.12.1/download"],
        strip_prefix = "parking_lot-0.12.1",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.parking_lot-0.12.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__parking_lot_core-0.9.8",
        sha256 = "93f00c865fe7cabf650081affecd3871070f26767e7b2070a3ffae14c654b447",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/parking_lot_core/0.9.8/download"],
        strip_prefix = "parking_lot_core-0.9.8",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.parking_lot_core-0.9.8.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__pin-project-lite-0.2.9",
        sha256 = "e0a7ae3ac2f1173085d398531c705756c94a4c56843785df85a60c1a0afac116",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/pin-project-lite/0.2.9/download"],
        strip_prefix = "pin-project-lite-0.2.9",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.pin-project-lite-0.2.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__proc-macro2-1.0.60",
        sha256 = "dec2b086b7a862cf4de201096214fa870344cf922b2b30c167badb3af3195406",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/proc-macro2/1.0.60/download"],
        strip_prefix = "proc-macro2-1.0.60",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.proc-macro2-1.0.60.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__quote-1.0.28",
        sha256 = "1b9ab9c7eadfd8df19006f1cf1a4aed13540ed5cbc047010ece5826e10825488",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/quote/1.0.28/download"],
        strip_prefix = "quote-1.0.28",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.quote-1.0.28.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__redox_syscall-0.3.5",
        sha256 = "567664f262709473930a4bf9e51bf2ebf3348f2e748ccc50dea20646858f8f29",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/redox_syscall/0.3.5/download"],
        strip_prefix = "redox_syscall-0.3.5",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.redox_syscall-0.3.5.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__rustix-0.37.20",
        sha256 = "b96e891d04aa506a6d1f318d2771bcb1c7dfda84e126660ace067c9b474bb2c0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/rustix/0.37.20/download"],
        strip_prefix = "rustix-0.37.20",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.rustix-0.37.20.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__scopeguard-1.1.0",
        sha256 = "d29ab0c6d3fc0ee92fe66e2d99f700eab17a8d57d1c1d3b748380fb20baa78cd",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/scopeguard/1.1.0/download"],
        strip_prefix = "scopeguard-1.1.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.scopeguard-1.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__signal-hook-registry-1.4.1",
        sha256 = "d8229b473baa5980ac72ef434c4415e70c4b5e71b423043adb4ba059f89c99a1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/signal-hook-registry/1.4.1/download"],
        strip_prefix = "signal-hook-registry-1.4.1",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.signal-hook-registry-1.4.1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__smallvec-1.10.0",
        sha256 = "a507befe795404456341dfab10cef66ead4c041f62b8b11bbb92bffe5d0953e0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/smallvec/1.10.0/download"],
        strip_prefix = "smallvec-1.10.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.smallvec-1.10.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__socket2-0.4.9",
        sha256 = "64a4a911eed85daf18834cfaa86a79b7d266ff93ff5ba14005426219480ed662",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/socket2/0.4.9/download"],
        strip_prefix = "socket2-0.4.9",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.socket2-0.4.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__syn-2.0.18",
        sha256 = "32d41677bcbe24c20c52e7c70b0d8db04134c5d1066bf98662e2871ad200ea3e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/syn/2.0.18/download"],
        strip_prefix = "syn-2.0.18",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.syn-2.0.18.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tempfile-3.6.0",
        sha256 = "31c0432476357e58790aaa47a8efb0c5138f137343f3b5f23bd36a27e3b0a6d6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tempfile/3.6.0/download"],
        strip_prefix = "tempfile-3.6.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.tempfile-3.6.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-1.28.2",
        sha256 = "94d7b1cfd2aa4011f2de74c2c4c63665e27a71006b0a192dcd2710272e73dfa2",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio/1.28.2/download"],
        strip_prefix = "tokio-1.28.2",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.tokio-1.28.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-macros-2.1.0",
        sha256 = "630bdcf245f78637c13ec01ffae6187cca34625e8c63150d424b59e55af2675e",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio-macros/2.1.0/download"],
        strip_prefix = "tokio-macros-2.1.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.tokio-macros-2.1.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-stream-0.1.14",
        sha256 = "397c988d37662c7dda6d2208364a706264bf3d6138b11d436cbac0ad38832842",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio-stream/0.1.14/download"],
        strip_prefix = "tokio-stream-0.1.14",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.tokio-stream-0.1.14.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__tokio-test-0.4.2",
        sha256 = "53474327ae5e166530d17f2d956afcb4f8a004de581b3cae10f12006bc8163e3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/tokio-test/0.4.2/download"],
        strip_prefix = "tokio-test-0.4.2",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.tokio-test-0.4.2.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__unicode-ident-1.0.9",
        sha256 = "b15811caf2415fb889178633e7724bad2509101cde276048e013b9def5e51fa0",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/unicode-ident/1.0.9/download"],
        strip_prefix = "unicode-ident-1.0.9",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.unicode-ident-1.0.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__wasi-0.11.0-wasi-snapshot-preview1",
        sha256 = "9c8d87e72b64a3b4db28d11ce29237c246188f4f51057d65a7eab63b7987e423",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/wasi/0.11.0+wasi-snapshot-preview1/download"],
        strip_prefix = "wasi-0.11.0+wasi-snapshot-preview1",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.wasi-0.11.0+wasi-snapshot-preview1.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__winapi-0.3.9",
        sha256 = "5c839a674fcd7a98952e593242ea400abe93992746761e38641405d28b00f419",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi/0.3.9/download"],
        strip_prefix = "winapi-0.3.9",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.winapi-0.3.9.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__winapi-i686-pc-windows-gnu-0.4.0",
        sha256 = "ac3b87c63620426dd9b991e5ce0329eff545bccbbb34f3be09ff6fb6ab51b7b6",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-i686-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-i686-pc-windows-gnu-0.4.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.winapi-i686-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__winapi-x86_64-pc-windows-gnu-0.4.0",
        sha256 = "712e227841d057c1ee1cd2fb22fa7e5a5461ae8e48fa2ca79ec42cfc1931183f",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/winapi-x86_64-pc-windows-gnu/0.4.0/download"],
        strip_prefix = "winapi-x86_64-pc-windows-gnu-0.4.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.winapi-x86_64-pc-windows-gnu-0.4.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows-sys-0.48.0",
        sha256 = "677d2418bec65e3338edb076e806bc1ec15693c5d0104683f2efe857f61056a9",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-sys/0.48.0/download"],
        strip_prefix = "windows-sys-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows-sys-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows-targets-0.48.0",
        sha256 = "7b1eb6f0cd7c80c79759c929114ef071b87354ce476d9d94271031c0497adfd5",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows-targets/0.48.0/download"],
        strip_prefix = "windows-targets-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows-targets-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_aarch64_gnullvm-0.48.0",
        sha256 = "91ae572e1b79dba883e0d315474df7305d12f569b400fcf90581b06062f7e1bc",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_gnullvm/0.48.0/download"],
        strip_prefix = "windows_aarch64_gnullvm-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows_aarch64_gnullvm-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_aarch64_msvc-0.48.0",
        sha256 = "b2ef27e0d7bdfcfc7b868b317c1d32c641a6fe4629c171b8928c7b08d98d7cf3",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_aarch64_msvc/0.48.0/download"],
        strip_prefix = "windows_aarch64_msvc-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows_aarch64_msvc-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_i686_gnu-0.48.0",
        sha256 = "622a1962a7db830d6fd0a69683c80a18fda201879f0f447f065a3b7467daa241",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_gnu/0.48.0/download"],
        strip_prefix = "windows_i686_gnu-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows_i686_gnu-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_i686_msvc-0.48.0",
        sha256 = "4542c6e364ce21bf45d69fdd2a8e455fa38d316158cfd43b3ac1c5b1b19f8e00",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_i686_msvc/0.48.0/download"],
        strip_prefix = "windows_i686_msvc-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows_i686_msvc-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_x86_64_gnu-0.48.0",
        sha256 = "ca2b8a661f7628cbd23440e50b05d705db3686f894fc9580820623656af974b1",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnu/0.48.0/download"],
        strip_prefix = "windows_x86_64_gnu-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows_x86_64_gnu-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_x86_64_gnullvm-0.48.0",
        sha256 = "7896dbc1f41e08872e9d5e8f8baa8fdd2677f29468c4e156210174edc7f7b953",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_gnullvm/0.48.0/download"],
        strip_prefix = "windows_x86_64_gnullvm-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows_x86_64_gnullvm-0.48.0.bazel"),
    )

    maybe(
        http_archive,
        name = "cvm__windows_x86_64_msvc-0.48.0",
        sha256 = "1a515f5799fe4961cb532f983ce2b23082366b898e52ffbce459c86f67c8378a",
        type = "tar.gz",
        urls = ["https://crates.io/api/v1/crates/windows_x86_64_msvc/0.48.0/download"],
        strip_prefix = "windows_x86_64_msvc-0.48.0",
        build_file = Label("@examples//vendor_remote_manifests/crates:BUILD.windows_x86_64_msvc-0.48.0.bazel"),
    )
