// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// https://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or https://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

use autocxx::prelude::*; // use all the main autocxx functions

include_cpp! {
    #include "llvm/Support/MemoryBuffer.h"
    safety!(unsafe)
    generate!("llvm::MemoryBuffer")
}

// Simply re-export the MemoryBuffer API to users of this library.
// Generally speaking, the APIs generated by autocxx (or similar tools)
// still contain C++-isms, and it's wise to consider making idiomatic
// Rust wrappers instead of doing this.
pub use ffi::llvm::MemoryBuffer;

// It would be advisable to add tests here.
