// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

// THIS FILE WAS AUTO-GENERATED BY ./ntcore/generate_topics.py. DO NOT MODIFY

#pragma once

#include <vector>

#include "networktables/StringTopic.h"
#include "networktables/NetworkTableType.h"
#include "ntcore_cpp.h"

namespace nt {

inline StringSubscriber::StringSubscriber(
    NT_Subscriber handle, std::string_view defaultValue)
    : Subscriber{handle},
      m_defaultValue{defaultValue} {}

inline std::string StringSubscriber::Get() const {
  return Get(m_defaultValue);
}

inline std::string StringSubscriber::Get(
    std::string_view defaultValue) const {
  return ::nt::GetString(m_subHandle, defaultValue);
}

inline std::string_view StringSubscriber::Get(wpi::SmallVectorImpl<char>& buf) const {
  return Get(buf, m_defaultValue);
}

inline std::string_view StringSubscriber::Get(wpi::SmallVectorImpl<char>& buf, std::string_view defaultValue) const {
  return nt::GetString(m_subHandle, buf, defaultValue);
}

inline TimestampedString StringSubscriber::GetAtomic() const {
  return GetAtomic(m_defaultValue);
}

inline TimestampedString StringSubscriber::GetAtomic(
    std::string_view defaultValue) const {
  return ::nt::GetAtomicString(m_subHandle, defaultValue);
}

inline TimestampedStringView StringSubscriber::GetAtomic(wpi::SmallVectorImpl<char>& buf) const {
  return GetAtomic(buf, m_defaultValue);
}

inline TimestampedStringView StringSubscriber::GetAtomic(wpi::SmallVectorImpl<char>& buf, std::string_view defaultValue) const {
  return nt::GetAtomicString(m_subHandle, buf, defaultValue);
}

inline std::vector<TimestampedString>
StringSubscriber::ReadQueue() {
  return ::nt::ReadQueueString(m_subHandle);
}

inline StringTopic StringSubscriber::GetTopic() const {
  return StringTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline StringPublisher::StringPublisher(NT_Publisher handle)
    : Publisher{handle} {}

inline void StringPublisher::Set(std::string_view value,
                                         int64_t time) {
  ::nt::SetString(m_pubHandle, value, time);
}

inline void StringPublisher::SetDefault(std::string_view value) {
  ::nt::SetDefaultString(m_pubHandle, value);
}

inline StringTopic StringPublisher::GetTopic() const {
  return StringTopic{::nt::GetTopicFromHandle(m_pubHandle)};
}

inline StringEntry::StringEntry(
    NT_Entry handle, std::string_view defaultValue)
    : StringSubscriber{handle, defaultValue},
      StringPublisher{handle} {}

inline StringTopic StringEntry::GetTopic() const {
  return StringTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline void StringEntry::Unpublish() {
  ::nt::Unpublish(m_pubHandle);
}

inline StringSubscriber StringTopic::Subscribe(
    std::string_view defaultValue,
    const PubSubOptions& options) {
  return StringSubscriber{
      ::nt::Subscribe(m_handle, NT_STRING, "string", options),
      defaultValue};
}
inline StringSubscriber StringTopic::SubscribeEx(
    std::string_view typeString, std::string_view defaultValue,
    const PubSubOptions& options) {
  return StringSubscriber{
      ::nt::Subscribe(m_handle, NT_STRING, typeString, options),
      defaultValue};
}

inline StringPublisher StringTopic::Publish(
    const PubSubOptions& options) {
  return StringPublisher{
      ::nt::Publish(m_handle, NT_STRING, "string", options)};
}

inline StringPublisher StringTopic::PublishEx(
    std::string_view typeString,
    const wpi::json& properties, const PubSubOptions& options) {
  return StringPublisher{
      ::nt::PublishEx(m_handle, NT_STRING, typeString, properties, options)};
}

inline StringEntry StringTopic::GetEntry(
    std::string_view defaultValue,
    const PubSubOptions& options) {
  return StringEntry{
      ::nt::GetEntry(m_handle, NT_STRING, "string", options),
      defaultValue};
}
inline StringEntry StringTopic::GetEntryEx(
    std::string_view typeString, std::string_view defaultValue,
    const PubSubOptions& options) {
  return StringEntry{
      ::nt::GetEntry(m_handle, NT_STRING, typeString, options),
      defaultValue};
}

}  // namespace nt
