// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

// THIS FILE WAS AUTO-GENERATED BY ./ntcore/generate_topics.py. DO NOT MODIFY

#pragma once

#include <vector>

#include "networktables/IntegerTopic.h"
#include "networktables/NetworkTableType.h"
#include "ntcore_cpp.h"

namespace nt {

inline IntegerSubscriber::IntegerSubscriber(
    NT_Subscriber handle, int64_t defaultValue)
    : Subscriber{handle},
      m_defaultValue{defaultValue} {}

inline int64_t IntegerSubscriber::Get() const {
  return Get(m_defaultValue);
}

inline int64_t IntegerSubscriber::Get(
    int64_t defaultValue) const {
  return ::nt::GetInteger(m_subHandle, defaultValue);
}

inline TimestampedInteger IntegerSubscriber::GetAtomic() const {
  return GetAtomic(m_defaultValue);
}

inline TimestampedInteger IntegerSubscriber::GetAtomic(
    int64_t defaultValue) const {
  return ::nt::GetAtomicInteger(m_subHandle, defaultValue);
}

inline std::vector<TimestampedInteger>
IntegerSubscriber::ReadQueue() {
  return ::nt::ReadQueueInteger(m_subHandle);
}

inline IntegerTopic IntegerSubscriber::GetTopic() const {
  return IntegerTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline IntegerPublisher::IntegerPublisher(NT_Publisher handle)
    : Publisher{handle} {}

inline void IntegerPublisher::Set(int64_t value,
                                         int64_t time) {
  ::nt::SetInteger(m_pubHandle, value, time);
}

inline void IntegerPublisher::SetDefault(int64_t value) {
  ::nt::SetDefaultInteger(m_pubHandle, value);
}

inline IntegerTopic IntegerPublisher::GetTopic() const {
  return IntegerTopic{::nt::GetTopicFromHandle(m_pubHandle)};
}

inline IntegerEntry::IntegerEntry(
    NT_Entry handle, int64_t defaultValue)
    : IntegerSubscriber{handle, defaultValue},
      IntegerPublisher{handle} {}

inline IntegerTopic IntegerEntry::GetTopic() const {
  return IntegerTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline void IntegerEntry::Unpublish() {
  ::nt::Unpublish(m_pubHandle);
}

inline IntegerSubscriber IntegerTopic::Subscribe(
    int64_t defaultValue,
    const PubSubOptions& options) {
  return IntegerSubscriber{
      ::nt::Subscribe(m_handle, NT_INTEGER, "int", options),
      defaultValue};
}
inline IntegerSubscriber IntegerTopic::SubscribeEx(
    std::string_view typeString, int64_t defaultValue,
    const PubSubOptions& options) {
  return IntegerSubscriber{
      ::nt::Subscribe(m_handle, NT_INTEGER, typeString, options),
      defaultValue};
}

inline IntegerPublisher IntegerTopic::Publish(
    const PubSubOptions& options) {
  return IntegerPublisher{
      ::nt::Publish(m_handle, NT_INTEGER, "int", options)};
}

inline IntegerPublisher IntegerTopic::PublishEx(
    std::string_view typeString,
    const wpi::json& properties, const PubSubOptions& options) {
  return IntegerPublisher{
      ::nt::PublishEx(m_handle, NT_INTEGER, typeString, properties, options)};
}

inline IntegerEntry IntegerTopic::GetEntry(
    int64_t defaultValue,
    const PubSubOptions& options) {
  return IntegerEntry{
      ::nt::GetEntry(m_handle, NT_INTEGER, "int", options),
      defaultValue};
}
inline IntegerEntry IntegerTopic::GetEntryEx(
    std::string_view typeString, int64_t defaultValue,
    const PubSubOptions& options) {
  return IntegerEntry{
      ::nt::GetEntry(m_handle, NT_INTEGER, typeString, options),
      defaultValue};
}

}  // namespace nt
