// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

// THIS FILE WAS AUTO-GENERATED BY ./ntcore/generate_topics.py. DO NOT MODIFY

#pragma once

#include <vector>

#include "networktables/FloatTopic.h"
#include "networktables/NetworkTableType.h"
#include "ntcore_cpp.h"

namespace nt {

inline FloatSubscriber::FloatSubscriber(
    NT_Subscriber handle, float defaultValue)
    : Subscriber{handle},
      m_defaultValue{defaultValue} {}

inline float FloatSubscriber::Get() const {
  return Get(m_defaultValue);
}

inline float FloatSubscriber::Get(
    float defaultValue) const {
  return ::nt::GetFloat(m_subHandle, defaultValue);
}

inline TimestampedFloat FloatSubscriber::GetAtomic() const {
  return GetAtomic(m_defaultValue);
}

inline TimestampedFloat FloatSubscriber::GetAtomic(
    float defaultValue) const {
  return ::nt::GetAtomicFloat(m_subHandle, defaultValue);
}

inline std::vector<TimestampedFloat>
FloatSubscriber::ReadQueue() {
  return ::nt::ReadQueueFloat(m_subHandle);
}

inline FloatTopic FloatSubscriber::GetTopic() const {
  return FloatTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline FloatPublisher::FloatPublisher(NT_Publisher handle)
    : Publisher{handle} {}

inline void FloatPublisher::Set(float value,
                                         int64_t time) {
  ::nt::SetFloat(m_pubHandle, value, time);
}

inline void FloatPublisher::SetDefault(float value) {
  ::nt::SetDefaultFloat(m_pubHandle, value);
}

inline FloatTopic FloatPublisher::GetTopic() const {
  return FloatTopic{::nt::GetTopicFromHandle(m_pubHandle)};
}

inline FloatEntry::FloatEntry(
    NT_Entry handle, float defaultValue)
    : FloatSubscriber{handle, defaultValue},
      FloatPublisher{handle} {}

inline FloatTopic FloatEntry::GetTopic() const {
  return FloatTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline void FloatEntry::Unpublish() {
  ::nt::Unpublish(m_pubHandle);
}

inline FloatSubscriber FloatTopic::Subscribe(
    float defaultValue,
    const PubSubOptions& options) {
  return FloatSubscriber{
      ::nt::Subscribe(m_handle, NT_FLOAT, "float", options),
      defaultValue};
}
inline FloatSubscriber FloatTopic::SubscribeEx(
    std::string_view typeString, float defaultValue,
    const PubSubOptions& options) {
  return FloatSubscriber{
      ::nt::Subscribe(m_handle, NT_FLOAT, typeString, options),
      defaultValue};
}

inline FloatPublisher FloatTopic::Publish(
    const PubSubOptions& options) {
  return FloatPublisher{
      ::nt::Publish(m_handle, NT_FLOAT, "float", options)};
}

inline FloatPublisher FloatTopic::PublishEx(
    std::string_view typeString,
    const wpi::json& properties, const PubSubOptions& options) {
  return FloatPublisher{
      ::nt::PublishEx(m_handle, NT_FLOAT, typeString, properties, options)};
}

inline FloatEntry FloatTopic::GetEntry(
    float defaultValue,
    const PubSubOptions& options) {
  return FloatEntry{
      ::nt::GetEntry(m_handle, NT_FLOAT, "float", options),
      defaultValue};
}
inline FloatEntry FloatTopic::GetEntryEx(
    std::string_view typeString, float defaultValue,
    const PubSubOptions& options) {
  return FloatEntry{
      ::nt::GetEntry(m_handle, NT_FLOAT, typeString, options),
      defaultValue};
}

}  // namespace nt
