// Copyright (c) FIRST and other WPILib contributors.
// Open Source Software; you can modify and/or share it under the terms of
// the WPILib BSD license file in the root directory of this project.

// THIS FILE WAS AUTO-GENERATED BY ./ntcore/generate_topics.py. DO NOT MODIFY

#pragma once

#include <vector>

#include "networktables/FloatArrayTopic.h"
#include "networktables/NetworkTableType.h"
#include "ntcore_cpp.h"

namespace nt {

inline FloatArraySubscriber::FloatArraySubscriber(
    NT_Subscriber handle, std::span<const float> defaultValue)
    : Subscriber{handle},
      m_defaultValue{defaultValue.begin(), defaultValue.end()} {}

inline std::vector<float> FloatArraySubscriber::Get() const {
  return Get(m_defaultValue);
}

inline std::vector<float> FloatArraySubscriber::Get(
    std::span<const float> defaultValue) const {
  return ::nt::GetFloatArray(m_subHandle, defaultValue);
}

inline std::span<float> FloatArraySubscriber::Get(wpi::SmallVectorImpl<float>& buf) const {
  return Get(buf, m_defaultValue);
}

inline std::span<float> FloatArraySubscriber::Get(wpi::SmallVectorImpl<float>& buf, std::span<const float> defaultValue) const {
  return nt::GetFloatArray(m_subHandle, buf, defaultValue);
}

inline TimestampedFloatArray FloatArraySubscriber::GetAtomic() const {
  return GetAtomic(m_defaultValue);
}

inline TimestampedFloatArray FloatArraySubscriber::GetAtomic(
    std::span<const float> defaultValue) const {
  return ::nt::GetAtomicFloatArray(m_subHandle, defaultValue);
}

inline TimestampedFloatArrayView FloatArraySubscriber::GetAtomic(wpi::SmallVectorImpl<float>& buf) const {
  return GetAtomic(buf, m_defaultValue);
}

inline TimestampedFloatArrayView FloatArraySubscriber::GetAtomic(wpi::SmallVectorImpl<float>& buf, std::span<const float> defaultValue) const {
  return nt::GetAtomicFloatArray(m_subHandle, buf, defaultValue);
}

inline std::vector<TimestampedFloatArray>
FloatArraySubscriber::ReadQueue() {
  return ::nt::ReadQueueFloatArray(m_subHandle);
}

inline FloatArrayTopic FloatArraySubscriber::GetTopic() const {
  return FloatArrayTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline FloatArrayPublisher::FloatArrayPublisher(NT_Publisher handle)
    : Publisher{handle} {}

inline void FloatArrayPublisher::Set(std::span<const float> value,
                                         int64_t time) {
  ::nt::SetFloatArray(m_pubHandle, value, time);
}

inline void FloatArrayPublisher::SetDefault(std::span<const float> value) {
  ::nt::SetDefaultFloatArray(m_pubHandle, value);
}

inline FloatArrayTopic FloatArrayPublisher::GetTopic() const {
  return FloatArrayTopic{::nt::GetTopicFromHandle(m_pubHandle)};
}

inline FloatArrayEntry::FloatArrayEntry(
    NT_Entry handle, std::span<const float> defaultValue)
    : FloatArraySubscriber{handle, defaultValue},
      FloatArrayPublisher{handle} {}

inline FloatArrayTopic FloatArrayEntry::GetTopic() const {
  return FloatArrayTopic{::nt::GetTopicFromHandle(m_subHandle)};
}

inline void FloatArrayEntry::Unpublish() {
  ::nt::Unpublish(m_pubHandle);
}

inline FloatArraySubscriber FloatArrayTopic::Subscribe(
    std::span<const float> defaultValue,
    const PubSubOptions& options) {
  return FloatArraySubscriber{
      ::nt::Subscribe(m_handle, NT_FLOAT_ARRAY, "float[]", options),
      defaultValue};
}
inline FloatArraySubscriber FloatArrayTopic::SubscribeEx(
    std::string_view typeString, std::span<const float> defaultValue,
    const PubSubOptions& options) {
  return FloatArraySubscriber{
      ::nt::Subscribe(m_handle, NT_FLOAT_ARRAY, typeString, options),
      defaultValue};
}

inline FloatArrayPublisher FloatArrayTopic::Publish(
    const PubSubOptions& options) {
  return FloatArrayPublisher{
      ::nt::Publish(m_handle, NT_FLOAT_ARRAY, "float[]", options)};
}

inline FloatArrayPublisher FloatArrayTopic::PublishEx(
    std::string_view typeString,
    const wpi::json& properties, const PubSubOptions& options) {
  return FloatArrayPublisher{
      ::nt::PublishEx(m_handle, NT_FLOAT_ARRAY, typeString, properties, options)};
}

inline FloatArrayEntry FloatArrayTopic::GetEntry(
    std::span<const float> defaultValue,
    const PubSubOptions& options) {
  return FloatArrayEntry{
      ::nt::GetEntry(m_handle, NT_FLOAT_ARRAY, "float[]", options),
      defaultValue};
}
inline FloatArrayEntry FloatArrayTopic::GetEntryEx(
    std::string_view typeString, std::span<const float> defaultValue,
    const PubSubOptions& options) {
  return FloatArrayEntry{
      ::nt::GetEntry(m_handle, NT_FLOAT_ARRAY, typeString, options),
      defaultValue};
}

}  // namespace nt
