macro(subdir_list result curdir)
    file(GLOB children RELATIVE ${curdir} ${curdir}/*)
    set(dirlist "")
    foreach(child ${children})
        if(IS_DIRECTORY ${curdir}/${child})
            list(APPEND dirlist ${child})
        endif()
    endforeach()
    set(${result} ${dirlist})
endmacro()

macro(add_all_subdirectories curdir)
    subdir_list(_SUBPROJECTS ${curdir})
    foreach(dir ${_SUBPROJECTS})
        add_subdirectory(${dir})
    endforeach()
endmacro()
