files = {
    "adwaita-icon-theme_3.22.0-1+deb9u1_all.deb": "9f956279c715b657f590370751ee91e74376fe06b18cf35a05930b13bb1737a6",
    "blt_2.5.3+dfsg-3_amd64.deb": "69377b5d18f14caf2aeb24cba3bf12b4cbac18c7c715f60b39200aa7d025561c",
    "coreutils_8.26-3_amd64.deb": "ef6c0ab3d52a7d3e85ba4a9c04a1931264d34bab842da6e1428c8c4bda28a800",
    "fontconfig-config_2.11.0-6.7_all.deb": "8226e3a525fef6aee3268929d15ed8352a7edfa263b8f70e3eb1a0962e772e27",
    "fontconfig_2.11.0-6.7+b1_amd64.deb": "6976c5e1b690c9c92f55a1c53f57094fdb86e619481d2e903561436cc2235b73",
    "fonts-dejavu-core_2.37-1_all.deb": "58d21a255606191e6512cca51f32c4480e7a798945cc980623377696acfa3cfc",
    "fonts-liberation_1.07.4-2_all.deb": "b342d0382aaf8d64a61c347b6e83f84c1ad50aa4ed3df661ece9010fce3ee72a",
    "fonts-lyx_2.2.2-1_all.deb": "55f9e6aa61acb6d0e25dec9c71c1da21af83eea942c6f64d0646db7b96ff5048",
    "gnome-icon-theme_3.12.0-2_all.deb": "6f918206118943badc16751bc682ce764223652bf5d70b7683b680235a585788",
    "gtk-update-icon-cache_3.22.11-1_amd64.deb": "efb1b77e02a201a7e5bc3474bb2dbedb707de0bd734482a7f8d5df4579c5913a",
    "hicolor-icon-theme_0.15-1_all.deb": "ccad1133347b30513230c896e0072f58910affbbc8947e084d482bef6c5eea00",
    "libatk1.0-0_2.22.0-1_amd64.deb": "dd714b9581b5f6dcb4fe711285117b6a63fa03bd40ad7adad28838883f60236d",
    "libatk1.0-data_2.22.0-1_all.deb": "e48623184d071483e69d1c02dd0163f9a439b9e11c46628ebd230851b2625b1c",
    "libaudit-common_2.6.7-2_all.deb": "42c502f6d37d8d7b77e659d23c58b7e13401b52003782276eb891dfb1bf958c2",
    "libaudit1_2.6.7-2_amd64.deb": "9359b088d9679e6464bddcbc2074a0733eac05cf30857f18ef6c0b65aeaa6591",
    "libblkid1_2.29.2-1+deb9u1_amd64.deb": "796fa1b6cb42e836d84c3a4e1e54fcc31b5a45f98c0d215345d17030d7bb3dcd",
    "libbsd0_0.8.3-1_amd64.deb": "030e441cc6368041536a69adcaed6b4f4a37e0145817fc3eff16f37e3a81ecae",
    "libcairo2_1.14.8-1_amd64.deb": "1f6ebf5f89c05c2e4aae96343f41446e2a847a3686c1dd22db39922df1e60f73",
    "libcap-ng0_0.7.7-3+b1_amd64.deb": "9a428663ad84b2b886b57e22d45bb39e924eb1cfe1e137fd73e2e65cabb3347d",
    "libcroco3_0.6.11-3_amd64.deb": "3a1e1af6a81c04035d67c1928460270448ac5ae30b79f68cd1c2acabb77debf8",
    "libdatrie1_0.2.10-4+b1_amd64.deb": "07349230986b454db6cec4f20fd648235e89f5a7ba258371e5da1dd7ba3992c9",
    "libfontconfig1_2.11.0-6.7+b1_amd64.deb": "8e4ac54fe770ff84c4b596e5e66dacc94efad08940fa354a8c112db06c67d588",
    "libfreetype6_2.6.3-3.2_amd64.deb": "4fd6eb9c7f5d06a6cc2a7c35966aa8c06289f0cb599e0b291be235c63f28db1a",
    "libgdk-pixbuf2.0-0_2.36.5-2+deb9u2_amd64.deb": "0dca760e915f5ec6ef2445135d9daf50d9a7246ec9ef6e1386dceab6a2445028",
    "libgdk-pixbuf2.0-common_2.36.5-2+deb9u2_all.deb": "3895bb256529fbb72d9428681af732deee023b3210700857c2febd63022b0921",
    "libglib2.0-0_2.50.3-2+deb9u1_amd64.deb": "06da7996a1ce90653f2ea6fb09cd44f5a90b27cc5b61db97aa7bf959848fc4c1",
    "libgraphite2-3_1.3.10-1_amd64.deb": "abea07610dab52ea704b01231c179ea02fcf6ecb7606e0775fb3150916c8276b",
    "libgtk2.0-0_2.24.31-2_amd64.deb": "2406ad832e6f677de8107d2b2590cf7e4fa03d90bd644810cab76d54c7ced248",
    "libgtk2.0-common_2.24.31-2_all.deb": "cf9c7c0dd4fc876fe2088c0d23e082e4a8e44c424184bc277577b753f7ca8ced",
    "libharfbuzz0b_1.4.2-1_amd64.deb": "7d66151e6f07835f707a073a08e449e1ce971885af71ad6c474e0e85a2439610",
    "libicu57_57.1-6+deb9u3_amd64.deb": "631db26c25104e61028693b7014ef0ceb1d1f7e22796c8e5bc1110d406bdd060",
    "libjbig0_2.1-3.1+b2_amd64.deb": "9646d69eefce505407bf0437ea12fb7c2d47a3fd4434720ba46b642b6dcfd80f",
    "libjpeg62-turbo_1.5.1-2_amd64.deb": "55b4208bca9e772cd3d6e6a3f6bf3949d170e6da77e53b0ba59abb8f1658bb64",
    "libjs-jquery-ui_1.12.1+dfsg-4_all.deb": "65efba16f621f9b1fafefca0ecafac59df690776924c1137c4352fef18000713",
    "libjs-jquery_3.1.1-2+deb9u1_all.deb": "672c6d54028eb6aae02f85a99a753d5d3bb8c1a573040b981d2b853f1f27c238",
    "libmount1_2.29.2-1+deb9u1_amd64.deb": "37d9c4f275392ac8bf94dbc2aaeade4d95fd7605e1fbb1075ac77663599b6e6b",
    "libpam-modules-bin_1.1.8-3.6_amd64.deb": "2f6279ebec1e48d18ab0f33a321cb99c09f3eaf1a36273ff486060db871d3741",
    "libpam-modules_1.1.8-3.6_amd64.deb": "173bdb5b8dc7ab9bca3d09cca7456000678ccce0d08463ed8298a723eb26f031",
    "libpam0g_1.1.8-3.6_amd64.deb": "20f72da20526de9e94226d6f645772664fbc0e35f1c4a130048720322db3d3d2",
    "libpango-1.0-0_1.40.5-1_amd64.deb": "2973a15ad26aa1051dce9fa4c0ee7e06e4b03e99cf74b6e8697cb7384b346e8d",
    "libpangocairo-1.0-0_1.40.5-1_amd64.deb": "c7bb62778c4e6c8086028e50656c3eff6e238c1467da6f3020c3d843668060d9",
    "libpangoft2-1.0-0_1.40.5-1_amd64.deb": "d668b89229869a68cc411a25feff5016ff76c5ed0ae23855196f2a46f8f88e75",
    "libpixman-1-0_0.34.0-1_amd64.deb": "6c4155c4e217481aa728d39d2ba7d6ca6c88bb1e2b342ca24b2714e61903a3e1",
    "libpng16-16_1.6.28-1+deb9u1_amd64.deb": "1d0b8014cba18f84ce77398da9db9c71e1a8ce53fd8157cd7bf9ccf1d56a42f4",
    "librsvg2-2_2.40.16-1+b1_amd64.deb": "90397a051434d2a6484aeb7e7dd2b6610e54b156a94d615e917d514ac4bf196e",
    "librsvg2-common_2.40.16-1+b1_amd64.deb": "5604d832893fc49b5ebd66255e92fd7e79dbc6d3891475d00a127e389bf2f575",
    "libsemanage-common_2.6-2_all.deb": "f9ccd6a271af92cc2b557d5a3e2725b0d3a44a336704cded5f77e1a7a8503840",
    "libsemanage1_2.6-2_amd64.deb": "17fca1a09c432bcd025b00207785c00244594c7cce1e878a2729d50c82bbfc6a",
    "libsepol1_2.6-2_amd64.deb": "cfb1248894d4817acd435e68ff9b142e170c67829de1dacb6cea667d1b1fdfab",
    "libtcl8.6_8.6.6+dfsg-1+b1_amd64.deb": "1f44458197319632c84a10fbea3f969958106ffc44e6a9a54f9ed71725b8c7a7",
    "libthai-data_0.1.26-1_all.deb": "9e1709138f7d324fbcb6b62d48f6a2b365630e8f81c42db12e04d03d0e71f9f6",
    "libthai0_0.1.26-1_amd64.deb": "e9cfd37dc2b1e067ee70cd17c153235c852b83754cb039e86e554c3376853f3b",
    "libtiff5_4.0.8-2+deb9u4_amd64.deb": "16d5ca9b2c846ed56b141b7cff251abe17183566f55a1f5ef6c9a26ba8ff4bde",
    "libtk8.6_8.6.6-1+b1_amd64.deb": "5ad20e1c4d036dcb90b2e93ce89073a5e65198be0b69a972a33106af2c2b6f6f",
    "libustr-1.0-1_1.0.4-6_amd64.deb": "9cdfba388ccb3d9767325075d0291bc2f92f90e505c98e01a93012c796f68580",
    "libuuid1_2.29.2-1+deb9u1_amd64.deb": "6e16f3033f0147714af101e189dd6b260a986417c6bad8bb1cd9ffe70fa107c8",
    "libx11-6_1.6.4-3+deb9u1_amd64.deb": "bfb881d47a72a6d79a66327bf43e106c13c4dfbd9e87987ff551c3c0cd6bc92e",
    "libx11-data_1.6.4-3+deb9u1_all.deb": "c589d2decc374dff78da717a4716c0d79d9646abb7ccc4a64e1f61534a2ba3b3",
    "libxau6_1.0.8-1_amd64.deb": "b03b2d0d400c2002a2d38300bd6630306abb0ff325c3d4a4447ecceb58335228",
    "libxcb-render0_1.12-1_amd64.deb": "127ebbad060f4ba88c174b980c27cb4458e9782c65349d80034c3feb012c7343",
    "libxcb-shm0_1.12-1_amd64.deb": "3bed0565cfd144bc4f1752985572c3d62b4dd193fb1f1c4cb5f05f82878b459b",
    "libxcb1_1.12-1_amd64.deb": "358ac6d450042d1792e3b2093ed73530774e6bd7600536a2acc327b83b201384",
    "libxcomposite1_0.4.4-2_amd64.deb": "043c878356954f4521c401b160d554809115c472ca384d9f793c1c7542316eb9",
    "libxcursor1_1.1.14-1+deb9u2_amd64.deb": "af4908f3f2bcfe78586823eaf8ed65d838936cb26698c520538717367d836dc6",
    "libxdamage1_1.1.4-2+b3_amd64.deb": "860d474e576074711a58e248feb9fb62086f641cbfa986145cc6c105ef750cc5",
    "libxdmcp6_1.1.2-3_amd64.deb": "ecb8536f5fb34543b55bb9dc5f5b14c9dbb4150a7bddb3f2287b7cab6e9d25ef",
    "libxext6_1.3.3-1+b2_amd64.deb": "724901105792e983bd0e7c2b46960cd925dd6a2b33b5ee999b4e80aaf624b082",
    "libxfixes3_5.0.3-1_amd64.deb": "3b307490c669accd52dc627ad4dc269a03632ca512fbc7b185b572f76608ff4e",
    "libxft2_2.3.2-1+b2_amd64.deb": "25e6bdcfdccdb332b2d415b98170c1fe4841156397dfb04368ac6a9631401670",
    "libxi6_1.7.9-1_amd64.deb": "fe26733adf2025f184bf904caf088a5d3f6aa29a8863b616af9cafaad85b1237",
    "libxinerama1_1.1.3-1+b3_amd64.deb": "56977ee53b18388cc8735dc7a64e709c08c70104344b4f11f255470f08e58c00",
    "libxml2_2.9.4+dfsg1-2.2+deb9u2_amd64.deb": "287fdcf90302893234c4eecc357002a464f7dff43f77adb86dfaee6d32ae1c4d",
    "libxrandr2_1.5.1-1_amd64.deb": "8fdd8ba4a8ad819731d6bbd903b52851a2ec2f9ef4139d880e9be421ea61338c",
    "libxrender1_0.9.10-1_amd64.deb": "3ea17d07b5aa89012130e2acd92f0fc0ea67314e2f5eab6e33930ef688f48294",
    "libxss1_1.2.2-1_amd64.deb": "0f2fc4eff464b63a4fafed9ab2e499e1804dcee85c5d9a89e53c3ed6a2a06b88",
    "passwd_4.4-4.1_amd64.deb": "81448b1a55cfe82ca3f2791bea75fc4a41cd82eacfee3247c37a04deb9fc4a1a",
    "python-cycler_0.10.0-1_all.deb": "ed00546b732c9361205ca392ef178995ca50e647e2940261c61229968be3de76",
    "python-dateutil_2.5.3-2_all.deb": "3f440c3fea55c5a33b92ce4f30033997294e2e289c58712d2c4d38f169985315",
    "python-functools32_3.2.3.2-3_all.deb": "f0c35fb01be2f3c0c60ba1074ffb0b12de63dd0a7dcb4c7b09a44714d6447e1f",
    "python-matplotlib-data_2.0.0+dfsg1-2_all.deb": "ca349445130c54967e27c9a74e19c4678099183b946432428e627fcad577390b",
    "python-matplotlib_2.0.0+dfsg1-2_amd64.deb": "7ffcef500f7774e403b38e02d88811ff81a4800b54d23515e429d1eecbd76616",
    "python-pyparsing_2.1.10+dfsg1-1_all.deb": "0bc6785731658b613e51cd19c5ab54ac467063c2c99e4c56f2f459084e665f33",
    "python-six_1.10.0-3_all.deb": "547c1f63a8cf07d99a7a79da562a5a938bfaa08b292c1fa479afdebafbb955fa",
    "python-subprocess32_3.2.7-2_amd64.deb": "cc3581f29ad93cfbdeb06088d6e3b1feb16212e592b18d621dd910e2cdd87232",
    "python-tk_2.7.13-1_amd64.deb": "bf2dd505e155ae2de493ae86aa6217169149be5ebd1878ed9fc2ffcea2b91975",
    "python-tz_2016.7-0.3_all.deb": "de87fbcd276903afb2f94c6e76554e50fc339a379c3e3a0c8ef22c0f446cb39b",
    "python3-cycler_0.10.0-1_all.deb": "b49d81a972054f2df915002cd8ba9225fb6bd07a633487dda5813c137f6cfb76",
    "python3-dateutil_2.5.3-2_all.deb": "398d719e19dc7cc581e009c35d583860f427720bf971665a7739c29cd19d3470",
    "python3-matplotlib_2.0.0+dfsg1-2_amd64.deb": "8f5d3509d4f5451468c6de44fc8dfe391c3df4120079adc01ab5f13ff4194f5a",
    "python3-pyparsing_2.1.10+dfsg1-1_all.deb": "ee8d7f04f841248127e81b3d356d37e623ed29da284b28c7d2b8a5b34f0eebba",
    "python3-six_1.10.0-3_all.deb": "597005e64cf70e4be97170a47c33287f70a1c87a2979d47a434c10c9201af3ca",
    "python3-tk_3.5.3-1_amd64.deb": "67489a1c86a9e501dbe2989cd72b5b2c70511fe3829af3567a009271b61fdbb5",
    "python3-tz_2016.7-0.3_all.deb": "5f1c7db456aac5fe9b0ea66d7413c12660c7652ae382c640f71c517a05d39551",
    "shared-mime-info_1.8-1+deb9u1_amd64.deb": "d6591f13ee1200c4f0b5581c2299eb7b8097a6b04742dc333e34a7bb7ba47532",
    "tk8.6-blt2.5_2.5.3+dfsg-3_amd64.deb": "88587a928e2bd692650d98c1483b67f1dee1fed57730077c895e689462af1569",
    "ttf-bitstream-vera_1.10-8_all.deb": "328def7f581bf94b3b06d21e641f3e5df9a9b2e84e93b4206bc952fe8e80f38a",
    "tzdata_2019c-0+deb9u1_all.deb": "80c9809dafc62ec741cbf3024130253de6047af31a10f0c86bb17f2d12ad10d5",
    "ucf_3.0036_all.deb": "796a65e765d6045007175531d512c720f4eb04e7f3326b79b848bc6123947225",
}

def build_matplotlib(version, tkinter_py_version = None, copy_shared_files = True):
    """Creates a py_library rule for matplotlib for the given python version.

    See debian/matplotlib.BUILD for the usage.

    All the rules generated by this will be suffixed by version. Only one
    instance of this macro should set copy_shared_files, which generate the
    files that are shared between python versions.

    tkinter_py_version is used because for the Python3 instance, some files
    are in folders named python3 and some are in folders named python3.5...

    version numbers should both be strings.
    """
    if tkinter_py_version == None:
        tkinter_py_version = version

    native.genrule(
        name = "patch_init" + version,
        srcs = [
            "usr/lib/python" + version + "/dist-packages/matplotlib/__init__.py",
            "@//debian:matplotlib_patches",
        ],
        outs = [version + "/matplotlib/__init__.py"],
        cmd = " && ".join([
            "cp $(location usr/lib/python" + version + "/dist-packages/matplotlib/__init__.py) $@",
            "readonly PATCH=\"$$(readlink -f $(location @patch))\"",
            "readonly FILE=\"$$(readlink -f $(location @//debian:matplotlib_patches))\"",
            "(cd $(@D) && \"$${PATCH}\" -p1 < \"$${FILE}\") > /dev/null",
        ]),
        tools = [
            "@patch",
        ],
    )

    _src_files = native.glob(
        include = ["usr/lib/python" + version + "/dist-packages/**/*.py"],
        exclude = [
            "usr/lib/python" + version + "/dist-packages/matplotlib/__init__.py",
        ],
    )

    _data_files = native.glob([
        "usr/share/matplotlib/mpl-data/**",
        "usr/share/tcltk/**",
    ])

    _src_copied = ["/".join([version] + f.split("/")[4:]) for f in _src_files]

    _builtin_so_files = native.glob([
        "usr/lib/python" + version + "/dist-packages/**/*x86_64-linux-gnu.so",
        "usr/lib/python" + tkinter_py_version + "/lib-dynload/*.so",
    ])

    _system_so_files = native.glob([
        "usr/lib/**/*.so*",
        "lib/x86_64-linux-gnu/**/*.so*",
    ])

    _builtin_so_copied = ["/".join([version] + f.split("/")[4:]) for f in _builtin_so_files]

    rpath_prefix = "rpathed" + version + "/"

    _system_so_copied = [rpath_prefix + f for f in _system_so_files]

    _builtin_rpaths = [":".join([
        "\\$$ORIGIN/%s" % rel,
        "\\$$ORIGIN/%s/%s/usr/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
        "\\$$ORIGIN/%s/%s/usr/lib" % (rel, rpath_prefix),
        "\\$$ORIGIN/%s/%s/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
    ]) for rel in ["/".join([".." for _ in so.split("/")[1:]]) for so in _builtin_so_copied]]

    _system_rpaths = [":".join([
        "\\$$ORIGIN/%s/%s/usr/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
        "\\$$ORIGIN/%s/%s/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
    ]) for rel in ["/".join([".." for _ in so.split("/")[1:]]) for so in _system_so_copied]]

    native.genrule(
        name = "run_patchelf_builtin" + version,
        srcs = _builtin_so_files,
        outs = _builtin_so_copied,
        cmd = "\n".join(
            [
                "cp $(location %s) $(location %s)" % (src, dest)
                for src, dest in zip(_builtin_so_files, _builtin_so_copied)
            ] +
            ["$(location @patchelf) --set-rpath %s $(location %s)" % (rpath, so) for rpath, so in zip(_builtin_rpaths, _builtin_so_copied)],
        ),
        tools = [
            "@patchelf",
        ],
    )

    native.genrule(
        name = "run_patchelf_system" + version,
        srcs = _system_so_files,
        outs = _system_so_copied,
        cmd = "\n".join(
            [
                "cp $(location %s) $(location %s)" % (src, dest)
                for src, dest in zip(_system_so_files, _system_so_copied)
            ] +
            ["$(location @patchelf) --set-rpath %s $(location %s)" % (rpath, so) for rpath, so in zip(_system_rpaths, _system_so_copied)],
        ),
        tools = [
            "@patchelf",
        ],
    )

    native.genrule(
        name = "copy_files" + version,
        srcs = _src_files,
        outs = _src_copied,
        cmd = " && ".join(["cp $(location %s) $(location %s)" % (src, dest) for src, dest in zip(
            _src_files,
            _src_copied,
        )]),
    )

    if copy_shared_files:
        native.genrule(
            name = "create_rc" + version,
            outs = ["usr/share/matplotlib/mpl-data/matplotlibrc"],
            cmd = "\n".join([
                "cat > $@ << END",
                # This is necessary to make matplotlib actually plot things to the
                # screen by default.
                "backend      : TkAgg",
                "END",
            ]),
        )

    native.py_library(
        name = "matplotlib" + version,
        srcs = _src_copied + [
            version + "/matplotlib/__init__.py",
        ],
        data = _data_files + _builtin_so_copied + _system_so_copied + [
            ":usr/share/matplotlib/mpl-data/matplotlibrc",
        ] + native.glob(["etc/**"]),
        imports = ["usr/lib/python" + version + "/dist-packages", version, "."],
        restricted_to = ["@//tools:k8"],
        visibility = ["//visibility:public"],
    )
