files = {
    "blt_2.5.3+dfsg-4.1_amd64.deb": "1f4fe70b93976daf7cb728f3fb7561edbb0c78360f053a521ee9075f2ec5c809",
    "coreutils_8.32-4+b1_amd64.deb": "3558a412ab51eee4b60641327cb145bb91415f127769823b68f9335585b308d4",
    "fontconfig-config_2.13.1-4.2_all.deb": "48afb6ad7d15e6104a343b789f73697301ad8bff77b69927bc998f5a409d8e90",
    "fonts-croscore_20201225-1_all.deb": "64904820b729ff40038f85683004e3b94b328d969bc0fbba263c58d635452923",
    "fonts-dejavu-core_2.37-2_all.deb": "1f67421437b6eb18669d2868e3e02cb88668683d635198142f48aacc5b397118",
    "fonts-freefont-otf_20120503-10_all.deb": "0b63996c80c6c660424af6d3832818e647960d6f65a51de010bb57dd0762faa7",
    "fonts-freefont-ttf_20120503-10_all.deb": "4ca1c21ebc479198a3a5879d236c8317d6f7b2f1c403f7890e24c02eead05615",
    "fonts-liberation2_2.1.3-1_all.deb": "e0805f0085132f5e6dd30f88c0d7260caf1e5450832fe2e3988a20fa9fa2150e",
    "fonts-liberation_1.07.4-11_all.deb": "efd381517f958b01969343634ffcbdd60056be7779af84c6f53a005090430204",
    "fonts-lyx_2.3.6-1_all.deb": "c6a1e4105d3c4edc246e4740560c9eda0e5fffec72dd03de256cf10f669fbec8",
    "fonts-texgyre_20180621-3.1_all.deb": "cb7e9a4b2471cfdd57194c16364f9102f0639816a2662fed4b30d2a158747076",
    "fonts-urw-base35_20200910-1_all.deb": "f95a139adb7f1b60626e76d4d45d1b35aad1bc2c2597394c291ef5f84b5dcb43",
    "libattr1_2.4.48-6_amd64.deb": "af3c3562eb2802481a2b9558df1b389f3c6d9b1bf3b4219e000e05131372ebaf",
    "libbrotli1_1.0.9-2+b2_amd64.deb": "65ca7d8b03e9dac09c5d544a89dd52d1aeb74f6a19583d32e4ff5f0c77624c24",
    "libbsd0_0.11.3-1_amd64.deb": "284a7b8dcfcad74770f57360721365317448b38ab773db542bf630e94e60c13e",
    "libdeflate0_1.7-1_amd64.deb": "dadaf0d28360f6eb21ad389b2e0f12f8709c9de539b28de9c11d7ec7043dec95",
    "libfontconfig1_2.13.1-4.2_amd64.deb": "b92861827627a76e74d6f447a5577d039ef2f95da18af1f29aa98fb96baea4c1",
    "libfreetype6_2.10.4+dfsg-1_amd64.deb": "e95396fc3cc806b2b95d9a00b4226eb464bc3ef4817c798749a0dd582546e5bc",
    "libimagequant0_2.12.2-1.1_amd64.deb": "cca1a4d3c24358c75964c720445a1ba50467aa52af7fb82a387f460a4a065096",
    "libjbig0_2.1-3.1+b2_amd64.deb": "9646d69eefce505407bf0437ea12fb7c2d47a3fd4434720ba46b642b6dcfd80f",
    "libjpeg62-turbo_2.0.6-4_amd64.deb": "28de780a1605cf501c3a4ebf3e588f5110e814b208548748ab064100c32202ea",
    "libjs-jquery-ui_1.12.1+dfsg-8+deb11u1_all.deb": "9a2cea1140b526daa97e51f91bea63cb05679c4206d70e926915836d4f72be58",
    "liblcms2-2_2.12~rc1-2_amd64.deb": "0608ecb6ed258814e390b52b3fb50f2a6d3239b5ecb1086292ae08be00a67b0f",
    "libmd0_1.0.3-3_amd64.deb": "9e425b3c128b69126d95e61998e1b5ef74e862dd1fc953d91eebcc315aea62ea",
    "libpng16-16_1.6.37-3_amd64.deb": "7d5336af395d1f658d0e66d74d0e1f4c632028750e7e04314d1a650e0317f3d6",
    "libtcl8.6_8.6.11+dfsg-1_amd64.deb": "785df3d81010a67ded4a2c216c7b99657c6ab3d1ba7369119894abc851e5bb0c",
    "libtiff5_4.2.0-1_amd64.deb": "ec12fc6a05a30f8f98878dbb6d9b356d170d5f6239fb68ba6a1dc9eb89ba3194",
    "libtk8.6_8.6.11-2_amd64.deb": "20d70721a5d539266a8736800378398d088419b986b5313ca811203284690f12",
    "libwebp6_0.6.1-2.1_amd64.deb": "52bfd0f8d3a1bbd2c25fcd72fab857d0f24aea35874af68e057dde869ae3902c",
    "libwebpdemux2_0.6.1-2.1_amd64.deb": "bba38f28d461b6b2e94fc51fff34e0d179c2dea3b0c31a77de788f2023be6614",
    "libwebpmux3_0.6.1-2.1_amd64.deb": "78486e53903cbf422dfe04a33e5481c56c82198a2bfa307f2066e616477395f5",
    "libx11-6_1.7.2-1_amd64.deb": "086bd667fc07369472a923da015d182bb0c15a72228a5c0e6ddbcbeaab70acd2",
    "libx11-data_1.7.2-1_all.deb": "049b7eabced516acfdf44a5e81c26d108b16e4987e5d7604ea53eaade74027fb",
    "libxau6_1.0.9-1_amd64.deb": "679db1c4579ec7c61079adeaae8528adeb2e4bf5465baa6c56233b995d714750",
    "libxcb1_1.14-3_amd64.deb": "d5e0f047ed766f45eb7473947b70f9e8fddbe45ef22ecfd92ab712c0671a93ac",
    "libxdmcp6_1.1.2-3_amd64.deb": "ecb8536f5fb34543b55bb9dc5f5b14c9dbb4150a7bddb3f2287b7cab6e9d25ef",
    "libxext6_1.3.3-1.1_amd64.deb": "dc1ff8a2b60c7dd3c8917ffb9aa65ee6cda52648d9150608683c47319d1c0c8c",
    "libxft2_2.3.2-2_amd64.deb": "cd71384b4d511cba69bcee29af326943c7ca12450765f44c40d246608c779aad",
    "libxrender1_0.9.10-1_amd64.deb": "3ea17d07b5aa89012130e2acd92f0fc0ea67314e2f5eab6e33930ef688f48294",
    "libxss1_1.2.3-1_amd64.deb": "85cce16368f08a878fa892fbc54520fc654d00769cde6d300b8b802734a993c0",
    "python-matplotlib-data_3.3.4-1_all.deb": "3ae74d712766f261e41502a712ec8b471f7514b7fc4ae03fb6df539a553b61ff",
    "python3-cycler_0.10.0-3_all.deb": "87022b0aaf76b345ed80a6737326592a6009035a0eb694f475030ad325e91262",
    "python3-dateutil_2.8.1-6_all.deb": "59d2e32149471adee915d6b721726612c873a83f262a041899573a1867e9e450",
    "python3-kiwisolver_1.3.1-1+b1_amd64.deb": "ace5f22edfc057f252a57da7c04145ae298dddc658e3e72dbe7bddd39e03838a",
    "python3-matplotlib_3.3.4-1_amd64.deb": "e411a5de1fb43c3076697b48ec7eb36d4c98e6359d6717b34adfdd40b49fb9d5",
    "python3-pil.imagetk_8.1.2+dfsg-0.3_amd64.deb": "b0e98d9c7ebdee941b0a24f40c7b29b4cb4c8759e04c478da1d0380ebf956c1e",
    "python3-pil_8.1.2+dfsg-0.3_amd64.deb": "a0e44fe855f0b4f7a175fe4dad7db27a18adc8a0119e930010bc95641c66237a",
    "python3-pyparsing_2.4.7-1_all.deb": "bec23dc18bb37357f34e77e3f9590224b2d0f3bb4d9bb099600fa2d547800aa3",
    "python3-six_1.16.0-2_all.deb": "acd4271ba56e42298b9fab0fcdad8f319970b50d1026f8469eed968a20f28761",
    "python3-tk_3.9.2-1_amd64.deb": "272db7708d60675b6aaea98aef64131e2bc9ec443ad677ef247d341632d9ef07",
    "sensible-utils_0.0.14_all.deb": "b9a447dc4ec8714196b037e20a2209e62cd669f5450222952f259bda4416b71f",
    "tk8.6-blt2.5_2.5.3+dfsg-4.1_amd64.deb": "f12f8dd7ed62386d4a798ee84df7fd976b9ba4d9a930ba5b5d4bf48bd16437ca",
    "ttf-bitstream-vera_1.10-8.1_all.deb": "ba622edf73744b2951bbd20bfc113a1a875a9b0c6fed1ac9e9c7f4b54dd8a048",
    "ucf_3.0043_all.deb": "ebef6bcd777b5c0cc2699926f2159db08433aed07c50cb321fd828b28c5e8d53",
}

def build_matplotlib(version, tkinter_py_version = None, copy_shared_files = True):
    """Creates a py_library rule for matplotlib for the given python version.

    See debian/matplotlib.BUILD for the usage.

    All the rules generated by this will be suffixed by version. Only one
    instance of this macro should set copy_shared_files, which generate the
    files that are shared between python versions.

    tkinter_py_version is used because for the Python3 instance, some files
    are in folders named python3 and some are in folders named python3.5...

    version numbers should both be strings.
    """
    if tkinter_py_version == None:
        tkinter_py_version = version

    native.genrule(
        name = "patch_init" + version,
        srcs = [
            "usr/lib/python" + version + "/dist-packages/matplotlib/__init__.py",
            "@//debian:matplotlib_patches",
        ],
        outs = [version + "/matplotlib/__init__.py"],
        cmd = " && ".join([
            "cp $(location usr/lib/python" + version + "/dist-packages/matplotlib/__init__.py) $@",
            "readonly PATCH=\"$$(readlink -f $(location @patch))\"",
            "readonly FILE=\"$$(readlink -f $(location @//debian:matplotlib_patches))\"",
            "(cd $(@D) && \"$${PATCH}\" -p1 < \"$${FILE}\") > /dev/null",
        ]),
        tools = [
            "@patch",
        ],
    )

    _src_files = native.glob(
        include = ["usr/lib/python" + version + "/dist-packages/**/*.py"],
        exclude = [
            "usr/lib/python" + version + "/dist-packages/matplotlib/__init__.py",
        ],
    )

    _data_files = native.glob([
        "usr/share/matplotlib/mpl-data/**",
        "usr/share/tcltk/**",
    ])

    _src_copied = ["/".join([version] + f.split("/")[4:]) for f in _src_files]

    _builtin_so_files = native.glob([
        "usr/lib/python" + version + "/dist-packages/**/*x86_64-linux-gnu.so",
        "usr/lib/python" + tkinter_py_version + "/lib-dynload/*.so",
    ])

    _system_so_files = native.glob([
        "usr/lib/**/*.so*",
        "lib/x86_64-linux-gnu/**/*.so*",
    ])

    _builtin_so_copied = ["/".join([version] + f.split("/")[4:]) for f in _builtin_so_files]

    rpath_prefix = "rpathed" + version + "/"

    _system_so_copied = [rpath_prefix + f for f in _system_so_files]

    _builtin_rpaths = [":".join([
        "\\$$ORIGIN/%s" % rel,
        "\\$$ORIGIN/%s/%s/usr/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
        "\\$$ORIGIN/%s/%s/usr/lib" % (rel, rpath_prefix),
        "\\$$ORIGIN/%s/%s/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
    ]) for rel in ["/".join([".." for _ in so.split("/")[1:]]) for so in _builtin_so_copied]]

    _system_rpaths = [":".join([
        "\\$$ORIGIN/%s/%s/usr/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
        "\\$$ORIGIN/%s/%s/lib/x86_64-linux-gnu" % (rel, rpath_prefix),
    ]) for rel in ["/".join([".." for _ in so.split("/")[1:]]) for so in _system_so_copied]]

    native.genrule(
        name = "run_patchelf_builtin" + version,
        srcs = _builtin_so_files,
        outs = _builtin_so_copied,
        cmd = "\n".join(
            [
                "cp $(location %s) $(location %s)" % (src, dest)
                for src, dest in zip(_builtin_so_files, _builtin_so_copied)
            ] +
            ["$(location @patchelf) --set-rpath %s $(location %s)" % (rpath, so) for rpath, so in zip(_builtin_rpaths, _builtin_so_copied)],
        ),
        tools = [
            "@patchelf",
        ],
    )

    native.genrule(
        name = "run_patchelf_system" + version,
        srcs = _system_so_files,
        outs = _system_so_copied,
        cmd = "\n".join(
            [
                "cp $(location %s) $(location %s)" % (src, dest)
                for src, dest in zip(_system_so_files, _system_so_copied)
            ] +
            ["$(location @patchelf) --set-rpath %s $(location %s)" % (rpath, so) for rpath, so in zip(_system_rpaths, _system_so_copied)],
        ),
        tools = [
            "@patchelf",
        ],
    )

    native.genrule(
        name = "copy_files" + version,
        srcs = _src_files,
        outs = _src_copied,
        cmd = " && ".join(["cp $(location %s) $(location %s)" % (src, dest) for src, dest in zip(
            _src_files,
            _src_copied,
        )]),
    )

    if copy_shared_files:
        native.genrule(
            name = "create_rc" + version,
            srcs = ["etc/matplotlibrc"],
            outs = ["usr/share/matplotlib/mpl-data/matplotlibrc"],
            cmd = "cat $< > $@",
        )

    native.py_library(
        name = "matplotlib" + version,
        srcs = _src_copied + [
            version + "/matplotlib/__init__.py",
        ] + native.glob(
            include = ["usr/lib/python" + tkinter_py_version + "/**/*.py"],
        ),
        data = _data_files + _builtin_so_copied + _system_so_copied + [
        ] + native.glob(["etc/**", "usr/share/fonts/**"]),
        imports = [
            "rpathed3/usr/lib/python" + version + "/dist-packages",
            "rpathed3/usr/lib/python" + version + ".9/lib-dynload",
            version,
            ".",
            "usr/lib/python" + tkinter_py_version,
        ],
        target_compatible_with = ["@platforms//cpu:x86_64"],
        visibility = ["//visibility:public"],
    )
