/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2019 Erik Moqvist
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**
 * This file was generated by cantools version
 */

#include <string.h>

#include "PHFrames.h"

static inline uint8_t pack_left_shift_u8(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value << shift) & mask);
}

static inline uint8_t pack_left_shift_u16(
    uint16_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value << shift) & mask);
}

static inline uint8_t pack_right_shift_u16(
    uint16_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value >> shift) & mask);
}

static inline uint16_t unpack_left_shift_u16(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint16_t)((uint16_t)(value & mask) << shift);
}

static inline uint8_t unpack_right_shift_u8(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint8_t)((uint8_t)(value & mask) >> shift);
}

static inline uint16_t unpack_right_shift_u16(
    uint8_t value,
    uint8_t shift,
    uint8_t mask)
{
    return (uint16_t)((uint16_t)(value & mask) >> shift);
}

int PH_set_all_pack(
    uint8_t *dst_p,
    const struct PH_set_all_t *src_p,
    size_t size)
{
    if (size < 4u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 4);

    dst_p[0] |= pack_left_shift_u8(src_p->channel_0, 0u, 0x03u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_1, 2u, 0x0cu);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_2, 4u, 0x30u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_3, 6u, 0xc0u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_4, 0u, 0x03u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_5, 2u, 0x0cu);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_6, 4u, 0x30u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_7, 6u, 0xc0u);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_8, 0u, 0x03u);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_9, 2u, 0x0cu);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_10, 4u, 0x30u);
    dst_p[2] |= pack_left_shift_u8(src_p->channel_11, 6u, 0xc0u);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_12, 0u, 0x03u);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_13, 2u, 0x0cu);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_14, 4u, 0x30u);
    dst_p[3] |= pack_left_shift_u8(src_p->channel_15, 6u, 0xc0u);

    return (4);
}

int PH_set_all_unpack(
    struct PH_set_all_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 4u) {
        return (-EINVAL);
    }

    dst_p->channel_0 = unpack_right_shift_u8(src_p[0], 0u, 0x03u);
    dst_p->channel_1 = unpack_right_shift_u8(src_p[0], 2u, 0x0cu);
    dst_p->channel_2 = unpack_right_shift_u8(src_p[0], 4u, 0x30u);
    dst_p->channel_3 = unpack_right_shift_u8(src_p[0], 6u, 0xc0u);
    dst_p->channel_4 = unpack_right_shift_u8(src_p[1], 0u, 0x03u);
    dst_p->channel_5 = unpack_right_shift_u8(src_p[1], 2u, 0x0cu);
    dst_p->channel_6 = unpack_right_shift_u8(src_p[1], 4u, 0x30u);
    dst_p->channel_7 = unpack_right_shift_u8(src_p[1], 6u, 0xc0u);
    dst_p->channel_8 = unpack_right_shift_u8(src_p[2], 0u, 0x03u);
    dst_p->channel_9 = unpack_right_shift_u8(src_p[2], 2u, 0x0cu);
    dst_p->channel_10 = unpack_right_shift_u8(src_p[2], 4u, 0x30u);
    dst_p->channel_11 = unpack_right_shift_u8(src_p[2], 6u, 0xc0u);
    dst_p->channel_12 = unpack_right_shift_u8(src_p[3], 0u, 0x03u);
    dst_p->channel_13 = unpack_right_shift_u8(src_p[3], 2u, 0x0cu);
    dst_p->channel_14 = unpack_right_shift_u8(src_p[3], 4u, 0x30u);
    dst_p->channel_15 = unpack_right_shift_u8(src_p[3], 6u, 0xc0u);

    return (0);
}

uint8_t PH_set_all_channel_0_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_0_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_0_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_1_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_1_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_1_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_2_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_2_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_2_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_3_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_3_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_3_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_4_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_4_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_4_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_5_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_5_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_5_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_6_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_6_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_6_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_7_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_7_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_7_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_8_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_8_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_8_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_9_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_9_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_9_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_10_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_10_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_10_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_11_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_11_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_11_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_12_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_12_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_12_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_13_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_13_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_13_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_14_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_14_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_14_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

uint8_t PH_set_all_channel_15_encode(double value)
{
    return (uint8_t)(value);
}

double PH_set_all_channel_15_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_set_all_channel_15_is_in_range(uint8_t value)
{
    return (value <= 3u);
}

int PH_pulse_once_pack(
    uint8_t *dst_p,
    const struct PH_pulse_once_t *src_p,
    size_t size)
{
    if (size < 4u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 4);

    dst_p[0] |= pack_left_shift_u8(src_p->channel_0, 0u, 0x01u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_1, 1u, 0x02u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_2, 2u, 0x04u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_3, 3u, 0x08u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_4, 4u, 0x10u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_5, 5u, 0x20u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_6, 6u, 0x40u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_7, 7u, 0x80u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_8, 0u, 0x01u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_9, 1u, 0x02u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_10, 2u, 0x04u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_11, 3u, 0x08u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_12, 4u, 0x10u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_13, 5u, 0x20u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_14, 6u, 0x40u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_15, 7u, 0x80u);
    dst_p[2] |= pack_left_shift_u16(src_p->pulse_length_ms, 0u, 0xffu);
    dst_p[3] |= pack_right_shift_u16(src_p->pulse_length_ms, 8u, 0xffu);

    return (4);
}

int PH_pulse_once_unpack(
    struct PH_pulse_once_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 4u) {
        return (-EINVAL);
    }

    dst_p->channel_0 = unpack_right_shift_u8(src_p[0], 0u, 0x01u);
    dst_p->channel_1 = unpack_right_shift_u8(src_p[0], 1u, 0x02u);
    dst_p->channel_2 = unpack_right_shift_u8(src_p[0], 2u, 0x04u);
    dst_p->channel_3 = unpack_right_shift_u8(src_p[0], 3u, 0x08u);
    dst_p->channel_4 = unpack_right_shift_u8(src_p[0], 4u, 0x10u);
    dst_p->channel_5 = unpack_right_shift_u8(src_p[0], 5u, 0x20u);
    dst_p->channel_6 = unpack_right_shift_u8(src_p[0], 6u, 0x40u);
    dst_p->channel_7 = unpack_right_shift_u8(src_p[0], 7u, 0x80u);
    dst_p->channel_8 = unpack_right_shift_u8(src_p[1], 0u, 0x01u);
    dst_p->channel_9 = unpack_right_shift_u8(src_p[1], 1u, 0x02u);
    dst_p->channel_10 = unpack_right_shift_u8(src_p[1], 2u, 0x04u);
    dst_p->channel_11 = unpack_right_shift_u8(src_p[1], 3u, 0x08u);
    dst_p->channel_12 = unpack_right_shift_u8(src_p[1], 4u, 0x10u);
    dst_p->channel_13 = unpack_right_shift_u8(src_p[1], 5u, 0x20u);
    dst_p->channel_14 = unpack_right_shift_u8(src_p[1], 6u, 0x40u);
    dst_p->channel_15 = unpack_right_shift_u8(src_p[1], 7u, 0x80u);
    dst_p->pulse_length_ms = unpack_right_shift_u16(src_p[2], 0u, 0xffu);
    dst_p->pulse_length_ms |= unpack_left_shift_u16(src_p[3], 8u, 0xffu);

    return (0);
}

uint8_t PH_pulse_once_channel_0_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_0_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_0_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_1_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_1_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_1_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_2_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_2_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_2_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_3_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_3_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_3_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_4_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_4_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_4_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_5_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_5_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_5_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_6_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_6_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_6_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_7_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_7_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_7_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_8_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_8_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_8_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_9_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_9_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_9_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_10_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_10_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_10_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_11_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_11_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_11_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_12_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_12_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_12_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_13_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_13_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_13_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_14_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_14_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_14_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_pulse_once_channel_15_encode(double value)
{
    return (uint8_t)(value);
}

double PH_pulse_once_channel_15_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_pulse_once_channel_15_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint16_t PH_pulse_once_pulse_length_ms_encode(double value)
{
    return (uint16_t)(value);
}

double PH_pulse_once_pulse_length_ms_decode(uint16_t value)
{
    return ((double)value);
}

bool PH_pulse_once_pulse_length_ms_is_in_range(uint16_t value)
{
    (void)value;

    return (true);
}

int PH_status0_pack(
    uint8_t *dst_p,
    const struct PH_status0_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u8(src_p->channel_0, 0u, 0x01u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_1, 1u, 0x02u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_2, 2u, 0x04u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_3, 3u, 0x08u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_4, 4u, 0x10u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_5, 5u, 0x20u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_6, 6u, 0x40u);
    dst_p[0] |= pack_left_shift_u8(src_p->channel_7, 7u, 0x80u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_8, 0u, 0x01u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_9, 1u, 0x02u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_10, 2u, 0x04u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_11, 3u, 0x08u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_12, 4u, 0x10u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_13, 5u, 0x20u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_14, 6u, 0x40u);
    dst_p[1] |= pack_left_shift_u8(src_p->channel_15, 7u, 0x80u);
    dst_p[2] |= pack_left_shift_u8(src_p->analog_0, 0u, 0xffu);
    dst_p[3] |= pack_left_shift_u8(src_p->analog_1, 0u, 0xffu);
    dst_p[4] |= pack_left_shift_u8(src_p->digital_sensor, 0u, 0x01u);
    dst_p[4] |= pack_left_shift_u8(src_p->brownout, 1u, 0x02u);
    dst_p[4] |= pack_left_shift_u8(src_p->compressor_oc, 2u, 0x04u);
    dst_p[4] |= pack_left_shift_u8(src_p->compressor_open, 3u, 0x08u);
    dst_p[4] |= pack_left_shift_u8(src_p->solenoid_oc, 4u, 0x10u);
    dst_p[4] |= pack_left_shift_u8(src_p->can_warning, 5u, 0x20u);
    dst_p[4] |= pack_left_shift_u8(src_p->hardware_fault, 6u, 0x40u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_0_fault, 0u, 0x01u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_1_fault, 1u, 0x02u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_2_fault, 2u, 0x04u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_3_fault, 3u, 0x08u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_4_fault, 4u, 0x10u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_5_fault, 5u, 0x20u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_6_fault, 6u, 0x40u);
    dst_p[5] |= pack_left_shift_u8(src_p->channel_7_fault, 7u, 0x80u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_8_fault, 0u, 0x01u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_9_fault, 1u, 0x02u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_10_fault, 2u, 0x04u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_11_fault, 3u, 0x08u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_12_fault, 4u, 0x10u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_13_fault, 5u, 0x20u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_14_fault, 6u, 0x40u);
    dst_p[6] |= pack_left_shift_u8(src_p->channel_15_fault, 7u, 0x80u);
    dst_p[7] |= pack_left_shift_u8(src_p->compressor_on, 0u, 0x01u);
    dst_p[7] |= pack_left_shift_u8(src_p->system_enabled, 1u, 0x02u);

    return (8);
}

int PH_status0_unpack(
    struct PH_status0_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->channel_0 = unpack_right_shift_u8(src_p[0], 0u, 0x01u);
    dst_p->channel_1 = unpack_right_shift_u8(src_p[0], 1u, 0x02u);
    dst_p->channel_2 = unpack_right_shift_u8(src_p[0], 2u, 0x04u);
    dst_p->channel_3 = unpack_right_shift_u8(src_p[0], 3u, 0x08u);
    dst_p->channel_4 = unpack_right_shift_u8(src_p[0], 4u, 0x10u);
    dst_p->channel_5 = unpack_right_shift_u8(src_p[0], 5u, 0x20u);
    dst_p->channel_6 = unpack_right_shift_u8(src_p[0], 6u, 0x40u);
    dst_p->channel_7 = unpack_right_shift_u8(src_p[0], 7u, 0x80u);
    dst_p->channel_8 = unpack_right_shift_u8(src_p[1], 0u, 0x01u);
    dst_p->channel_9 = unpack_right_shift_u8(src_p[1], 1u, 0x02u);
    dst_p->channel_10 = unpack_right_shift_u8(src_p[1], 2u, 0x04u);
    dst_p->channel_11 = unpack_right_shift_u8(src_p[1], 3u, 0x08u);
    dst_p->channel_12 = unpack_right_shift_u8(src_p[1], 4u, 0x10u);
    dst_p->channel_13 = unpack_right_shift_u8(src_p[1], 5u, 0x20u);
    dst_p->channel_14 = unpack_right_shift_u8(src_p[1], 6u, 0x40u);
    dst_p->channel_15 = unpack_right_shift_u8(src_p[1], 7u, 0x80u);
    dst_p->analog_0 = unpack_right_shift_u8(src_p[2], 0u, 0xffu);
    dst_p->analog_1 = unpack_right_shift_u8(src_p[3], 0u, 0xffu);
    dst_p->digital_sensor = unpack_right_shift_u8(src_p[4], 0u, 0x01u);
    dst_p->brownout = unpack_right_shift_u8(src_p[4], 1u, 0x02u);
    dst_p->compressor_oc = unpack_right_shift_u8(src_p[4], 2u, 0x04u);
    dst_p->compressor_open = unpack_right_shift_u8(src_p[4], 3u, 0x08u);
    dst_p->solenoid_oc = unpack_right_shift_u8(src_p[4], 4u, 0x10u);
    dst_p->can_warning = unpack_right_shift_u8(src_p[4], 5u, 0x20u);
    dst_p->hardware_fault = unpack_right_shift_u8(src_p[4], 6u, 0x40u);
    dst_p->channel_0_fault = unpack_right_shift_u8(src_p[5], 0u, 0x01u);
    dst_p->channel_1_fault = unpack_right_shift_u8(src_p[5], 1u, 0x02u);
    dst_p->channel_2_fault = unpack_right_shift_u8(src_p[5], 2u, 0x04u);
    dst_p->channel_3_fault = unpack_right_shift_u8(src_p[5], 3u, 0x08u);
    dst_p->channel_4_fault = unpack_right_shift_u8(src_p[5], 4u, 0x10u);
    dst_p->channel_5_fault = unpack_right_shift_u8(src_p[5], 5u, 0x20u);
    dst_p->channel_6_fault = unpack_right_shift_u8(src_p[5], 6u, 0x40u);
    dst_p->channel_7_fault = unpack_right_shift_u8(src_p[5], 7u, 0x80u);
    dst_p->channel_8_fault = unpack_right_shift_u8(src_p[6], 0u, 0x01u);
    dst_p->channel_9_fault = unpack_right_shift_u8(src_p[6], 1u, 0x02u);
    dst_p->channel_10_fault = unpack_right_shift_u8(src_p[6], 2u, 0x04u);
    dst_p->channel_11_fault = unpack_right_shift_u8(src_p[6], 3u, 0x08u);
    dst_p->channel_12_fault = unpack_right_shift_u8(src_p[6], 4u, 0x10u);
    dst_p->channel_13_fault = unpack_right_shift_u8(src_p[6], 5u, 0x20u);
    dst_p->channel_14_fault = unpack_right_shift_u8(src_p[6], 6u, 0x40u);
    dst_p->channel_15_fault = unpack_right_shift_u8(src_p[6], 7u, 0x80u);
    dst_p->compressor_on = unpack_right_shift_u8(src_p[7], 0u, 0x01u);
    dst_p->system_enabled = unpack_right_shift_u8(src_p[7], 1u, 0x02u);

    return (0);
}

uint8_t PH_status0_channel_0_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_0_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_0_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_1_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_1_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_1_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_2_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_2_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_2_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_3_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_3_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_3_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_4_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_4_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_4_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_5_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_5_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_5_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_6_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_6_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_6_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_7_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_7_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_7_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_8_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_8_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_8_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_9_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_9_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_9_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_10_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_10_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_10_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_11_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_11_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_11_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_12_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_12_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_12_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_13_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_13_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_13_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_14_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_14_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_14_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_15_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_15_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_15_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_analog_0_encode(double value)
{
    return (uint8_t)(value / 0.01961);
}

double PH_status0_analog_0_decode(uint8_t value)
{
    return ((double)value * 0.01961);
}

bool PH_status0_analog_0_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PH_status0_analog_1_encode(double value)
{
    return (uint8_t)(value / 0.01961);
}

double PH_status0_analog_1_decode(uint8_t value)
{
    return ((double)value * 0.01961);
}

bool PH_status0_analog_1_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PH_status0_digital_sensor_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_digital_sensor_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_digital_sensor_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_compressor_oc_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_compressor_oc_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_compressor_oc_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_compressor_open_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_compressor_open_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_compressor_open_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_solenoid_oc_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_solenoid_oc_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_solenoid_oc_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_can_warning_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_can_warning_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_can_warning_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_hardware_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_hardware_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_hardware_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_0_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_0_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_0_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_1_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_1_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_1_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_2_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_2_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_2_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_3_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_3_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_3_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_4_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_4_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_4_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_5_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_5_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_5_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_6_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_6_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_6_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_7_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_7_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_7_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_8_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_8_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_8_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_9_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_9_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_9_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_10_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_10_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_10_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_11_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_11_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_11_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_12_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_12_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_12_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_13_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_13_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_13_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_14_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_14_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_14_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_channel_15_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_channel_15_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_channel_15_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_compressor_on_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_compressor_on_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_compressor_on_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status0_system_enabled_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status0_system_enabled_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status0_system_enabled_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

int PH_status1_pack(
    uint8_t *dst_p,
    const struct PH_status1_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    memset(&dst_p[0], 0, 8);

    dst_p[0] |= pack_left_shift_u8(src_p->v_bus, 0u, 0xffu);
    dst_p[1] |= pack_left_shift_u16(src_p->solenoid_voltage, 0u, 0xffu);
    dst_p[2] |= pack_right_shift_u16(src_p->solenoid_voltage, 8u, 0x0fu);
    dst_p[4] |= pack_left_shift_u8(src_p->compressor_current, 0u, 0xffu);
    dst_p[5] |= pack_left_shift_u8(src_p->solenoid_current, 0u, 0xffu);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_brownout, 0u, 0x01u);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_compressor_over_current, 1u, 0x02u);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_compressor_not_present, 2u, 0x04u);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_solenoid_over_current, 3u, 0x08u);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_can_warning, 4u, 0x10u);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_can_bus_off, 5u, 0x20u);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_hardware_fault, 6u, 0x40u);
    dst_p[6] |= pack_left_shift_u8(src_p->sticky_firmware_fault, 7u, 0x80u);
    dst_p[7] |= pack_left_shift_u8(src_p->sticky_has_reset, 0u, 0x01u);

    return (8);
}

int PH_status1_unpack(
    struct PH_status1_t *dst_p,
    const uint8_t *src_p,
    size_t size)
{
    if (size < 8u) {
        return (-EINVAL);
    }

    dst_p->v_bus = unpack_right_shift_u8(src_p[0], 0u, 0xffu);
    dst_p->solenoid_voltage = unpack_right_shift_u16(src_p[1], 0u, 0xffu);
    dst_p->solenoid_voltage |= unpack_left_shift_u16(src_p[2], 8u, 0x0fu);
    dst_p->compressor_current = unpack_right_shift_u8(src_p[4], 0u, 0xffu);
    dst_p->solenoid_current = unpack_right_shift_u8(src_p[5], 0u, 0xffu);
    dst_p->sticky_brownout = unpack_right_shift_u8(src_p[6], 0u, 0x01u);
    dst_p->sticky_compressor_over_current = unpack_right_shift_u8(src_p[6], 1u, 0x02u);
    dst_p->sticky_compressor_not_present = unpack_right_shift_u8(src_p[6], 2u, 0x04u);
    dst_p->sticky_solenoid_over_current = unpack_right_shift_u8(src_p[6], 3u, 0x08u);
    dst_p->sticky_can_warning = unpack_right_shift_u8(src_p[6], 4u, 0x10u);
    dst_p->sticky_can_bus_off = unpack_right_shift_u8(src_p[6], 5u, 0x20u);
    dst_p->sticky_hardware_fault = unpack_right_shift_u8(src_p[6], 6u, 0x40u);
    dst_p->sticky_firmware_fault = unpack_right_shift_u8(src_p[6], 7u, 0x80u);
    dst_p->sticky_has_reset = unpack_right_shift_u8(src_p[7], 0u, 0x01u);

    return (0);
}

uint8_t PH_status1_v_bus_encode(double value)
{
    return (uint8_t)((value - 4.0) / 0.0625);
}

double PH_status1_v_bus_decode(uint8_t value)
{
    return (((double)value * 0.0625) + 4.0);
}

bool PH_status1_v_bus_is_in_range(uint8_t value)
{
    return (value <= 192u);
}

uint16_t PH_status1_solenoid_voltage_encode(double value)
{
    return (uint16_t)(value / 0.0078125);
}

double PH_status1_solenoid_voltage_decode(uint16_t value)
{
    return ((double)value * 0.0078125);
}

bool PH_status1_solenoid_voltage_is_in_range(uint16_t value)
{
    return (value <= 4096u);
}

uint8_t PH_status1_compressor_current_encode(double value)
{
    return (uint8_t)(value / 0.125);
}

double PH_status1_compressor_current_decode(uint8_t value)
{
    return ((double)value * 0.125);
}

bool PH_status1_compressor_current_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PH_status1_solenoid_current_encode(double value)
{
    return (uint8_t)(value / 0.125);
}

double PH_status1_solenoid_current_decode(uint8_t value)
{
    return ((double)value * 0.125);
}

bool PH_status1_solenoid_current_is_in_range(uint8_t value)
{
    (void)value;

    return (true);
}

uint8_t PH_status1_sticky_brownout_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_brownout_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_brownout_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_compressor_over_current_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_compressor_over_current_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_compressor_over_current_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_compressor_not_present_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_compressor_not_present_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_compressor_not_present_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_solenoid_over_current_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_solenoid_over_current_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_solenoid_over_current_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_can_warning_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_can_warning_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_can_warning_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_can_bus_off_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_can_bus_off_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_can_bus_off_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_hardware_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_hardware_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_hardware_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_firmware_fault_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_firmware_fault_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_firmware_fault_is_in_range(uint8_t value)
{
    return (value <= 1u);
}

uint8_t PH_status1_sticky_has_reset_encode(double value)
{
    return (uint8_t)(value);
}

double PH_status1_sticky_has_reset_decode(uint8_t value)
{
    return ((double)value);
}

bool PH_status1_sticky_has_reset_is_in_range(uint8_t value)
{
    return (value <= 1u);
}
