/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.IntBuffer;
import java.util.Arrays;

public class IntPointer
extends Pointer {
    public IntPointer(String s) {
        this(s.length() + 1);
        this.putString(s);
    }

    public IntPointer(int ... array) {
        this(array.length);
        this.asBuffer(array.length).put(array);
    }

    public IntPointer(int size) {
        this.allocateArray(size);
    }

    public IntPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public IntPointer position(int position) {
        return (IntPointer)super.position(position);
    }

    public int[] getStringCodePoints() {
        int[] buffer = new int[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != 0) {
            ++j;
            if (++i < buffer.length) continue;
            buffer = Arrays.copyOf(buffer, 2 * buffer.length);
        }
        return Arrays.copyOf(buffer, i);
    }

    public String getString() {
        int[] codePoints = this.getStringCodePoints();
        return new String(codePoints, 0, codePoints.length);
    }

    public IntPointer putString(String s) {
        int[] codePoints = new int[s.length()];
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = s.codePointAt(i);
        }
        this.asBuffer(codePoints.length + 1).put(codePoints).put(0);
        return this;
    }

    public native int get();

    public native IntPointer put(int var1);

    public final IntBuffer asBuffer(int capacity) {
        return this.asByteBuffer(capacity).asIntBuffer();
    }
}

