/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.CharBuffer;
import java.util.Arrays;

public class CharPointer
extends Pointer {
    public CharPointer(String s) {
        this(s.toCharArray().length + 1);
        this.putString(s);
    }

    public CharPointer(char ... array) {
        this(array.length);
        this.asBuffer(array.length).put(array);
    }

    public CharPointer(int size) {
        this.allocateArray(size);
    }

    public CharPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public CharPointer position(int position) {
        return (CharPointer)super.position(position);
    }

    public char[] getStringChars() {
        char[] buffer = new char[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != '\u0000') {
            ++j;
            if (++i < buffer.length) continue;
            buffer = Arrays.copyOf(buffer, 2 * buffer.length);
        }
        return Arrays.copyOf(buffer, i);
    }

    public String getString() {
        return new String(this.getStringChars());
    }

    public CharPointer putString(String s) {
        char[] chars = s.toCharArray();
        this.asBuffer(chars.length + 1).put(chars).put('\u0000');
        return this;
    }

    public native char get();

    public native CharPointer put(char var1);

    public final CharBuffer asBuffer(int capacity) {
        return this.asByteBuffer(capacity).asCharBuffer();
    }
}

