/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BytePointer
extends Pointer {
    public BytePointer(String s, String charsetName) throws UnsupportedEncodingException {
        this(s.getBytes(charsetName).length + 1);
        this.putString(s, charsetName);
    }

    public BytePointer(String s) {
        this(s.getBytes().length + 1);
        this.putString(s);
    }

    public BytePointer(byte ... array) {
        this(array.length);
        this.asBuffer(array.length).put(array);
    }

    public BytePointer(int size) {
        this.allocateArray(size);
    }

    public BytePointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public BytePointer position(int position) {
        return (BytePointer)super.position(position);
    }

    public byte[] getStringBytes() {
        byte[] buffer = new byte[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != 0) {
            ++j;
            if (++i < buffer.length) continue;
            buffer = Arrays.copyOf(buffer, 2 * buffer.length);
        }
        return Arrays.copyOf(buffer, i);
    }

    public String getString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.getStringBytes(), charsetName);
    }

    public String getString() {
        return new String(this.getStringBytes());
    }

    public BytePointer putString(String s, String charsetName) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(charsetName);
        this.asBuffer(bytes.length + 1).put(bytes).put((byte)0);
        return this;
    }

    public BytePointer putString(String s) {
        byte[] bytes = s.getBytes();
        this.asBuffer(bytes.length + 1).put(bytes).put((byte)0);
        return this;
    }

    public native byte get();

    public native BytePointer put(byte var1);

    public final ByteBuffer asBuffer(int capacity) {
        return (ByteBuffer)super.asBuffer(capacity);
    }
}

