/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Parallel {
    public static final int numCores = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();

    public static void run(Runnable ... runnables) {
        if (runnables.length == 1) {
            runnables[0].run();
            return;
        }
        Future[] futures = new Future[runnables.length];
        for (int i = 0; i < runnables.length; ++i) {
            futures[i] = threadPool.submit(runnables[i]);
        }
        Throwable error = null;
        try {
            for (Future f : futures) {
                if (f.isDone()) continue;
                f.get();
            }
        }
        catch (Throwable t) {
            error = t;
        }
        if (error != null) {
            for (Future f : futures) {
                f.cancel(true);
            }
            throw new RuntimeException(error);
        }
    }

    public static void loop(int from, int to, Looper looper) {
        Parallel.loop(from, to, numCores, looper);
    }

    public static void loop(int from, int to, int numThreads, final Looper looper) {
        int numLoopers = Math.min(to - from, numThreads);
        Runnable[] runnables = new Runnable[numLoopers];
        for (int i = 0; i < numLoopers; ++i) {
            final int subFrom = (to - from) * i / numLoopers + from;
            final int subTo = (to - from) * (i + 1) / numLoopers + from;
            final int looperID = i;
            runnables[i] = new Runnable(){

                public void run() {
                    looper.loop(subFrom, subTo, looperID);
                }
            };
        }
        Parallel.run(runnables);
    }

    public static interface Looper {
        public void loop(int var1, int var2, int var3);
    }
}

