/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.ImageAligner;
import com.googlecode.javacv.JavaCV;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class HandMouse {
    private Settings settings;
    private ImageAligner aligner;
    private opencv_core.IplImage thresholdedImage = null;
    private opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
    private opencv_core.CvPoint roiPoints = null;
    private opencv_core.CvPoint contourPoints = null;
    private int roiPointsSize = 0;
    private int contourPointsSize = 0;
    private IntBuffer contourPointsBuffer = null;
    private opencv_imgproc.CvMoments moments = new opencv_imgproc.CvMoments();
    private double tipX = -1.0;
    private double tipY = -1.0;
    private double prevTipX = this.tipX;
    private double prevTipY = this.tipY;
    private opencv_core.CvPoint pt1 = new opencv_core.CvPoint();
    private opencv_core.CvPoint pt2 = new opencv_core.CvPoint();

    public HandMouse(ImageAligner aligner) {
        this(aligner, new Settings());
    }

    public HandMouse(ImageAligner aligner, Settings settings) {
        this.aligner = aligner;
        this.setSettings(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void update() {
        this.update(null);
    }

    public void update(opencv_core.IplImage[] intermediate) {
        if (this.aligner.getPyramidLevel() != this.settings.pyramidLevel) {
            this.aligner.setPyramidLevel(this.settings.pyramidLevel);
        }
        opencv_core.IplImage roiMask = this.aligner.getRoiMaskImage();
        opencv_core.IplImage residual = this.aligner.getResidualImage();
        opencv_core.IplImage target = this.aligner.getTargetImage();
        opencv_core.IplImage transformed = this.aligner.getTransformedImage();
        int width = residual.width();
        int height = residual.height();
        int channels = residual.nChannels();
        this.thresholdedImage = opencv_core.IplImage.createIfNotCompatible(this.thresholdedImage, roiMask);
        opencv_core.cvResetImageROI(this.thresholdedImage);
        ByteBuffer roiMaskBuf = roiMask.getByteBuffer();
        FloatBuffer residualBuf = residual.getFloatBuffer();
        FloatBuffer targetBuf = target.getFloatBuffer();
        FloatBuffer transformedBuf = transformed.getFloatBuffer();
        ByteBuffer thresholdedBuf = this.thresholdedImage.getByteBuffer();
        while (roiMaskBuf.hasRemaining() && residualBuf.hasRemaining() && targetBuf.hasRemaining() && transformedBuf.hasRemaining() && thresholdedBuf.hasRemaining()) {
            byte m = roiMaskBuf.get();
            if (m == 0) {
                residualBuf.position(residualBuf.position() + channels);
                targetBuf.position(targetBuf.position() + channels);
                transformedBuf.position(transformedBuf.position() + channels);
                thresholdedBuf.put((byte)0);
                continue;
            }
            double relativeNorm = 0.0;
            double lightness = 0.0;
            for (int z = 0; z < channels; ++z) {
                float r = Math.abs(residualBuf.get());
                float c = targetBuf.get();
                float t = transformedBuf.get();
                lightness += (double)Math.max(c, t);
                relativeNorm = Math.max((double)(r / Math.max(c, t)), relativeNorm);
            }
            if (lightness < (double)channels * this.settings.lightnessMin) {
                thresholdedBuf.put((byte)0);
                continue;
            }
            thresholdedBuf.put((byte)Math.round(255.0 / this.settings.thresholdHigh * Math.min(relativeNorm, this.settings.thresholdHigh)));
        }
        if (intermediate != null && intermediate[0] != null) {
            opencv_core.cvCopy(this.thresholdedImage, intermediate[0]);
        }
        JavaCV.hysteresisThreshold(this.thresholdedImage, this.thresholdedImage, 255.0, 255.0 * this.settings.thresholdLow / this.settings.thresholdHigh, 255.0);
        if (intermediate != null && intermediate[1] != null) {
            opencv_core.cvResetImageROI(intermediate[1]);
            opencv_core.cvCopy(this.thresholdedImage, intermediate[1]);
        }
        opencv_core.CvRect roi = this.aligner.getRoi();
        int roiX = roi.x();
        int roiY = roi.y();
        opencv_core.cvSetImageROI(this.thresholdedImage, roi);
        opencv_imgproc.cvMorphologyEx(this.thresholdedImage, this.thresholdedImage, null, null, 2, this.settings.mopIterations);
        opencv_imgproc.cvMorphologyEx(this.thresholdedImage, this.thresholdedImage, null, null, 3, this.settings.mopIterations);
        opencv_imgproc.cvDilate(this.thresholdedImage, this.thresholdedImage, null, 1);
        double[] roiPts = this.aligner.getTransformedRoiPts();
        for (int i = 0; i < roiPts.length / 2; ++i) {
            int n = 2 * i;
            roiPts[n] = roiPts[n] - (double)roiX;
            int n2 = 2 * i + 1;
            roiPts[n2] = roiPts[n2] - (double)roiY;
        }
        if (this.roiPoints == null || this.roiPointsSize < roiPts.length / 2) {
            this.roiPoints = new opencv_core.CvPoint(roiPts.length / 2);
            this.roiPointsSize = roiPts.length / 2;
        }
        this.roiPoints.fill((byte)16, roiPts);
        opencv_core.CvSeq contour = new opencv_core.CvContour(null);
        opencv_imgproc.cvFindContours(this.thresholdedImage, this.storage, contour, Loader.sizeof(opencv_core.CvContour.class), 0, 2);
        double largestContourEdgeArea = 0.0;
        opencv_core.CvSeq largestContour = null;
        double edgeX = 0.0;
        double edgeY = 0.0;
        while (contour != null && !contour.isNull()) {
            double contourArea = Math.abs(opencv_imgproc.cvContourArea(contour, opencv_core.CV_WHOLE_SEQ, 0));
            if (contourArea < this.settings.areaMin * (double)width * (double)height || contourArea > this.settings.areaMax * (double)width * (double)height) {
                contour = contour.h_next();
                continue;
            }
            int total = contour.total();
            if (this.contourPoints == null || this.contourPointsSize < total) {
                this.contourPoints = new opencv_core.CvPoint(total);
                this.contourPointsSize = total;
                this.contourPointsBuffer = this.contourPoints.asByteBuffer(8 * total).asIntBuffer();
            }
            opencv_core.cvCvtSeqToArray(contour, this.contourPoints.position(0), opencv_core.CV_WHOLE_SEQ);
            opencv_core.cvSetZero(this.thresholdedImage);
            opencv_core.cvFillPoly((opencv_core.CvArr)this.thresholdedImage, this.contourPoints, new int[]{total}, 1, opencv_core.CvScalar.WHITE, 8, 0);
            opencv_core.cvFillPoly((opencv_core.CvArr)this.thresholdedImage, this.roiPoints, new int[]{this.roiPointsSize}, 1, opencv_core.CvScalar.BLACK, 8, 16);
            double contourEdgeArea = (double)opencv_core.cvCountNonZero(this.thresholdedImage) * contourArea;
            if (contourEdgeArea > largestContourEdgeArea) {
                largestContourEdgeArea = contourEdgeArea;
                largestContour = contour;
                opencv_imgproc.cvMoments(this.thresholdedImage, this.moments, 0);
                double inv_m00 = 1.0 / this.moments.m00();
                edgeX = this.moments.m10() * inv_m00;
                edgeY = this.moments.m01() * inv_m00;
            }
            contour = contour.h_next();
        }
        if (this.isClick()) {
            this.prevTipX = -1.0;
            this.prevTipY = -1.0;
        } else {
            this.prevTipX = this.tipX;
            this.prevTipY = this.tipY;
        }
        if (largestContour == null) {
            this.tipX = -1.0;
            this.tipY = -1.0;
        } else {
            opencv_imgproc.cvMoments(largestContour, this.moments, 0);
            double inv_m00 = 1.0 / this.moments.m00();
            double centerX = this.moments.m10() * inv_m00;
            double centerY = this.moments.m01() * inv_m00;
            int total = largestContour.total();
            opencv_core.cvCvtSeqToArray(largestContour, this.contourPoints.position(0), opencv_core.CV_WHOLE_SEQ);
            double tipDist2 = 0.0;
            for (int i = 0; i < total; ++i) {
                int x = this.contourPointsBuffer.get(2 * i);
                int y = this.contourPointsBuffer.get(2 * i + 1);
                double dx = centerX - edgeX;
                double dy = centerY - edgeY;
                double d2 = dx * dx + dy * dy;
                double u = (((double)x - edgeX) * (centerX - edgeX) + ((double)y - edgeY) * (centerY - edgeY)) / d2;
                double px = edgeX + u * (centerX - edgeX);
                dx = px - edgeX;
                double py = edgeY + u * (centerY - edgeY);
                dy = py - edgeY;
                if (!((d2 = dx * dx + dy * dy) > tipDist2)) continue;
                this.tipX = x;
                this.tipY = y;
                tipDist2 = d2;
            }
            if (intermediate != null && intermediate[1] != null) {
                opencv_core.cvSetImageROI(intermediate[1], roi);
                opencv_core.cvCopy(intermediate[1], this.thresholdedImage);
            } else {
                opencv_core.cvSetZero(this.thresholdedImage);
                opencv_core.cvFillPoly((opencv_core.CvArr)this.thresholdedImage, this.contourPoints, new int[]{total}, 1, opencv_core.CvScalar.WHITE, 8, 0);
            }
            this.pt1.fill((byte)16, edgeX, edgeY);
            opencv_core.cvCircle(this.thresholdedImage, this.pt1, 327680, opencv_core.CvScalar.GRAY, 2, 8, 16);
            this.pt1.fill((byte)16, centerX - 5.0, centerY - 5.0);
            this.pt2.fill((byte)16, centerX + 5.0, centerY + 5.0);
            opencv_core.cvRectangle(this.thresholdedImage, this.pt1, this.pt2, opencv_core.CvScalar.GRAY, 2, 8, 16);
            this.pt1.fill((byte)16, this.tipX - 5.0, this.tipY - 5.0);
            this.pt2.fill((byte)16, this.tipX + 5.0, this.tipY + 5.0);
            opencv_core.cvLine(this.thresholdedImage, this.pt1, this.pt2, opencv_core.CvScalar.GRAY, 2, 8, 16);
            this.pt1.fill((byte)16, this.tipX - 5.0, this.tipY + 5.0);
            this.pt2.fill((byte)16, this.tipX + 5.0, this.tipY - 5.0);
            opencv_core.cvLine(this.thresholdedImage, this.pt1, this.pt2, opencv_core.CvScalar.GRAY, 2, 8, 16);
            this.tipX = (this.tipX + (double)roiX) * (double)(1 << this.settings.pyramidLevel);
            this.tipY = (this.tipY + (double)roiY) * (double)(1 << this.settings.pyramidLevel);
            opencv_core.cvResetImageROI(this.thresholdedImage);
        }
        opencv_core.cvClearMemStorage(this.storage);
    }

    public opencv_core.IplImage getImage() {
        return this.thresholdedImage;
    }

    public double getX() {
        return this.tipX;
    }

    public double getY() {
        return this.tipY;
    }

    public boolean isClick() {
        if (this.tipX < 0.0 || this.tipY < 0.0 || this.prevTipX < 0.0 || this.prevTipY < 0.0) {
            return false;
        }
        double dx = this.tipX - this.prevTipX;
        double dy = this.tipY - this.prevTipY;
        int size = (this.thresholdedImage.width() + this.thresholdedImage.height()) / 2;
        double max = this.settings.clickSteadyMax * (double)size;
        return dx * dx + dy * dy < max * max;
    }

    public static class Settings
    extends BaseChildSettings {
        int mopIterations = 1;
        double clickSteadyMax = 0.005;
        double areaMin = 0.001;
        double areaMax = 0.1;
        int pyramidLevel = 2;
        double thresholdHigh = 0.5;
        double thresholdLow = 0.25;
        double lightnessMin = 0.1;

        public Settings() {
        }

        public Settings(Settings s) {
            s.mopIterations = this.mopIterations;
            s.clickSteadyMax = this.clickSteadyMax;
            s.areaMin = this.areaMin;
            s.areaMax = this.areaMax;
        }

        public int getMopIterations() {
            return this.mopIterations;
        }

        public void setMopIterations(int mopIterations) {
            this.mopIterations = mopIterations;
        }

        public double getClickSteadyMax() {
            return this.clickSteadyMax;
        }

        public void setClickSteadyMax(double clickSteadyMax) {
            this.clickSteadyMax = clickSteadyMax;
        }

        public double getAreaMin() {
            return this.areaMin;
        }

        public void setAreaMin(double areaMin) {
            this.areaMin = areaMin;
        }

        public double getAreaMax() {
            return this.areaMax;
        }

        public void setAreaMax(double areaMax) {
            this.areaMax = areaMax;
        }

        public int getPyramidLevel() {
            return this.pyramidLevel;
        }

        public void setPyramidLevel(int pyramidLevel) {
            this.pyramidLevel = pyramidLevel;
        }

        public double getThresholdHigh() {
            return this.thresholdHigh;
        }

        public void setThresholdHigh(double thresholdHigh) {
            this.thresholdHigh = thresholdHigh;
        }

        public double getThresholdLow() {
            return this.thresholdLow;
        }

        public void setThresholdLow(double thresholdLow) {
            this.thresholdLow = thresholdLow;
        }

        public double getLightnessMin() {
            return this.lightnessMin;
        }

        public void setLightnessMin(double lightnessMin) {
            this.lightnessMin = lightnessMin;
        }
    }
}

