/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.cpp.opencv_core;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_ProfileRGB;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferStrategy;
import javax.swing.JFrame;

public class CanvasFrame
extends JFrame {
    public static CanvasFrame global = null;
    public static final long DEFAULT_LATENCY = 120L;
    private long latency = 120L;
    private KeyEvent keyEvent = null;
    private Canvas canvas = null;
    private boolean needInitialResize = false;
    private BufferStrategy bufferStrategy = null;
    private double invgamma;

    public static String[] getScreenDescriptions() {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        String[] descriptions = new String[screens.length];
        for (int i = 0; i < screens.length; ++i) {
            descriptions[i] = screens[i].getIDstring();
        }
        return descriptions;
    }

    public static DisplayMode getDisplayMode(int screenNumber) {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        if (screenNumber >= 0 && screenNumber < screens.length) {
            return screens[screenNumber].getDisplayMode();
        }
        return null;
    }

    public static double getGamma(int screenNumber) {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        if (screenNumber >= 0 && screenNumber < screens.length) {
            return CanvasFrame.getGamma(screens[screenNumber]);
        }
        return 0.0;
    }

    public static double getGamma(GraphicsDevice screen) {
        ColorSpace cs = screen.getDefaultConfiguration().getColorModel().getColorSpace();
        if (cs.isCS_sRGB()) {
            return 2.2;
        }
        try {
            return ((ICC_ProfileRGB)((ICC_ColorSpace)cs).getProfile()).getGamma(0);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static GraphicsDevice getScreenDevice(int screenNumber) throws Exception {
        GraphicsDevice[] screens = CanvasFrame.getScreenDevices();
        if (screenNumber >= screens.length) {
            throw new Exception("CanvasFrame Error: Screen number " + screenNumber + " not found. " + "There are only " + screens.length + " screens.");
        }
        return screens[screenNumber];
    }

    public static GraphicsDevice[] getScreenDevices() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
    }

    public CanvasFrame(String title) {
        this(title, 0.0);
    }

    public CanvasFrame(String title, double gamma) {
        super(title);
        this.init(false, null, gamma);
    }

    public CanvasFrame(String title, GraphicsConfiguration gc) {
        this(title, gc, 0.0);
    }

    public CanvasFrame(String title, GraphicsConfiguration gc, double gamma) {
        super(title, gc);
        this.init(false, null, gamma);
    }

    public CanvasFrame(String title, int screenNumber, DisplayMode displayMode) throws Exception {
        this(title, screenNumber, displayMode, 0.0);
    }

    public CanvasFrame(String title, int screenNumber, DisplayMode displayMode, double gamma) throws Exception {
        super(title, CanvasFrame.getScreenDevice(screenNumber).getDefaultConfiguration());
        this.init(true, displayMode, gamma);
    }

    public void dispose() {
        this.bufferStrategy.dispose();
        super.dispose();
    }

    private void init(final boolean fullScreen, final DisplayMode displayMode, final double gamma) {
        Runnable r = new Runnable(){

            public void run() {
                GraphicsDevice gd = CanvasFrame.this.getGraphicsConfiguration().getDevice();
                DisplayMode d = gd.getDisplayMode();
                DisplayMode d2 = null;
                if (displayMode != null && d != null) {
                    int w = displayMode.getWidth();
                    int h = displayMode.getHeight();
                    int b = displayMode.getBitDepth();
                    int r = displayMode.getRefreshRate();
                    d2 = new DisplayMode(w > 0 ? w : d.getWidth(), h > 0 ? h : d.getHeight(), b > 0 ? b : d.getBitDepth(), r > 0 ? r : d.getRefreshRate());
                }
                if (fullScreen) {
                    CanvasFrame.this.setUndecorated(true);
                    CanvasFrame.this.getRootPane().setWindowDecorationStyle(0);
                    CanvasFrame.this.setResizable(false);
                    gd.setFullScreenWindow(CanvasFrame.this);
                }
                if (d2 != null && !d2.equals(d)) {
                    gd.setDisplayMode(d2);
                }
                double g = gamma == 0.0 ? CanvasFrame.getGamma(gd) : gamma;
                CanvasFrame.this.invgamma = g == 0.0 ? 1.0 : 1.0 / g;
                CanvasFrame.this.setVisible(true);
                CanvasFrame.this.canvas = new Canvas(){

                    public void paint(Graphics g) {
                        try {
                            CanvasFrame.this.bufferStrategy.show();
                        }
                        catch (NullPointerException e) {
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                };
                if (fullScreen) {
                    CanvasFrame.this.canvas.setSize(CanvasFrame.this.getSize());
                    CanvasFrame.this.needInitialResize = false;
                } else {
                    CanvasFrame.this.needInitialResize = true;
                }
                CanvasFrame.this.getContentPane().add(CanvasFrame.this.canvas);
                CanvasFrame.this.canvas.setVisible(true);
                CanvasFrame.this.canvas.createBufferStrategy(2);
                CanvasFrame.this.bufferStrategy = CanvasFrame.this.canvas.getBufferStrategy();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean dispatchKeyEvent(KeyEvent e) {
                        if (e.getID() == 401) {
                            CanvasFrame canvasFrame = CanvasFrame.this;
                            synchronized (canvasFrame) {
                                CanvasFrame.this.keyEvent = e;
                                CanvasFrame.this.notify();
                            }
                        }
                        return false;
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public DisplayMode getDisplayMode() {
        return this.getGraphicsConfiguration().getDevice().getDisplayMode();
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public void waitLatency() {
        try {
            Thread.sleep(this.getLatency());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public KeyEvent waitKey() {
        return this.waitKey(0);
    }

    public synchronized KeyEvent waitKey(int delay) {
        try {
            this.keyEvent = null;
            this.wait(delay);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        KeyEvent e = this.keyEvent;
        this.keyEvent = null;
        return e;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public Graphics2D createGraphics() {
        return (Graphics2D)this.bufferStrategy.getDrawGraphics();
    }

    public void releaseGraphics(Graphics2D g) {
        g.dispose();
        this.bufferStrategy.show();
    }

    public Dimension getCanvasSize() {
        return this.canvas.getSize();
    }

    public void setCanvasSize(int width, int height) {
        this.setExtendedState(0);
        this.canvas.setSize(width, height);
        this.pack();
        this.canvas.setSize(width + 1, height + 1);
        this.canvas.setSize(width, height);
        this.needInitialResize = false;
    }

    public void showImage(Image image, final int w, final int h) {
        if (image == null) {
            return;
        }
        if (this.isResizable() && this.needInitialResize) {
            if (EventQueue.isDispatchThread()) {
                this.setCanvasSize(w, h);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            CanvasFrame.this.setCanvasSize(w, h);
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        Graphics2D g = this.createGraphics();
        g.drawImage(image, 0, 0, this.canvas.getWidth(), this.canvas.getHeight(), null);
        this.releaseGraphics(g);
    }

    public void showImage(Image image, double scale) {
        if (image == null) {
            return;
        }
        int w = (int)Math.round((double)image.getWidth(null) * scale);
        int h = (int)Math.round((double)image.getHeight(null) * scale);
        this.showImage(image, w, h);
    }

    public void showImage(Image image) {
        this.showImage(image, 1.0);
    }

    public void showImage(opencv_core.IplImage image, int w, int h) {
        this.showImage(image.getBufferedImage(image.getBufferedImageType() == 0 ? 1.0 : this.invgamma), w, h);
    }

    public void showImage(opencv_core.IplImage image, double scale) {
        this.showImage(image.getBufferedImage(image.getBufferedImageType() == 0 ? 1.0 : this.invgamma), scale);
    }

    public void showImage(opencv_core.IplImage image) {
        this.showImage(image.getBufferedImage(image.getBufferedImageType() == 0 ? 1.0 : this.invgamma));
    }

    public void showColor(Color color) {
        Graphics2D g = this.createGraphics();
        g.setColor(color);
        g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        this.releaseGraphics(g);
    }

    public void showColor(opencv_core.CvScalar color) {
        this.showColor(new Color((int)color.red(), (int)color.green(), (int)color.blue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tile(final CanvasFrame[] frames) {
        class MovedListener
        extends ComponentAdapter {
            boolean moved = false;

            MovedListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentMoved(ComponentEvent e) {
                Component c;
                this.moved = true;
                Component component = c = e.getComponent();
                synchronized (component) {
                    c.notify();
                }
            }
        }
        final MovedListener movedListener = new MovedListener();
        int canvasCols = (int)Math.round(Math.sqrt(frames.length));
        if (canvasCols * canvasCols < frames.length) {
            ++canvasCols;
        }
        int canvasX = 0;
        int canvasY = 0;
        int canvasMaxY = 0;
        for (int i = 0; i < frames.length; ++i) {
            final int n = i;
            final int x = canvasX;
            final int y = canvasY;
            try {
                movedListener.moved = false;
                EventQueue.invokeAndWait(new Runnable(){
                    {
                    }

                    public void run() {
                        frames[n].addComponentListener(movedListener);
                        frames[n].setLocation(x, y);
                    }
                });
                for (int count = 0; !movedListener.moved && count < 5; ++count) {
                    CanvasFrame canvasFrame = frames[n];
                    synchronized (canvasFrame) {
                        frames[n].wait(100L);
                        continue;
                    }
                }
                EventQueue.invokeAndWait(new Runnable(){
                    {
                    }

                    public void run() {
                        frames[n].removeComponentListener(movedListener);
                    }
                });
            }
            catch (Exception ex) {
                // empty catch block
            }
            canvasX = frames[i].getX() + frames[i].getWidth();
            canvasMaxY = Math.max(canvasMaxY, frames[i].getY() + frames[i].getHeight());
            if ((i + 1) % canvasCols != 0) continue;
            canvasX = 0;
            canvasY = canvasMaxY;
        }
    }
}

