/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.camera;

import edu.wpi.first.smartdashboard.gui.DashboardFrame;
import edu.wpi.first.smartdashboard.gui.DashboardPrefs;
import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.properties.IPAddressProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.wpijavacv.WPICamera;
import edu.wpi.first.wpijavacv.WPIColorImage;
import edu.wpi.first.wpijavacv.WPIGrayscaleImage;
import edu.wpi.first.wpijavacv.WPIImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public class WPICameraExtension
extends StaticWidget {
    public static final String NAME = "Camera";
    private boolean connected = false;
    private boolean resized = false;
    private WPICamera cam;
    private BufferedImage drawnImage;
    private BGThread bgThread = new BGThread();
    private GCThread gcThread = new GCThread();
    public final IPAddressProperty ipProperty;

    public WPICameraExtension() {
        this.ipProperty = new IPAddressProperty((PropertyHolder)this, "Camera IP Address", new int[]{10, DashboardPrefs.getInstance().team.getValue() / 100, DashboardPrefs.getInstance().team.getValue() % 100, 20});
    }

    public void init() {
        this.setPreferredSize(new Dimension(100, 100));
        this.bgThread.start();
        this.gcThread.start();
        this.revalidate();
        DashboardFrame.getInstance().getPanel().repaint(this.getBounds());
    }

    public void propertyChanged(Property property) {
        if (property == this.ipProperty) {
            if (this.cam != null) {
                this.cam.dispose();
            }
            try {
                this.cam = new WPICamera(this.ipProperty.getSaveValue());
            }
            catch (Exception e) {
                this.drawnImage = null;
                this.setPreferredSize(new Dimension(100, 100));
                this.revalidate();
                DashboardFrame.getInstance().getPanel().repaint(this.getBounds());
            }
        }
    }

    public void disconnect() {
        this.bgThread.destroy();
        this.gcThread.destroy();
        if (this.cam != null) {
            this.cam.dispose();
        }
        super.disconnect();
    }

    protected void paintComponent(Graphics g) {
        if (this.drawnImage != null) {
            if (!this.resized) {
                this.setPreferredSize(new Dimension(this.drawnImage.getWidth(), this.drawnImage.getHeight()));
                this.revalidate();
            }
            int width = this.getBounds().width;
            int height = this.getBounds().height;
            double scale = Math.min((double)width / (double)this.drawnImage.getWidth(), (double)height / (double)this.drawnImage.getHeight());
            g.drawImage(this.drawnImage, (int)((double)width - scale * (double)this.drawnImage.getWidth()) / 2, (int)((double)height - scale * (double)this.drawnImage.getHeight()) / 2, (int)(((double)width + scale * (double)this.drawnImage.getWidth()) / 2.0), (int)((double)height + scale * (double)this.drawnImage.getHeight()) / 2, 0, 0, this.drawnImage.getWidth(), this.drawnImage.getHeight(), null);
        } else {
            g.setColor(Color.PINK);
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            g.setColor(Color.BLACK);
            g.drawString("NO CONNECTION", 10, 10);
        }
    }

    public WPIImage processImage(WPIColorImage rawImage) {
        return rawImage;
    }

    public WPIImage processImage(WPIGrayscaleImage rawImage) {
        return rawImage;
    }

    public class BGThread
    extends Thread {
        boolean destroyed;
        Runnable draw;

        public BGThread() {
            super("Camera Background");
            this.destroyed = false;
            this.draw = new Runnable(){

                public void run() {
                    DashboardFrame.getInstance().getPanel().repaint(WPICameraExtension.this.getBounds());
                }
            };
        }

        public void run() {
            while (!this.destroyed) {
                if (WPICameraExtension.this.cam == null) {
                    WPICameraExtension.this.cam = new WPICamera(WPICameraExtension.this.ipProperty.getSaveValue());
                }
                try {
                    WPIImage image = WPICameraExtension.this.cam.getNewImage(5.0);
                    if (image instanceof WPIColorImage) {
                        WPICameraExtension.this.drawnImage = WPICameraExtension.this.processImage((WPIColorImage)image).getBufferedImage();
                        SwingUtilities.invokeLater(this.draw);
                        continue;
                    }
                    if (!(image instanceof WPIGrayscaleImage)) continue;
                    WPICameraExtension.this.drawnImage = WPICameraExtension.this.processImage((WPIGrayscaleImage)image).getBufferedImage();
                    SwingUtilities.invokeLater(this.draw);
                }
                catch (Exception e) {
                    WPICameraExtension.this.cam.dispose();
                    WPICameraExtension.this.cam = null;
                    WPICameraExtension.this.drawnImage = null;
                    SwingUtilities.invokeLater(this.draw);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void destroy() {
            this.destroyed = true;
        }
    }

    public class GCThread
    extends Thread {
        boolean destroyed = false;

        public void run() {
            while (!this.destroyed) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
            }
        }

        public void destroy() {
            this.destroyed = true;
            this.interrupt();
        }
    }
}

