/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.server;

import edu.wpi.first.wpilibj.networktables2.server.ServerAdapterManager;
import edu.wpi.first.wpilibj.networktables2.server.ServerConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.server.ServerIncomingConnectionListener;
import edu.wpi.first.wpilibj.networktables2.server.ServerNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamProvider;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.PeriodicRunnable;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.IOException;

public class ServerIncomingStreamMonitor
implements PeriodicRunnable {
    private final IOStreamProvider streamProvider;
    private final ServerIncomingConnectionListener incomingListener;
    private final ServerNetworkTableEntryStore entryStore;
    private final ServerAdapterManager adapterListener;
    private NTThread monitorThread;
    private NTThreadManager threadManager;
    private final NetworkTableEntryTypeManager typeManager;

    public ServerIncomingStreamMonitor(IOStreamProvider iOStreamProvider, ServerNetworkTableEntryStore serverNetworkTableEntryStore, ServerIncomingConnectionListener serverIncomingConnectionListener, ServerAdapterManager serverAdapterManager, NetworkTableEntryTypeManager networkTableEntryTypeManager, NTThreadManager nTThreadManager) {
        this.streamProvider = iOStreamProvider;
        this.entryStore = serverNetworkTableEntryStore;
        this.incomingListener = serverIncomingConnectionListener;
        this.adapterListener = serverAdapterManager;
        this.typeManager = networkTableEntryTypeManager;
        this.threadManager = nTThreadManager;
    }

    public void start() {
        if (this.monitorThread != null) {
            this.stop();
        }
        this.monitorThread = this.threadManager.newBlockingPeriodicThread(this, "Server Incoming Stream Monitor Thread");
    }

    public void stop() {
        if (this.monitorThread != null) {
            this.monitorThread.stop();
        }
    }

    @Override
    public void run() {
        IOStream iOStream = null;
        try {
            iOStream = this.streamProvider.accept();
            if (iOStream != null) {
                ServerConnectionAdapter serverConnectionAdapter = new ServerConnectionAdapter(iOStream, this.entryStore, this.entryStore, this.adapterListener, this.typeManager, this.threadManager);
                this.incomingListener.onNewConnection(serverConnectionAdapter);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

