/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.connection;

import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.connection.BadMessageException;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NetworkTableConnection {
    public static final char PROTOCOL_REVISION = '\u0200';
    private final Object WRITE_LOCK = new Object();
    private final DataInputStream is;
    private final DataOutputStream os;
    public final IOStream stream;
    private final NetworkTableEntryTypeManager typeManager;
    private boolean isValid;

    public NetworkTableConnection(IOStream iOStream, NetworkTableEntryTypeManager networkTableEntryTypeManager) {
        this.stream = iOStream;
        this.typeManager = networkTableEntryTypeManager;
        this.is = new DataInputStream(new BufferedInputStream(iOStream.getInputStream()));
        this.os = new DataOutputStream(new BufferedOutputStream(iOStream.getOutputStream()));
        this.isValid = true;
    }

    public void close() {
        if (this.isValid) {
            this.isValid = false;
            this.stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageHeader(int n) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.os.writeByte(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeepAlive() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(0);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClientHello() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(1);
            this.os.writeChar(512);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendServerHelloComplete() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(3);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendProtocolVersionUnsupported() throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(2);
            this.os.writeChar(512);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEntryAssignment(NetworkTableEntry networkTableEntry) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(16);
            this.os.writeUTF(networkTableEntry.name);
            this.os.writeByte(networkTableEntry.getType().id);
            this.os.writeChar(networkTableEntry.getId());
            this.os.writeChar(networkTableEntry.getSequenceNumber());
            networkTableEntry.sendValue(this.os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEntryUpdate(NetworkTableEntry networkTableEntry) throws IOException {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.sendMessageHeader(17);
            this.os.writeChar(networkTableEntry.getId());
            this.os.writeChar(networkTableEntry.getSequenceNumber());
            networkTableEntry.sendValue(this.os);
        }
    }

    public void read(ConnectionAdapter connectionAdapter) throws IOException {
        byte by = this.is.readByte();
        switch (by) {
            case 0: {
                connectionAdapter.keepAlive();
                return;
            }
            case 1: {
                char c = this.is.readChar();
                connectionAdapter.clientHello(c);
                return;
            }
            case 3: {
                connectionAdapter.serverHelloComplete();
                return;
            }
            case 2: {
                char c = this.is.readChar();
                connectionAdapter.protocolVersionUnsupported(c);
                return;
            }
            case 16: {
                String string = this.is.readUTF();
                byte by2 = this.is.readByte();
                NetworkTableEntryType networkTableEntryType = this.typeManager.getType(by2);
                if (networkTableEntryType == null) {
                    throw new BadMessageException("Unknown data type: 0x" + Integer.toHexString(by2));
                }
                char c = this.is.readChar();
                char c2 = this.is.readChar();
                Object object = networkTableEntryType.readValue(this.is);
                connectionAdapter.offerIncomingAssignment(new NetworkTableEntry(c, string, c2, networkTableEntryType, object));
                return;
            }
            case 17: {
                char c = this.is.readChar();
                char c3 = this.is.readChar();
                NetworkTableEntry networkTableEntry = connectionAdapter.getEntry(c);
                if (networkTableEntry == null) {
                    throw new BadMessageException("Received update for unknown entry id: " + c);
                }
                Object object = networkTableEntry.getType().readValue(this.is);
                connectionAdapter.offerIncomingUpdate(networkTableEntry, c3, object);
                return;
            }
        }
        throw new BadMessageException("Unknown Network Table Message Type: " + by);
    }
}

