/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.AbstractNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.connection.NetworkTableConnection;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import java.io.DataOutputStream;
import java.io.IOException;

public class NetworkTableEntry {
    public static final char UNKNOWN_ID = '\uffff';
    private char id;
    private char sequenceNumber;
    public final String name;
    private NetworkTableEntryType type;
    private Object value;
    private volatile boolean isNew = true;
    private volatile boolean isDirty = false;
    private static final char HALF_OF_CHAR = '\u8000';

    public NetworkTableEntry(String string, NetworkTableEntryType networkTableEntryType, Object object) {
        this('\uffff', string, '\u0000', networkTableEntryType, object);
    }

    public NetworkTableEntry(char c, String string, char c2, NetworkTableEntryType networkTableEntryType, Object object) {
        this.id = c;
        this.name = string;
        this.sequenceNumber = c2;
        this.type = networkTableEntryType;
        this.value = object;
    }

    public char getId() {
        return this.id;
    }

    public Object getValue() {
        return this.value;
    }

    public NetworkTableEntryType getType() {
        return this.type;
    }

    public boolean putValue(char c, Object object) {
        if (this.sequenceNumber < c && c - this.sequenceNumber < 32768 || this.sequenceNumber > c && this.sequenceNumber - c > 32768) {
            this.value = object;
            this.sequenceNumber = c;
            return true;
        }
        return false;
    }

    public void forcePut(char c, Object object) {
        this.value = object;
        this.sequenceNumber = c;
    }

    public void forcePut(char c, NetworkTableEntryType networkTableEntryType, Object object) {
        this.type = networkTableEntryType;
        this.forcePut(c, object);
    }

    public void makeDirty() {
        this.isDirty = true;
    }

    public void makeClean() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void sendValue(DataOutputStream dataOutputStream) throws IOException {
        this.type.sendValue(this.value, dataOutputStream);
    }

    public char getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setId(char c) throws IllegalStateException {
        if (this.id != '\uffff') {
            throw new IllegalStateException("Cannot set the Id of a table entry that already has a valid id");
        }
        this.id = c;
    }

    public void clearId() {
        this.id = (char)65535;
    }

    public void send(NetworkTableConnection networkTableConnection) throws IOException {
        networkTableConnection.sendEntryAssignment(this);
    }

    public void fireListener(AbstractNetworkTableEntryStore.TableListenerManager tableListenerManager) {
        tableListenerManager.fireTableListeners(this.name, this.value, this.isNew);
        this.isNew = false;
    }

    public String toString() {
        return "Network Table " + this.type.name + " entry: " + this.name + ": " + this.getId() + " - " + this.getSequenceNumber() + " - " + this.getValue();
    }
}

