/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.IncomingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.OutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.TableKeyExistsWithDifferentTypeException;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.util.CharacterArrayMap;
import edu.wpi.first.wpilibj.networktables2.util.List;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractNetworkTableEntryStore
implements IncomingEntryReceiver {
    protected final CharacterArrayMap idEntries = new CharacterArrayMap();
    protected final Hashtable namedEntries = new Hashtable();
    protected final TableListenerManager listenerManager;
    protected OutgoingEntryReceiver outgoingReceiver;
    protected OutgoingEntryReceiver incomingReceiver;

    protected AbstractNetworkTableEntryStore(TableListenerManager tableListenerManager) {
        this.listenerManager = tableListenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkTableEntry getEntry(char c) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            return (NetworkTableEntry)this.idEntries.get(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkTableEntry getEntry(String string) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            return (NetworkTableEntry)this.namedEntries.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List keys() {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            List list = new List();
            Enumeration enumeration = this.namedEntries.keys();
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEntries() {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            this.idEntries.clear();
            this.namedEntries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIds() {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            this.idEntries.clear();
            Enumeration enumeration = this.namedEntries.elements();
            while (enumeration.hasMoreElements()) {
                ((NetworkTableEntry)enumeration.nextElement()).clearId();
            }
        }
    }

    public void setOutgoingReceiver(OutgoingEntryReceiver outgoingEntryReceiver) {
        this.outgoingReceiver = outgoingEntryReceiver;
    }

    public void setIncomingReceiver(OutgoingEntryReceiver outgoingEntryReceiver) {
        this.incomingReceiver = outgoingEntryReceiver;
    }

    protected abstract boolean addEntry(NetworkTableEntry var1);

    protected abstract boolean updateEntry(NetworkTableEntry var1, char var2, Object var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOutgoing(String string, NetworkTableEntryType networkTableEntryType, Object object) throws TableKeyExistsWithDifferentTypeException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry networkTableEntry = (NetworkTableEntry)this.namedEntries.get(string);
            if (networkTableEntry == null) {
                networkTableEntry = new NetworkTableEntry(string, networkTableEntryType, object);
                if (this.addEntry(networkTableEntry)) {
                    networkTableEntry.fireListener(this.listenerManager);
                    this.outgoingReceiver.offerOutgoingAssignment(networkTableEntry);
                }
            } else {
                if (networkTableEntry.getType().id != networkTableEntryType.id) {
                    throw new TableKeyExistsWithDifferentTypeException(string, networkTableEntry.getType());
                }
                if (this.updateEntry(networkTableEntry, (char)(networkTableEntry.getSequenceNumber() + '\u0001'), object)) {
                    this.outgoingReceiver.offerOutgoingUpdate(networkTableEntry);
                }
                networkTableEntry.fireListener(this.listenerManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOutgoing(NetworkTableEntry networkTableEntry, Object object) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            if (this.updateEntry(networkTableEntry, (char)(networkTableEntry.getSequenceNumber() + '\u0001'), object)) {
                this.outgoingReceiver.offerOutgoingUpdate(networkTableEntry);
            }
            networkTableEntry.fireListener(this.listenerManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerIncomingAssignment(NetworkTableEntry networkTableEntry) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry networkTableEntry2 = (NetworkTableEntry)this.namedEntries.get(networkTableEntry.name);
            if (this.addEntry(networkTableEntry)) {
                if (networkTableEntry2 == null) {
                    networkTableEntry2 = networkTableEntry;
                }
                networkTableEntry2.fireListener(this.listenerManager);
                this.incomingReceiver.offerOutgoingAssignment(networkTableEntry2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerIncomingUpdate(NetworkTableEntry networkTableEntry, char c, Object object) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            if (this.updateEntry(networkTableEntry, c, object)) {
                networkTableEntry.fireListener(this.listenerManager);
                this.incomingReceiver.offerOutgoingUpdate(networkTableEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEntries(ITable iTable, ITableListener iTableListener) {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this;
        synchronized (abstractNetworkTableEntryStore) {
            Enumeration enumeration = this.namedEntries.elements();
            while (enumeration.hasMoreElements()) {
                NetworkTableEntry networkTableEntry = (NetworkTableEntry)enumeration.nextElement();
                iTableListener.valueChanged(iTable, networkTableEntry.name, networkTableEntry.getValue(), true);
            }
        }
    }

    public static interface TableListenerManager {
        public void fireTableListeners(String var1, Object var2, boolean var3);
    }
}

