/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.client.NetworkTableClient;
import edu.wpi.first.wpilibj.networktables2.server.NetworkTableServer;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamFactory;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamProvider;
import edu.wpi.first.wpilibj.networktables2.stream.SocketStreams;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.IOException;

public abstract class NetworkTableMode {
    public static final NetworkTableMode Server = new NetworkTableMode("Server"){

        @Override
        public NetworkTableNode createNode(String string, int n, NTThreadManager nTThreadManager) throws IOException {
            IOStreamProvider iOStreamProvider = SocketStreams.newStreamProvider(n);
            return new NetworkTableServer(iOStreamProvider, new NetworkTableEntryTypeManager(), nTThreadManager);
        }
    };
    public static final NetworkTableMode Client = new NetworkTableMode("Client"){

        @Override
        public NetworkTableNode createNode(String string, int n, NTThreadManager nTThreadManager) throws IOException {
            if (string == null) {
                throw new IllegalArgumentException("IP address cannot be null when in client mode");
            }
            IOStreamFactory iOStreamFactory = SocketStreams.newStreamFactory(string, n);
            NetworkTableClient networkTableClient = new NetworkTableClient(iOStreamFactory, new NetworkTableEntryTypeManager(), nTThreadManager);
            networkTableClient.reconnect();
            return networkTableClient;
        }
    };
    private String name;

    private NetworkTableMode(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    abstract NetworkTableNode createNode(String var1, int var2, NTThreadManager var3) throws IOException;
}

