/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.NetworkTableConnectionListenerAdapter;
import edu.wpi.first.wpilibj.networktables.NetworkTableKeyListenerAdapter;
import edu.wpi.first.wpilibj.networktables.NetworkTableListenerAdapter;
import edu.wpi.first.wpilibj.networktables.NetworkTableMode;
import edu.wpi.first.wpilibj.networktables.NetworkTableProvider;
import edu.wpi.first.wpilibj.networktables.NetworkTableSubListenerAdapter;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.thread.DefaultThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.util.List;
import edu.wpi.first.wpilibj.networktables2.util.StringCache;
import edu.wpi.first.wpilibj.tables.IRemote;
import edu.wpi.first.wpilibj.tables.IRemoteConnectionListener;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class NetworkTable
implements ITable,
IRemote {
    private static final NTThreadManager threadManager = new DefaultThreadManager();
    public static final char PATH_SEPARATOR = '/';
    public static final int DEFAULT_PORT = 1735;
    private static NetworkTableProvider staticProvider = null;
    private static NetworkTableMode mode = NetworkTableMode.Server;
    private static int port = 1735;
    private static String ipAddress = null;
    private final String path;
    private final EntryCache entryCache;
    private final NetworkTableKeyCache absoluteKeyCache;
    private final NetworkTableProvider provider;
    private final NetworkTableNode node;
    private final Hashtable connectionListenerMap = new Hashtable();
    private final Hashtable listenerMap = new Hashtable();

    private static synchronized void checkInit() {
        if (staticProvider != null) {
            throw new IllegalStateException("Network tables has already been initialized");
        }
    }

    public static synchronized void initialize() throws IOException {
        NetworkTable.checkInit();
        staticProvider = new NetworkTableProvider(mode.createNode(ipAddress, port, threadManager));
    }

    public static synchronized void setTableProvider(NetworkTableProvider networkTableProvider) {
        NetworkTable.checkInit();
        staticProvider = networkTableProvider;
    }

    public static synchronized void setServerMode() {
        NetworkTable.checkInit();
        mode = NetworkTableMode.Server;
    }

    public static synchronized void setClientMode() {
        NetworkTable.checkInit();
        mode = NetworkTableMode.Client;
    }

    public static synchronized void setTeam(int n) {
        NetworkTable.setIPAddress("10." + n / 100 + "." + n % 100 + ".2");
    }

    public static synchronized void setIPAddress(String string) {
        NetworkTable.checkInit();
        ipAddress = string;
    }

    public static synchronized NetworkTable getTable(String string) {
        if (staticProvider == null) {
            try {
                NetworkTable.initialize();
            }
            catch (IOException iOException) {
                throw new RuntimeException("NetworkTable could not be initialized: " + iOException + ": " + iOException.getMessage());
            }
        }
        return (NetworkTable)staticProvider.getTable('/' + string);
    }

    NetworkTable(String string, NetworkTableProvider networkTableProvider) {
        this.path = string;
        this.entryCache = new EntryCache(string);
        this.absoluteKeyCache = new NetworkTableKeyCache(string);
        this.provider = networkTableProvider;
        this.node = networkTableProvider.getNode();
    }

    public String toString() {
        return "NetworkTable: " + this.path;
    }

    @Override
    public boolean isConnected() {
        return this.node.isConnected();
    }

    @Override
    public boolean isServer() {
        return this.node.isServer();
    }

    @Override
    public void addConnectionListener(IRemoteConnectionListener iRemoteConnectionListener, boolean bl) {
        NetworkTableConnectionListenerAdapter networkTableConnectionListenerAdapter = (NetworkTableConnectionListenerAdapter)this.connectionListenerMap.get(iRemoteConnectionListener);
        if (networkTableConnectionListenerAdapter != null) {
            throw new IllegalStateException("Cannot add the same listener twice");
        }
        networkTableConnectionListenerAdapter = new NetworkTableConnectionListenerAdapter(this, iRemoteConnectionListener);
        this.connectionListenerMap.put(iRemoteConnectionListener, networkTableConnectionListenerAdapter);
        this.node.addConnectionListener(networkTableConnectionListenerAdapter, bl);
    }

    @Override
    public void removeConnectionListener(IRemoteConnectionListener iRemoteConnectionListener) {
        NetworkTableConnectionListenerAdapter networkTableConnectionListenerAdapter = (NetworkTableConnectionListenerAdapter)this.connectionListenerMap.get(iRemoteConnectionListener);
        if (networkTableConnectionListenerAdapter != null) {
            this.node.removeConnectionListener(networkTableConnectionListenerAdapter);
        }
    }

    @Override
    public void addTableListener(ITableListener iTableListener) {
        this.addTableListener(iTableListener, false);
    }

    @Override
    public void addTableListener(ITableListener iTableListener, boolean bl) {
        List list = (List)this.listenerMap.get(iTableListener);
        if (list == null) {
            list = new List();
            this.listenerMap.put(iTableListener, list);
        }
        NetworkTableListenerAdapter networkTableListenerAdapter = new NetworkTableListenerAdapter(this.path + '/', this, iTableListener);
        list.add(networkTableListenerAdapter);
        this.node.addTableListener(networkTableListenerAdapter, bl);
    }

    @Override
    public void addTableListener(String string, ITableListener iTableListener, boolean bl) {
        List list = (List)this.listenerMap.get(iTableListener);
        if (list == null) {
            list = new List();
            this.listenerMap.put(iTableListener, list);
        }
        NetworkTableKeyListenerAdapter networkTableKeyListenerAdapter = new NetworkTableKeyListenerAdapter(string, this.absoluteKeyCache.get(string), this, iTableListener);
        list.add(networkTableKeyListenerAdapter);
        this.node.addTableListener(networkTableKeyListenerAdapter, bl);
    }

    @Override
    public void addSubTableListener(ITableListener iTableListener) {
        List list = (List)this.listenerMap.get(iTableListener);
        if (list == null) {
            list = new List();
            this.listenerMap.put(iTableListener, list);
        }
        NetworkTableSubListenerAdapter networkTableSubListenerAdapter = new NetworkTableSubListenerAdapter(this.path, this, iTableListener);
        list.add(networkTableSubListenerAdapter);
        this.node.addTableListener(networkTableSubListenerAdapter, true);
    }

    @Override
    public void removeTableListener(ITableListener iTableListener) {
        List list = (List)this.listenerMap.get(iTableListener);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.node.removeTableListener((ITableListener)list.get(i));
            }
            list.clear();
        }
    }

    private synchronized NetworkTableEntry getEntry(String string) {
        return this.entryCache.get(string);
    }

    @Override
    public synchronized ITable getSubTable(String string) {
        return (NetworkTable)this.provider.getTable(this.absoluteKeyCache.get(string));
    }

    @Override
    public boolean containsKey(String string) {
        return this.node.containsKey(this.absoluteKeyCache.get(string));
    }

    @Override
    public boolean containsSubTable(String string) {
        String string2 = this.absoluteKeyCache.get(string) + '/';
        List list = this.node.getEntryStore().keys();
        for (int i = 0; i < list.size(); ++i) {
            if (!((String)list.get(i)).startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putNumber(String string, double d) {
        this.putValue(string, new Double(d));
    }

    @Override
    public double getNumber(String string) throws TableKeyNotDefinedException {
        return this.node.getDouble(this.absoluteKeyCache.get(string));
    }

    @Override
    public double getNumber(String string, double d) {
        try {
            return this.node.getDouble(this.absoluteKeyCache.get(string));
        }
        catch (TableKeyNotDefinedException tableKeyNotDefinedException) {
            return d;
        }
    }

    @Override
    public void putString(String string, String string2) {
        this.putValue(string, string2);
    }

    @Override
    public String getString(String string) throws TableKeyNotDefinedException {
        return this.node.getString(this.absoluteKeyCache.get(string));
    }

    @Override
    public String getString(String string, String string2) {
        try {
            return this.node.getString(this.absoluteKeyCache.get(string));
        }
        catch (TableKeyNotDefinedException tableKeyNotDefinedException) {
            return string2;
        }
    }

    @Override
    public void putBoolean(String string, boolean bl) {
        this.putValue(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public boolean getBoolean(String string) throws TableKeyNotDefinedException {
        return this.node.getBoolean(this.absoluteKeyCache.get(string));
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        try {
            return this.node.getBoolean(this.absoluteKeyCache.get(string));
        }
        catch (TableKeyNotDefinedException tableKeyNotDefinedException) {
            return bl;
        }
    }

    @Override
    public void retrieveValue(String string, Object object) {
        this.node.retrieveValue(this.absoluteKeyCache.get(string), object);
    }

    @Override
    public void putValue(String string, Object object) {
        NetworkTableEntry networkTableEntry = this.entryCache.get(string);
        if (networkTableEntry != null) {
            this.node.putValue(networkTableEntry, object);
        } else {
            this.node.putValue(this.absoluteKeyCache.get(string), object);
        }
    }

    @Override
    public Object getValue(String string) throws TableKeyNotDefinedException {
        return this.node.getValue(this.absoluteKeyCache.get(string));
    }

    public Object getValue(String string, Object object) {
        try {
            return this.node.getValue(this.absoluteKeyCache.get(string));
        }
        catch (TableKeyNotDefinedException tableKeyNotDefinedException) {
            return object;
        }
    }

    @Override
    public void putInt(String string, int n) {
        this.putNumber(string, n);
    }

    @Override
    public int getInt(String string) throws TableKeyNotDefinedException {
        return (int)this.getNumber(string);
    }

    @Override
    public int getInt(String string, int n) throws TableKeyNotDefinedException {
        try {
            return (int)this.getNumber(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            return n;
        }
    }

    @Override
    public void putDouble(String string, double d) {
        this.putNumber(string, d);
    }

    @Override
    public double getDouble(String string) throws TableKeyNotDefinedException {
        return this.getNumber(string);
    }

    @Override
    public double getDouble(String string, double d) {
        return this.getNumber(string, d);
    }

    class EntryCache {
        private final Hashtable cache = new Hashtable();
        private final String path;

        public EntryCache(String string) {
            this.path = string;
        }

        public NetworkTableEntry get(String string) {
            NetworkTableEntry networkTableEntry = (NetworkTableEntry)this.cache.get(string);
            if (networkTableEntry == null && (networkTableEntry = NetworkTable.this.node.getEntryStore().getEntry(NetworkTable.this.absoluteKeyCache.get(string))) != null) {
                this.cache.put(string, networkTableEntry);
            }
            return networkTableEntry;
        }
    }

    static class NetworkTableKeyCache
    extends StringCache {
        private final String path;

        public NetworkTableKeyCache(String string) {
            this.path = string;
        }

        @Override
        public String calc(String string) {
            return this.path + '/' + string;
        }
    }
}

