/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.BaseChildSettings;
import com.googlecode.javacv.cpp.opencv_calib3d;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_features2d;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFinder {
    private Settings settings;
    private static final Logger logger = Logger.getLogger(ObjectFinder.class.getName());
    private opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
    private opencv_core.CvMemStorage tempStorage = opencv_core.CvMemStorage.create();
    private opencv_features2d.CvSURFPoint[] objectKeypoints = null;
    private FloatBuffer[] objectDescriptors = null;
    private ThreadLocal<opencv_core.CvMat> localpt1 = null;
    private ThreadLocal<opencv_core.CvMat> localpt2 = null;
    private ThreadLocal<opencv_core.CvMat> localmask = null;
    private static ThreadLocal<opencv_core.CvMat> H3x3 = opencv_core.CvMat.createThreadLocal(3, 3);

    public ObjectFinder(opencv_core.IplImage objectImage, opencv_features2d.CvSURFParams parameters, double distanceThreshold, int matchesMin) throws Exception {
        this.settings = new Settings();
        this.settings.objectImage = objectImage;
        this.settings.parameters = parameters;
        this.settings.distanceThreshold = distanceThreshold;
        this.settings.matchesMin = matchesMin;
        this.setSettings(this.settings);
    }

    public ObjectFinder(opencv_core.IplImage objectImage) throws Exception {
        this.settings = new Settings();
        this.settings.objectImage = objectImage;
        this.setSettings(this.settings);
    }

    public ObjectFinder(Settings settings) throws Exception {
        this.setSettings(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) throws Exception {
        this.settings = settings;
        opencv_core.CvSeq keypoints = new opencv_core.CvSeq(null);
        opencv_core.CvSeq descriptors = new opencv_core.CvSeq(null);
        opencv_core.cvClearMemStorage(this.storage);
        opencv_features2d.cvExtractSURF(settings.objectImage, null, keypoints, descriptors, this.storage, settings.parameters, 0);
        int total = descriptors.total();
        int elem_size = descriptors.elem_size();
        this.objectKeypoints = new opencv_features2d.CvSURFPoint[total];
        this.objectDescriptors = new FloatBuffer[total];
        for (int i = 0; i < total; ++i) {
            this.objectKeypoints[i] = new opencv_features2d.CvSURFPoint(opencv_core.cvGetSeqElem(keypoints, i));
            this.objectDescriptors[i] = opencv_core.cvGetSeqElem(descriptors, i).asByteBuffer(elem_size).asFloatBuffer();
        }
        this.localpt1 = opencv_core.CvMat.createThreadLocal(1, this.objectDescriptors.length, 5, 2);
        this.localpt2 = opencv_core.CvMat.createThreadLocal(1, this.objectDescriptors.length, 5, 2);
        this.localmask = opencv_core.CvMat.createThreadLocal(1, this.objectDescriptors.length, 0, 1);
        logger.info(total + " object descriptors");
    }

    public double[] find(opencv_core.IplImage image) {
        opencv_core.CvSeq keypoints = new opencv_core.CvSeq(null);
        opencv_core.CvSeq descriptors = new opencv_core.CvSeq(null);
        opencv_features2d.cvExtractSURF(image, null, keypoints, descriptors, this.tempStorage, this.settings.parameters, 0);
        int total = descriptors.total();
        int elem_size = descriptors.elem_size();
        opencv_features2d.CvSURFPoint[] imageKeypoints = new opencv_features2d.CvSURFPoint[total];
        FloatBuffer[] imageDescriptors = new FloatBuffer[total];
        for (int i = 0; i < total; ++i) {
            imageKeypoints[i] = new opencv_features2d.CvSURFPoint(opencv_core.cvGetSeqElem(keypoints, i));
            imageDescriptors[i] = opencv_core.cvGetSeqElem(descriptors, i).asByteBuffer(elem_size).asFloatBuffer();
        }
        logger.info(total + " image descriptors");
        int w = this.settings.objectImage.width();
        int h = this.settings.objectImage.height();
        double[] srcCorners = new double[]{0.0, 0.0, w, 0.0, w, h, 0.0, h};
        double[] dstCorners = this.locatePlanarObject(this.objectKeypoints, this.objectDescriptors, imageKeypoints, imageDescriptors, srcCorners);
        opencv_core.cvClearMemStorage(this.tempStorage);
        return dstCorners;
    }

    private double compareSURFDescriptors(FloatBuffer d1, FloatBuffer d2, double best) {
        double t3;
        double t2;
        double t1;
        double t0;
        double totalCost = 0.0;
        assert (d1.capacity() == d2.capacity() && d1.capacity() % 4 == 0);
        for (int i = 0; i < d1.capacity() && !((totalCost += (t0 = (double)(d1.get(i) - d2.get(i))) * t0 + (t1 = (double)(d1.get(i + 1) - d2.get(i + 1))) * t1 + (t2 = (double)(d1.get(i + 2) - d2.get(i + 2))) * t2 + (t3 = (double)(d1.get(i + 3) - d2.get(i + 3))) * t3) > best); i += 4) {
        }
        return totalCost;
    }

    private int naiveNearestNeighbor(FloatBuffer vec, int laplacian, opencv_features2d.CvSURFPoint[] modelKeypoints, FloatBuffer[] modelDescriptors) {
        int neighbor = -1;
        double dist1 = 1000000.0;
        double dist2 = 1000000.0;
        for (int i = 0; i < modelDescriptors.length; ++i) {
            opencv_features2d.CvSURFPoint kp = modelKeypoints[i];
            FloatBuffer mvec = modelDescriptors[i];
            if (laplacian != kp.laplacian()) continue;
            double d = this.compareSURFDescriptors(vec, mvec, dist2);
            if (d < dist1) {
                dist2 = dist1;
                dist1 = d;
                neighbor = i;
                continue;
            }
            if (!(d < dist2)) continue;
            dist2 = d;
        }
        if (dist1 < this.settings.distanceThreshold * dist2) {
            return neighbor;
        }
        return -1;
    }

    private ArrayList<Integer> findPairs(opencv_features2d.CvSURFPoint[] objectKeypoints, FloatBuffer[] objectDescriptors, opencv_features2d.CvSURFPoint[] imageKeypoints, FloatBuffer[] imageDescriptors) {
        ArrayList<Integer> ptpairs = new ArrayList<Integer>(2 * objectDescriptors.length);
        for (int i = 0; i < objectDescriptors.length; ++i) {
            FloatBuffer descriptor = objectDescriptors[i];
            opencv_features2d.CvSURFPoint kp = objectKeypoints[i];
            int nearestNeighbor = this.naiveNearestNeighbor(descriptor, kp.laplacian(), imageKeypoints, imageDescriptors);
            if (nearestNeighbor < 0) continue;
            ptpairs.add(i);
            ptpairs.add(nearestNeighbor);
        }
        return ptpairs;
    }

    private double[] locatePlanarObject(opencv_features2d.CvSURFPoint[] objectKeypoints, FloatBuffer[] objectDescriptors, opencv_features2d.CvSURFPoint[] imageKeypoints, FloatBuffer[] imageDescriptors, double[] srcCorners) {
        ArrayList<Integer> ptpairs = this.findPairs(objectKeypoints, objectDescriptors, imageKeypoints, imageDescriptors);
        int n = ptpairs.size() / 2;
        logger.info(n + " matching pairs found");
        if (n < this.settings.matchesMin) {
            return null;
        }
        opencv_core.CvMat pt1 = this.localpt1.get();
        pt1.cols(n);
        opencv_core.CvMat pt2 = this.localpt2.get();
        pt2.cols(n);
        opencv_core.CvMat mask = this.localmask.get();
        mask.cols(n);
        for (int i = 0; i < n; ++i) {
            opencv_core.CvPoint2D32f p1 = objectKeypoints[ptpairs.get(i * 2)].pt();
            pt1.put(i * 2, (double)p1.x());
            pt1.put(i * 2 + 1, (double)p1.y());
            opencv_core.CvPoint2D32f p2 = imageKeypoints[ptpairs.get(i * 2 + 1)].pt();
            pt2.put(i * 2, (double)p2.x());
            pt2.put(i * 2 + 1, (double)p2.y());
        }
        opencv_core.CvMat H = H3x3.get();
        if (opencv_calib3d.cvFindHomography(pt1, pt2, H, 8, this.settings.ransacReprojThreshold, mask) == 0) {
            return null;
        }
        if (opencv_core.cvCountNonZero(mask) < this.settings.matchesMin) {
            return null;
        }
        double[] h = H.get();
        double[] dstCorners = new double[8];
        for (int i = 0; i < 4; ++i) {
            double x = srcCorners[2 * i];
            double y = srcCorners[2 * i + 1];
            double Z = 1.0 / (h[6] * x + h[7] * y + h[8]);
            double X = (h[0] * x + h[1] * y + h[2]) * Z;
            double Y = (h[3] * x + h[4] * y + h[5]) * Z;
            dstCorners[2 * i] = X;
            dstCorners[2 * i + 1] = Y;
        }
        pt1.cols(objectDescriptors.length);
        pt2.cols(objectDescriptors.length);
        mask.cols(objectDescriptors.length);
        return dstCorners;
    }

    public static class Settings
    extends BaseChildSettings {
        opencv_core.IplImage objectImage = null;
        opencv_features2d.CvSURFParams parameters = opencv_features2d.cvSURFParams(500.0, 1);
        double distanceThreshold = 0.6;
        int matchesMin = 4;
        double ransacReprojThreshold = 1.0;

        public opencv_core.IplImage getObjectImage() {
            return this.objectImage;
        }

        public void setObjectImage(opencv_core.IplImage objectImage) {
            this.objectImage = objectImage;
        }

        public boolean isExtended() {
            return this.parameters.extended() != 0;
        }

        public void setExtended(boolean extended) {
            this.parameters.extended(extended ? 1 : 0);
        }

        public double getHessianThreshold() {
            return this.parameters.hessianThreshold();
        }

        public void setHessianThreshold(double hessianThreshold) {
            this.parameters.hessianThreshold(hessianThreshold);
        }

        public int getnOctaves() {
            return this.parameters.nOctaves();
        }

        public void setnOctaves(int nOctaves) {
            this.parameters.nOctaves(nOctaves);
        }

        public int getnOctaveLayers() {
            return this.parameters.nOctaveLayers();
        }

        public void setnOctaveLayers(int nOctaveLayers) {
            this.parameters.nOctaveLayers(nOctaveLayers);
        }

        public double getDistanceThreshold() {
            return this.distanceThreshold;
        }

        public void setDistanceThreshold(double distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
        }

        public int getMatchesMin() {
            return this.matchesMin;
        }

        public void setMatchesMin(int matchesMin) {
            this.matchesMin = matchesMin;
        }

        public double getRansacReprojThreshold() {
            return this.ransacReprojThreshold;
        }

        public void setRansacReprojThreshold(double ransacReprojThreshold) {
            this.ransacReprojThreshold = ransacReprojThreshold;
        }
    }
}

