/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacv.FrameRecorder;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.swscale;
import java.io.File;
import java.nio.ByteOrder;

public class FFmpegFrameRecorder
extends FrameRecorder {
    private String filename;
    private avcodec.AVFrame picture;
    private BytePointer video_outbuf;
    private int video_outbuf_size;
    private avformat.AVOutputFormat oformat;
    private avformat.AVFormatContext oc;
    private avcodec.AVCodecContext c;
    private avformat.AVStream video_st;
    private swscale.SwsContext img_convert_ctx;
    private avcodec.AVPacket pkt;
    private avcodec.AVPicture tempPicture;
    public static final int DEFAULT_FRAME_RATE_BASE = 1001000;

    public FFmpegFrameRecorder(File file, int imageWidth, int imageHeight) {
        this(file.getAbsolutePath(), imageWidth, imageHeight);
    }

    public FFmpegFrameRecorder(String filename, int imageWidth, int imageHeight) {
        avformat.av_register_all();
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = avutil.PIX_FMT_RGB32;
        this.codecID = 26;
        this.bitrate = 400000;
        this.frameRate = 30.0;
        this.pkt = new avcodec.AVPacket();
        this.tempPicture = new avcodec.AVPicture();
    }

    public void release() throws Exception {
        this.stop();
    }

    protected void finalize() {
        try {
            this.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() throws Exception {
        String name;
        String formatName = this.format == null || this.format.length() == 0 ? null : this.format;
        this.oformat = avformat.av_guess_format(formatName, this.filename, null);
        if (this.oformat == null) {
            throw new Exception("Could not find suitable output format");
        }
        this.oc = avformat.avformat_alloc_context();
        if (this.oc == null) {
            throw new Exception("Memory error");
        }
        this.oc.oformat(this.oformat);
        this.oc.filename(this.filename);
        this.video_st = avformat.av_new_stream(this.oc, 0);
        if (this.video_st == null) {
            throw new Exception("Could not alloc stream");
        }
        this.c = this.video_st.codec();
        this.c.codec_id(this.codecID);
        this.c.codec_type(0);
        this.c.bit_rate(this.bitrate);
        this.c.width(this.imageWidth);
        this.c.height(this.imageHeight);
        this.c.time_base(avutil.av_d2q(1.0 / this.frameRate, 1001000));
        this.c.gop_size(12);
        this.c.pix_fmt(this.pixelFormat);
        if (this.c.codec_id() == 2) {
            this.c.max_b_frames(2);
        }
        if (this.c.codec_id() == 1) {
            this.c.mb_decision(2);
        }
        if ((name = this.oformat.name().getString()).equals("mp4") || name.equals("mov") || name.equals("3gp")) {
            this.c.flags(this.c.flags() | 0x400000);
        }
        if (avformat.av_set_parameters(this.oc, null) < 0) {
            avutil.av_freep(this.video_st);
            this.video_st = null;
            throw new Exception("Invalid output format parameters");
        }
        avformat.dump_format(this.oc, 0, this.filename, 1);
        if (this.video_st != null) {
            avcodec.AVCodec codec = avcodec.avcodec_find_encoder(this.c.codec_id());
            if (codec == null) {
                avutil.av_freep(this.video_st);
                this.video_st = null;
                throw new Exception("codec not found");
            }
            if (avcodec.avcodec_open(this.c, codec) < 0) {
                avutil.av_freep(this.video_st);
                this.video_st = null;
                throw new Exception("could not open codec");
            }
            this.picture = avcodec.avcodec_alloc_frame();
            if (this.picture != null) {
                int size = avcodec.avpicture_get_size(this.c.pix_fmt(), this.c.width(), this.c.height());
                BytePointer picture_buf = new BytePointer(avutil.av_malloc(size));
                if (picture_buf == null) {
                    avutil.av_free(this.picture);
                    this.picture = null;
                } else {
                    avcodec.avpicture_fill(this.picture, picture_buf, this.c.pix_fmt(), this.c.width(), this.c.height());
                }
            }
            if (this.picture == null) {
                avcodec.avcodec_close(this.c);
                avutil.av_freep(this.video_st);
                this.video_st = null;
                throw new Exception("Could not allocate picture");
            }
            this.video_outbuf = null;
            if ((this.oformat.flags() & 0x20) == 0) {
                this.video_outbuf_size = this.imageWidth * this.imageHeight * 4;
                this.video_outbuf = new BytePointer(avutil.av_malloc(this.video_outbuf_size));
            }
        }
        if ((this.oformat.flags() & 1) == 0) {
            avformat.ByteIOContext p = new avformat.ByteIOContext(null);
            if (avformat.url_fopen(p, this.filename, 1) < 0) {
                avcodec.avcodec_close(this.c);
                avutil.av_free(this.picture.data(0));
                avutil.av_free(this.picture);
                avutil.av_free(this.video_outbuf);
                avutil.av_freep(this.video_st);
                this.video_st = null;
                throw new Exception("Could not open '" + this.filename + "'");
            }
            this.oc.pb(p);
        }
        avformat.av_write_header(this.oc);
    }

    public void stop() throws Exception {
        if (this.video_st != null) {
            avcodec.avcodec_close(this.c);
            avutil.av_free(this.picture.data(0));
            avutil.av_free(this.picture);
            avutil.av_free(this.video_outbuf);
            avutil.av_freep(this.video_st);
            this.video_st = null;
        }
        if (this.oc != null) {
            avformat.av_write_trailer(this.oc);
            int nb_streams = this.oc.nb_streams();
            for (int i = 0; i < nb_streams; ++i) {
                avutil.av_freep(this.oc.streams(i));
            }
            if ((this.oformat.flags() & 1) == 0) {
                avformat.url_fclose(this.oc.pb());
            }
            avutil.av_free(this.oc);
            this.oc = null;
        }
    }

    public void record(opencv_core.IplImage frame) throws Exception {
        this.record(frame, false);
    }

    public void record(opencv_core.IplImage frame, boolean raw) throws Exception {
        int ret;
        if (this.video_st == null) {
            throw new Exception("No video output stream");
        }
        if (frame != null) {
            int pix_fmt = -1;
            int depth = frame.depth();
            int channels = frame.nChannels();
            if (depth == 8 && channels == 3) {
                pix_fmt = 3;
            } else if (depth == 8 && channels == 1) {
                pix_fmt = 8;
            } else if (depth == 16 && channels == 1) {
                pix_fmt = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? 31 : 32;
            } else if (depth == 8 && channels == 4) {
                pix_fmt = avutil.PIX_FMT_BGR32;
            } else if (!raw) {
                throw new Exception("Unsupported image format");
            }
            if (this.c.pix_fmt() != pix_fmt && !raw) {
                if (this.img_convert_ctx == null) {
                    this.img_convert_ctx = swscale.sws_getContext(frame.width(), frame.height(), pix_fmt, this.c.width(), this.c.height(), this.c.pix_fmt(), 4, null, null, null);
                    if (this.img_convert_ctx == null) {
                        throw new Exception("Cannot initialize the conversion context");
                    }
                }
                this.tempPicture.data(0, frame.imageData());
                this.tempPicture.linesize(0, frame.widthStep());
                swscale.sws_scale(this.img_convert_ctx, new PointerPointer((Pointer)this.tempPicture), this.tempPicture.linesize(), 0, this.c.height(), new PointerPointer((Pointer)this.picture), this.picture.linesize());
            } else {
                this.picture.data(0, frame.imageData());
                this.picture.linesize(0, frame.widthStep());
            }
        }
        if ((this.oformat.flags() & 0x20) != 0) {
            avcodec.av_init_packet(this.pkt);
            this.pkt.flags(this.pkt.flags() | 1);
            this.pkt.stream_index(this.video_st.index());
            this.pkt.data(new BytePointer(this.picture));
            this.pkt.size(Loader.sizeof(avcodec.AVPicture.class));
            ret = avformat.av_write_frame(this.oc, this.pkt);
        } else {
            int out_size = avcodec.avcodec_encode_video(this.c, this.video_outbuf, this.video_outbuf_size, this.picture);
            if (out_size > 0) {
                avcodec.av_init_packet(this.pkt);
                avcodec.AVFrame coded_frame = this.c.coded_frame();
                long pts = coded_frame.pts();
                if (coded_frame.pts() != Long.MIN_VALUE) {
                    this.pkt.pts(avutil.av_rescale_q(pts, this.c.time_base(), this.video_st.time_base()));
                }
                if (coded_frame.key_frame() != 0) {
                    this.pkt.flags(this.pkt.flags() | 1);
                }
                this.pkt.stream_index(this.video_st.index());
                this.pkt.data(this.video_outbuf);
                this.pkt.size(out_size);
                ret = avformat.av_write_frame(this.oc, this.pkt);
            } else {
                ret = 0;
            }
        }
        if (ret != 0) {
            throw new Exception("Error while writing video frame");
        }
    }
}

