/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Loader;
import com.googlecode.javacpp.LongPointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avdevice;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.swscale;
import java.io.File;

public class FFmpegFrameGrabber
extends FrameGrabber {
    private static Exception loadingException = null;
    private String filename;
    private avformat.AVFormatContext pFormatCtx;
    private int videoStream;
    private avformat.AVStream pStream;
    private avcodec.AVCodecContext pCodecCtx;
    private avcodec.AVCodec pCodec;
    private avcodec.AVFrame pFrame;
    private avcodec.AVFrame pFrameRGB;
    private swscale.SwsContext img_convert_ctx;
    private avcodec.AVPacket packet;
    private int[] frameFinished;
    private int numBytes;
    private BytePointer buffer;
    private opencv_core.IplImage return_image = null;

    public static void tryLoad() throws Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(avdevice.class);
            Loader.load(swscale.class);
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                loadingException = (Exception)t;
                throw loadingException;
            }
            loadingException = new Exception(t);
            throw loadingException;
        }
    }

    public FFmpegFrameGrabber(File file) {
        this(file.getAbsolutePath());
    }

    public FFmpegFrameGrabber(String filename) {
        avcodec.avcodec_init();
        avcodec.avcodec_register_all();
        avdevice.avdevice_register_all();
        avformat.av_register_all();
        this.filename = filename;
        this.pFormatCtx = new avformat.AVFormatContext(null);
        this.packet = new avcodec.AVPacket();
        this.frameFinished = new int[1];
    }

    public void release() throws Exception {
        this.stop();
    }

    protected void finalize() {
        try {
            this.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public void start() throws Exception {
        avformat.AVInputFormat f = null;
        if (this.format != null && this.format.length() > 0 && (f = avformat.av_find_input_format(this.format)) == null) {
            throw new Exception("Could not find input format \"" + this.format + "\".");
        }
        avformat.AVFormatParameters fp = null;
        if (this.frameRate > 0.0 || this.bpp > 0 || this.imageWidth > 0 || this.imageHeight > 0) {
            fp = new avformat.AVFormatParameters();
            fp.time_base(avutil.av_d2q(1.0 / this.frameRate, 1001000));
            fp.sample_rate(this.bpp);
            fp.channels(this.colorMode == FrameGrabber.ColorMode.BGR ? 3 : 1);
            fp.width(this.imageWidth);
            fp.height(this.imageHeight);
        }
        if (avformat.av_open_input_file(this.pFormatCtx, this.filename, f, 0, fp) != 0) {
            throw new Exception("Could not open file \"" + this.filename + "\".");
        }
        if (avformat.av_find_stream_info(this.pFormatCtx) < 0) {
            throw new Exception("Could not find stream information.");
        }
        avformat.dump_format(this.pFormatCtx, 0, this.filename, 0);
        this.videoStream = -1;
        int nb_streams = this.pFormatCtx.nb_streams();
        for (int i = 0; i < nb_streams; ++i) {
            this.pStream = this.pFormatCtx.streams(i);
            this.pCodecCtx = this.pStream.codec();
            if (this.pCodecCtx.codec_type() != 0) continue;
            this.videoStream = i;
            break;
        }
        if (this.videoStream == -1) {
            throw new Exception("Did not find a video stream.");
        }
        this.pCodec = avcodec.avcodec_find_decoder(this.pCodecCtx.codec_id());
        if (this.pCodec == null) {
            throw new Exception("Unsupported codec or codec not found: " + this.pCodecCtx.codec_id() + ".");
        }
        if (avcodec.avcodec_open(this.pCodecCtx, this.pCodec) < 0) {
            throw new Exception("Could not open codec.");
        }
        this.pFrame = avcodec.avcodec_alloc_frame();
        this.pFrameRGB = avcodec.avcodec_alloc_frame();
        if (this.pFrameRGB == null) {
            throw new Exception("Could not allocate frame.");
        }
        int width = this.getImageWidth() > 0 ? this.getImageWidth() : this.pCodecCtx.width();
        int height = this.getImageHeight() > 0 ? this.getImageHeight() : this.pCodecCtx.height();
        switch (this.colorMode) {
            case BGR: {
                this.numBytes = avcodec.avpicture_get_size(3, width, height);
                this.buffer = new BytePointer(avutil.av_malloc(this.numBytes));
                avcodec.avpicture_fill(this.pFrameRGB, this.buffer, 3, width, height);
                this.img_convert_ctx = swscale.sws_getContext(this.pCodecCtx.width(), this.pCodecCtx.height(), this.pCodecCtx.pix_fmt(), width, height, 3, 2, null, null, null);
                if (this.img_convert_ctx == null) {
                    throw new Exception("Cannot initialize the conversion context.");
                }
                this.return_image = opencv_core.IplImage.createHeader(width, height, 8, 3);
                break;
            }
            case GRAY: {
                this.numBytes = avcodec.avpicture_get_size(8, width, height);
                this.buffer = new BytePointer(avutil.av_malloc(this.numBytes));
                avcodec.avpicture_fill(this.pFrameRGB, this.buffer, 8, width, height);
                this.img_convert_ctx = swscale.sws_getContext(this.pCodecCtx.width(), this.pCodecCtx.height(), this.pCodecCtx.pix_fmt(), width, height, 8, 2, null, null, null);
                if (this.img_convert_ctx == null) {
                    throw new Exception("Cannot initialize the conversion context.");
                }
                this.return_image = opencv_core.IplImage.createHeader(width, height, 8, 1);
                break;
            }
            case RAW: {
                this.numBytes = 0;
                this.buffer = null;
                this.img_convert_ctx = null;
                this.return_image = opencv_core.IplImage.createHeader(this.pCodecCtx.width(), this.pCodecCtx.height(), 8, 1);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void stop() throws Exception {
        if (this.buffer != null) {
            avutil.av_free(this.buffer);
            this.buffer = null;
        }
        if (this.pFrameRGB != null) {
            avutil.av_free(this.pFrameRGB);
            this.pFrameRGB = null;
        }
        if (this.pFrame != null) {
            avutil.av_free(this.pFrame);
            this.pFrame = null;
        }
        if (this.pCodecCtx != null) {
            avcodec.avcodec_close(this.pCodecCtx);
            this.pCodecCtx = null;
        }
        if (this.pFormatCtx != null && !this.pFormatCtx.isNull()) {
            avformat.av_close_input_file(this.pFormatCtx);
            this.pFormatCtx = null;
        }
        if (this.return_image != null) {
            this.return_image.release();
            this.return_image = null;
        }
    }

    public void trigger() throws Exception {
        if (this.pFormatCtx == null || this.pFormatCtx.isNull()) {
            throw new Exception("Could not trigger: No AVFormatContext. (Has start() been called?)");
        }
        for (int i = 0; i < this.triggerFlushSize; ++i) {
            if (avformat.av_read_frame(this.pFormatCtx, this.packet) < 0) {
                return;
            }
            avcodec.av_free_packet(this.packet);
        }
    }

    public opencv_core.IplImage grab() throws Exception {
        if (this.pFormatCtx == null || this.pFormatCtx.isNull()) {
            throw new Exception("Could not grab: No AVFormatContext. (Has start() been called?)");
        }
        boolean done = false;
        long pts = 0L;
        while (!done) {
            if (avformat.av_read_frame(this.pFormatCtx, this.packet) < 0) {
                return null;
            }
            if (this.packet.stream_index() == this.videoStream) {
                int len = avcodec.avcodec_decode_video2(this.pCodecCtx, this.pFrame, this.frameFinished, this.packet);
                LongPointer opaque = new LongPointer(this.pFrame.opaque());
                pts = this.packet.dts() != Long.MIN_VALUE ? this.packet.dts() : (!opaque.isNull() && opaque.get() != Long.MIN_VALUE ? opaque.get() : 0L);
                avutil.AVRational time_base = this.pStream.time_base();
                pts = 1000L * pts * (long)time_base.num() / (long)time_base.den();
                if (len > 0 && this.frameFinished[0] != 0) {
                    switch (this.colorMode) {
                        case BGR: 
                        case GRAY: {
                            if (this.deinterlace) {
                                avcodec.avpicture_deinterlace(this.pFrame, this.pFrame, this.pCodecCtx.pix_fmt(), this.pCodecCtx.width(), this.pCodecCtx.height());
                            }
                            swscale.sws_scale(this.img_convert_ctx, new PointerPointer((Pointer)this.pFrame), this.pFrame.linesize(), 0, this.pCodecCtx.height(), new PointerPointer((Pointer)this.pFrameRGB), this.pFrameRGB.linesize());
                            this.return_image.imageData(this.pFrameRGB.data(0));
                            this.return_image.widthStep(this.pFrameRGB.linesize(0));
                            break;
                        }
                        case RAW: {
                            assert (this.pCodecCtx.width() == this.return_image.width() && this.pCodecCtx.height() == this.return_image.height());
                            this.return_image.imageData(this.pFrame.data(0));
                            this.return_image.widthStep(this.pFrame.linesize(0));
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    this.return_image.imageSize(this.return_image.height() * this.return_image.widthStep());
                    done = true;
                }
            }
            avcodec.av_free_packet(this.packet);
        }
        this.return_image.timestamp(pts);
        return this.return_image;
    }
}

