/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networking;

import edu.wpi.first.wpilibj.networking.Entry;
import java.io.IOException;
import java.io.InputStream;

class Reader {
    private InputStream stream;
    private int lastByte;

    public Reader(InputStream input) {
        this.stream = input;
        this.lastByte = -2;
    }

    public int read() throws IOException {
        this.lastByte = this.stream.read();
        if (this.lastByte == -1) {
            throw new IOException("End Of Stream");
        }
        return this.lastByte;
    }

    private int check(boolean useLastValue) throws IOException {
        return useLastValue ? this.lastByte : this.read();
    }

    public String readString() throws IOException {
        StringBuffer buffer;
        this.read();
        if (this.lastByte == 255) {
            buffer = new StringBuffer(360);
            while (this.read() != 0) {
                buffer.append((char)this.lastByte);
            }
        } else {
            int length = this.lastByte;
            buffer = new StringBuffer(length);
            for (int i = 0; i < length; ++i) {
                buffer.append((char)this.read());
            }
        }
        return buffer.toString();
    }

    public Integer readId(boolean useLastValue) throws IOException {
        return this.readVariableSize(useLastValue, 128);
    }

    public Integer readTableId(boolean useLastValue) throws IOException {
        return this.readVariableSize(useLastValue, 64);
    }

    private Integer readVariableSize(boolean useLastValue, int tag) throws IOException {
        int value = this.check(useLastValue);
        if ((value ^= tag) < tag - 4) {
            return new Integer(value);
        }
        int bytes = (value & 3) + 1;
        int id = 0;
        for (int i = 0; i < bytes; ++i) {
            id = id << 8 | this.read();
        }
        return new Integer(id);
    }

    public int readInt() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public double readDouble() throws IOException {
        long l = this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        l = l << 8 | (long)this.read();
        return Double.longBitsToDouble(l);
    }

    public int readConfirmations(boolean useLastValue) throws IOException {
        return this.check(useLastValue) ^ 0x20;
    }

    public int readDenials(boolean useLastValue) throws IOException {
        return this.check(useLastValue) ^ 0x10;
    }

    public Entry readEntry(boolean useLastValue) throws IOException {
        switch (this.check(useLastValue)) {
            case 4: {
                return new Entry.BooleanEntry(false);
            }
            case 5: {
                return new Entry.BooleanEntry(true);
            }
            case 1: {
                return new Entry.IntegerEntry(this.readInt());
            }
            case 2: {
                return new Entry.DoubleEntry(this.readDouble());
            }
            case 0: {
                return new Entry.StringEntry(this.readString());
            }
        }
        return null;
    }
}

