/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networking;

import edu.wpi.first.wpilibj.networking.Buffer;
import edu.wpi.first.wpilibj.networking.Connection;
import edu.wpi.first.wpilibj.networking.ConnectionManager;
import edu.wpi.first.wpilibj.networking.Entry;
import edu.wpi.first.wpilibj.networking.Key;
import edu.wpi.first.wpilibj.networking.NetworkAdditionListener;
import edu.wpi.first.wpilibj.networking.NetworkConnectionListener;
import edu.wpi.first.wpilibj.networking.NetworkListener;
import edu.wpi.first.wpilibj.networking.NetworkQueue;
import edu.wpi.first.wpilibj.networking.OldData;
import edu.wpi.first.wpilibj.networking.Set;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkTable {
    private static Hashtable tables;
    private static int currentId;
    private static Hashtable ids;
    private Set connections;
    private Set listenToAllListeners;
    private Hashtable listeners;
    private Set additionListeners;
    private Set connectionListeners;
    private final Object listenerLock = new Object();
    private Hashtable data = new Hashtable();
    private final Integer id = this.grabId();
    private NetworkQueue transaction = new NetworkQueue();
    private int transactionCount = 0;
    private NetworkQueue hasChanged = new NetworkQueue();
    private NetworkQueue hasAdded = new NetworkQueue();

    public static synchronized void initialize() {
        if (tables == null) {
            tables = new Hashtable();
            ConnectionManager.initialize();
        }
    }

    public static synchronized void setTeam(int team) {
        if (team <= 0) {
            throw new IllegalArgumentException("Can not be given a non-positive team number.");
        }
        ConnectionManager.ipaddress = "10." + team / 100 + "." + team % 100 + ".2";
    }

    public static synchronized void setIPAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("Can not use null address");
        }
        ConnectionManager.ipaddress = address;
    }

    public static synchronized NetworkTable getTable(String name) {
        NetworkTable.initialize();
        if (tables.containsKey(name)) {
            return (NetworkTable)tables.get(name);
        }
        NetworkTable table = new NetworkTable();
        tables.put(name, table);
        ConnectionManager.requestTable(name, table);
        return table;
    }

    static NetworkTable getTable(Integer id) {
        return (NetworkTable)ids.get(id);
    }

    static synchronized void sendRequests() {
        Enumeration keys = tables.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ConnectionManager.requestTable(key, (NetworkTable)tables.get(key));
        }
    }

    private synchronized Integer grabId() {
        return new Integer(currentId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction() {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            ++this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.transactionCount == 0) {
                throw new RuntimeException("End transaction called too many times...");
            }
            if (--this.transactionCount == 0) {
                if (this.isConnected()) {
                    for (int i = 0; i < this.connections.size(); ++i) {
                        Connection connection = (Connection)this.connections.get(i);
                        connection.offerTransaction(this.transaction);
                    }
                } else {
                    this.processTransaction(true, this.transaction);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTransaction(boolean confirmed, NetworkQueue transaction) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Entry entry;
            while (!transaction.isEmpty()) {
                entry = (Entry)transaction.poll();
                Entry oldEntry = entry.getKey().setEntry(entry);
                if (oldEntry == null) {
                    this.hasAdded.offer(entry);
                    continue;
                }
                if (entry.equals(oldEntry)) continue;
                this.hasChanged.offer(entry);
            }
            while (!this.hasAdded.isEmpty()) {
                entry = (Entry)this.hasAdded.poll();
                this.alertListeners(true, confirmed, entry.getKey().getName(), entry);
            }
            while (!this.hasChanged.isEmpty()) {
                entry = (Entry)this.hasChanged.poll();
                this.alertListeners(true, confirmed, entry.getKey().getName(), entry);
            }
        }
    }

    int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(Connection connection) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.connections == null) {
                this.connections = new Set();
            }
            if (this.connections.add(connection)) {
                Enumeration keys = this.data.elements();
                while (keys.hasMoreElements()) {
                    Key key = (Key)keys.nextElement();
                    connection.offer(key);
                    if (!key.hasEntry()) continue;
                    connection.offer(new OldData(key.getEntry()));
                }
                if (this.connections.size() == 1) {
                    ids.put(this.id, this);
                    if (this.connectionListeners != null) {
                        for (int i = 0; i < this.connectionListeners.size(); ++i) {
                            ((NetworkConnectionListener)this.connectionListeners.get(i)).connected();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(Connection connection) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            this.connections.remove(connection);
            if (this.connections.size() == 0) {
                ids.remove(this.id);
                if (this.connectionListeners != null) {
                    for (int i = 0; i < this.connectionListeners.size(); ++i) {
                        ((NetworkConnectionListener)this.connectionListeners.get(i)).disconnected();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getKeys() {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Enumeration elements = this.data.elements();
            ArrayList<String> result = new ArrayList<String>();
            while (elements.hasMoreElements()) {
                Key key = (Key)elements.nextElement();
                if (!key.hasEntry()) continue;
                result.add(key.getName());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Key getKey(String name) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Key key = (Key)this.data.get(name);
            if (key == null) {
                key = new Key(this, name);
                this.data.put(name, key);
                if (this.connections != null) {
                    for (int i = 0; i < this.connections.size(); ++i) {
                        ((Connection)this.connections.get(i)).offer(key);
                    }
                }
            }
            return key;
        }
    }

    public void putInt(String key, int value) {
        this.put(key, new Entry.IntegerEntry(value));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, new Entry.BooleanEntry(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, new Entry.DoubleEntry(value));
    }

    public void putString(String key, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Given null value");
        }
        this.put(key, new Entry.StringEntry(value));
    }

    public void putSubTable(String key, NetworkTable value) {
        if (value == null) {
            throw new IllegalArgumentException("Given null value");
        }
        this.put(key, new Entry.TableEntry(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String field, Entry value) {
        if (field == null) {
            throw new IllegalArgumentException("Given null key");
        }
        Key key = this.getKey(field);
        value.setKey(key);
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.transactionCount == 0) {
                this.send(value);
            } else {
                this.transaction.offer(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Entry entry) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.isConnected()) {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection connection = (Connection)this.connections.get(i);
                    if (connection == entry.getSource()) continue;
                    connection.offer(entry);
                }
            } else {
                this.got(true, entry.getKey(), entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String key, NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            Set list;
            if (this.listeners == null) {
                this.listeners = new Hashtable();
            }
            if ((list = (Set)this.listeners.get(key)) == null) {
                list = new Set();
                this.listeners.put(key, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerToAll(NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listenToAllListeners == null) {
                this.listenToAllListeners = new Set();
            }
            this.listenToAllListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String key, NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            Set list;
            if (this.listeners != null && (list = (Set)this.listeners.get(key)) != null) {
                list.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListenerFromAll(NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listenToAllListeners != null) {
                this.listenToAllListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdditionListener(NetworkAdditionListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.additionListeners == null) {
                this.additionListeners = new Set();
            }
            this.additionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdditionListener(NetworkAdditionListener listener, boolean notify) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.additionListeners == null) {
                this.additionListeners = new Set();
            }
            this.additionListeners.add(listener);
        }
        object = this;
        synchronized (object) {
            Enumeration values = this.data.elements();
            while (values.hasMoreElements()) {
                Key key = (Key)values.nextElement();
                if (key.getEntry() == null) continue;
                listener.fieldAdded(key.getName(), key.getEntry().getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditionListener(NetworkAdditionListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.additionListeners != null) {
                this.additionListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(NetworkConnectionListener listener, boolean immediateNotify) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.connectionListeners == null) {
                this.connectionListeners = new Set();
            }
            this.connectionListeners.add(listener);
            if (immediateNotify) {
                if (this.isConnected()) {
                    listener.connected();
                } else {
                    listener.disconnected();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(NetworkConnectionListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.connectionListeners != null) {
                this.connectionListeners.remove(listener);
            }
        }
    }

    public Object getValue(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getValue();
    }

    public Object getValue(String key, Object defaultValue) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            return defaultValue;
        }
        return entry.getValue();
    }

    public int getInt(String key) {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        if (entry instanceof Entry.IntegerEntry) {
            return entry.getInt();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not an int");
    }

    public double getDouble(String key) {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        if (entry instanceof Entry.DoubleEntry) {
            return entry.getDouble();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a double");
    }

    public String getString(String key) {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        if (entry instanceof Entry.StringEntry) {
            return entry.getString();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a string");
    }

    public NetworkTable getSubTable(String key) {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        if (entry instanceof Entry.TableEntry) {
            return entry.getTable();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a table");
    }

    public boolean getBoolean(String key) {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NoSuchElementException();
        }
        if (entry instanceof Entry.BooleanEntry) {
            return entry.getBoolean();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a boolean");
    }

    public boolean isConnected() {
        return this.connections != null && this.connections.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Key k = (Key)this.data.get(key);
            return k != null && k.hasEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry getEntry(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Can not be given null");
        }
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Key k = (Key)this.data.get(key);
            return k == null ? null : k.getEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void got(boolean confirmed, Key key, Entry value) {
        Entry old;
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            old = key.setEntry(value);
        }
        if (value.equals(old)) {
            return;
        }
        if (!confirmed) {
            this.send(value);
        }
        this.alertListeners(old == null, confirmed, key.getName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertListeners(boolean isNew, boolean confirmed, String key, Entry value) {
        Object object = this.listenerLock;
        synchronized (object) {
            NetworkListener listener;
            int i;
            if (isNew && this.additionListeners != null) {
                for (int i2 = 0; i2 < this.additionListeners.size(); ++i2) {
                    ((NetworkAdditionListener)this.additionListeners.get(i2)).fieldAdded(key, value.getValue());
                }
            }
            Set list = null;
            if (this.listeners != null) {
                list = (Set)this.listeners.get(key);
            }
            if (list != null) {
                for (i = 0; i < list.size(); ++i) {
                    listener = (NetworkListener)list.get(i);
                    if (confirmed) {
                        listener.valueConfirmed(key, value.getValue());
                        continue;
                    }
                    listener.valueChanged(key, value.getValue());
                }
            }
            if ((list = this.listenToAllListeners) != null) {
                for (i = 0; i < list.size(); ++i) {
                    listener = (NetworkListener)list.get(i);
                    if (confirmed) {
                        listener.valueConfirmed(key, value.getValue());
                        continue;
                    }
                    listener.valueChanged(key, value.getValue());
                }
            }
        }
    }

    void encodeName(Buffer buffer) {
        buffer.writeTableId(this.id);
    }

    static {
        currentId = 1;
        ids = new Hashtable();
    }

    public static class NoTeamNumberException
    extends RuntimeException {
    }
}

