/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networking;

import edu.wpi.first.wpilibj.networking.Confirmation;
import edu.wpi.first.wpilibj.networking.Data;
import edu.wpi.first.wpilibj.networking.Denial;
import edu.wpi.first.wpilibj.networking.Entry;
import edu.wpi.first.wpilibj.networking.Key;
import edu.wpi.first.wpilibj.networking.LinkedList;
import java.util.Hashtable;

class NetworkQueue {
    Hashtable table = new Hashtable();
    LinkedList queue = new LinkedList();
    private boolean inTransaction = false;

    NetworkQueue() {
    }

    synchronized void offer(Data value) {
        if (value instanceof Entry) {
            if (this.inTransaction) {
                this.queue.add(value);
            } else {
                Entry entry = (Entry)value;
                if (this.table.containsKey(entry.getKey())) {
                    ((LinkedList.Link)this.table.get((Object)entry.getKey())).data = entry;
                } else {
                    this.table.put(entry.getKey(), this.queue.add(entry));
                }
            }
        } else if (value instanceof Confirmation) {
            if (!this.queue.isEmpty() && this.queue.last.data instanceof Confirmation) {
                this.queue.last.data = Confirmation.combine((Confirmation)this.queue.last.data, (Confirmation)value);
            } else {
                this.queue.add(value);
            }
        } else if (value instanceof Denial) {
            if (!this.queue.isEmpty() && this.queue.last.data instanceof Denial) {
                this.queue.last.data = Denial.combine((Denial)this.queue.last.data, (Denial)value);
            } else {
                this.queue.add(value);
            }
        } else if (value == Data.TRANSACTION_START) {
            this.inTransaction = true;
            this.queue.add(value);
        } else if (value == Data.TRANSACTION_END) {
            this.inTransaction = false;
            this.queue.add(value);
        } else {
            this.queue.add(value);
        }
    }

    synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    synchronized boolean containsKey(Key key) {
        return key == null ? false : this.table.containsKey(key);
    }

    synchronized Data poll() {
        if (this.isEmpty()) {
            return null;
        }
        LinkedList.Link link = this.queue.first;
        Data data = (Data)link.data;
        if (data instanceof Entry) {
            this.table.remove(((Entry)data).getKey());
        }
        link.detach();
        return data;
    }

    synchronized void clear() {
        this.queue.clear();
        this.table.clear();
    }

    synchronized Data peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (Data)this.queue.first.data;
    }
}

