/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networking;

import edu.wpi.first.wpilibj.networking.Buffer;
import edu.wpi.first.wpilibj.networking.Data;
import edu.wpi.first.wpilibj.networking.Entry;
import edu.wpi.first.wpilibj.networking.NetworkConnectionListener;
import edu.wpi.first.wpilibj.networking.NetworkTable;
import java.util.Hashtable;

class Key
implements Data {
    private static Hashtable ids = new Hashtable();
    private static int currentId = 0;
    private final NetworkTable table;
    private final String key;
    private Entry entry;
    private final Integer id;

    private static synchronized Integer grabId() {
        return new Integer(currentId++);
    }

    static Key getKey(Integer id) {
        return (Key)ids.get(id);
    }

    public Key(NetworkTable table, String key) {
        this.table = table;
        this.key = key;
        this.id = Key.grabId();
        table.addConnectionListener(new NetworkConnectionListener(){

            public void connected() {
                ids.put(Key.this.id, Key.this);
            }

            public void disconnected() {
                ids.remove(Key.this);
            }
        }, true);
    }

    public NetworkTable getTable() {
        return this.table;
    }

    public synchronized int getType() {
        return this.entry == null ? -1 : this.entry.getType();
    }

    public synchronized Entry getEntry() {
        return this.entry;
    }

    public String getName() {
        return this.key;
    }

    synchronized Entry setEntry(Entry entry) {
        Entry old = this.entry;
        this.entry = entry;
        this.entry.setKey(this);
        return old;
    }

    boolean hasEntry() {
        return this.entry != null;
    }

    int getId() {
        return this.id;
    }

    void encodeName(Buffer buffer) {
        buffer.writeId(this.id);
    }

    public void encode(Buffer buffer) {
        buffer.writeByte(6);
        this.table.encodeName(buffer);
        buffer.writeString(this.key);
        buffer.writeId(this.id);
    }

    public String toString() {
        return "[(" + this.table.getId() + ") \"" + this.getName() + "\"->" + this.entry + "]";
    }
}

