/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networking;

import edu.wpi.first.wpilibj.networking.Entry;
import edu.wpi.first.wpilibj.networking.Key;
import edu.wpi.first.wpilibj.networking.LinkedList;
import java.util.Hashtable;
import java.util.NoSuchElementException;

class CountingQueue {
    Hashtable counts = new Hashtable();
    LinkedList queue = new LinkedList();

    CountingQueue() {
    }

    public synchronized void offer(Entry entry) {
        if (entry == null) {
            this.queue.add(null);
        } else {
            Counter counter = (Counter)this.counts.get(entry.getKey());
            if (counter == null) {
                counter = new Counter();
                this.counts.put(entry.getKey(), counter);
            }
            counter.increment();
            this.queue.add(entry);
        }
    }

    public synchronized Entry poll() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Nothing left in the queue");
        }
        Entry entry = (Entry)this.queue.dequeue();
        if (entry != null) {
            ((Counter)this.counts.get(entry.getKey())).decrement();
        }
        return entry;
    }

    public synchronized boolean containsKey(Key key) {
        Counter counter = (Counter)this.counts.get(key);
        return counter != null && counter.value() > 0;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private static class Counter {
        private int value = 0;

        private Counter() {
        }

        void increment() {
            ++this.value;
        }

        void decrement() {
            --this.value;
        }

        int value() {
            return this.value;
        }
    }
}

