/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.xml;

import java.awt.Point;
import java.io.FileWriter;
import java.io.IOException;

public class SmartDashboardXMLWriter {
    String fileName;
    FileWriter writer;

    public SmartDashboardXMLWriter(String fileName) throws IOException {
        this.fileName = fileName;
        this.writer = new FileWriter(fileName);
        this.writer.write("<?xml version=\"1.0\"?>\n");
        this.writer.write("<dashboard>\n");
    }

    public void beginStaticWidget(String className) throws IOException {
        this.writer.write("\t<static-widget class=\"" + className + "\">\n");
    }

    public void endStaticWidget() throws IOException {
        this.writer.write("\t</static-widget>\n");
    }

    public void beginWidget(String field, String className) throws IOException {
        this.writer.write("\t<widget field=\"" + field + "\" class=\"" + className + "\">\n");
    }

    public void beginWidget(String field, String type, String className) throws IOException {
        this.writer.write("\t<widget field=\"" + field + "\" type=\"" + type + "\" class=\"" + className + "\">\n");
    }

    public void endWidget() throws IOException {
        this.writer.write("\t</widget>\n");
    }

    public void addHiddenField(String field) throws IOException {
        this.writer.write("\t<hidden field=\"" + field + "\"/>\n");
    }

    public void addLocation(Point p) throws IOException {
        this.writer.write("\t\t<location x=\"" + p.x + "\" y=\"" + p.y + "\"/>\n");
    }

    public void addWidth(int width) throws IOException {
        this.writer.write("\t\t<width>" + width + "</width>\n");
    }

    public void addHeight(int height) throws IOException {
        this.writer.write("\t\t<height>" + height + "</height>\n");
    }

    public void addProperty(String name, String value) throws IOException {
        this.writer.write("\t\t<property name=\"" + name + "\" value=\"" + value + "\"/>\n");
    }

    public void close() throws IOException {
        this.writer.write("</dashboard>");
        this.writer.close();
    }
}

