/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.types;

import edu.wpi.first.smartdashboard.gui.StaticWidget;
import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.gui.elements.DisplayElementRegistrar;
import edu.wpi.first.smartdashboard.types.DataType;
import edu.wpi.first.smartdashboard.types.named.PIDCommandType;
import edu.wpi.first.smartdashboard.types.named.PIDSubsystemType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayElementRegistry {
    private static boolean initialized = false;
    private static Set<Class<? extends StaticWidget>> staticWidgets = new LinkedHashSet<Class<? extends StaticWidget>>();
    private static Map<DataType, Set<Class<? extends Widget>>> map = new HashMap<DataType, Set<Class<? extends Widget>>>();
    private static Map<Class<? extends Widget>, DataType[]> declaredTypes = new HashMap<Class<? extends Widget>, DataType[]>();

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            DisplayElementRegistrar.init();
            PIDCommandType.get();
            PIDSubsystemType.get();
        }
    }

    public static void registerStaticWidget(Class<? extends StaticWidget> clazz) {
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            staticWidgets.add(clazz);
        }
    }

    public static void registerWidget(Class<? extends Widget> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        DataType[] types = null;
        try {
            Field field = clazz.getDeclaredField("TYPES");
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new RuntimeException("TYPES must be static");
            }
            if (!Modifier.isFinal(modifiers)) {
                throw new RuntimeException("TYPES must be final");
            }
            types = (DataType[])field.get(null);
            declaredTypes.put(clazz, types);
        }
        catch (IllegalArgumentException ex) {
            assert (false);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("TYPES must be public");
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException("Every ValueBasedDisplayElement must have a TYPES static field of type DataType[]");
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return;
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("TYPES must be of type Type[]");
        }
        if (types == null) {
            throw new RuntimeException("TYPES must not be null");
        }
        for (DataType type : types) {
            Set<Class<? extends Widget>> list = map.get(type);
            if (list == null) {
                list = new LinkedHashSet<Class<? extends Widget>>();
                map.put(type, list);
            }
            list.add(clazz);
        }
    }

    private static Set<DataType> generateTypes(Set<DataType> set, DataType[] types) {
        for (DataType type : types) {
            if (!set.add(type)) continue;
            DisplayElementRegistry.generateTypes(set, type.getParents());
        }
        return set;
    }

    public static Set<Class<? extends Widget>> getWidgetsForType(DataType type) {
        Set<Class<? extends Widget>> set;
        Set<DataType> types = DisplayElementRegistry.generateTypes(new LinkedHashSet<DataType>(), type.getParents());
        types.add(type);
        LinkedHashSet<Class<? extends Widget>> elements = new LinkedHashSet<Class<? extends Widget>>();
        for (DataType t : types) {
            Class<? extends Widget> priority;
            set = map.get(t);
            if (set == null || (priority = t.getDefault()) == null) continue;
            elements.add(priority);
        }
        for (DataType t : types) {
            set = map.get(t);
            if (set == null) continue;
            elements.addAll(set);
        }
        return elements;
    }

    public static Set<Class<? extends StaticWidget>> getStaticWidgets() {
        return staticWidgets;
    }

    public static boolean supportsType(Class<? extends Widget> clazz, DataType type) {
        for (DataType declaredType : declaredTypes.get(clazz)) {
            if (!type.isChildOf(declaredType)) continue;
            return true;
        }
        return false;
    }
}

