/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.properties;

import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import java.awt.Component;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class Property {
    private final PropertyHolder element;
    private final String name;
    private Object defaultValue;
    private Object value;

    protected Property(PropertyHolder element, String name) {
        this.element = element;
        this.name = name;
        element.getProperties().put(name, this);
    }

    protected Property(PropertyHolder element, String name, Object defaultValue) {
        this.element = element;
        this.name = name;
        this.defaultValue = defaultValue;
        element.getProperties().put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasDefault() {
        return this.defaultValue != null;
    }

    public boolean setDefault(Object value) {
        if ((value = this.transformValue(value)) != null) {
            this.defaultValue = value;
            return true;
        }
        return false;
    }

    public boolean setValue(Object value) {
        if ((value = this.transformValue(value)) != null && this.element.validatePropertyChange(this, value)) {
            this.value = value;
            this.valueChanged();
            this.element.propertyChanged(this);
            return true;
        }
        return false;
    }

    public Object getValue() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    protected abstract Object transformValue(Object var1);

    public String getSaveValue() {
        return this.getValue().toString();
    }

    public void setSaveValue(String value) {
        this._setValue(value);
    }

    protected void _setValue(Object value) {
        if ((value = this.transformValue(value)) != null) {
            this.value = value;
            this.valueChanged();
        }
    }

    protected void valueChanged() {
    }

    public boolean isDefault() {
        return this.value == null ? this.defaultValue != null : this.value.equals(this.defaultValue);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Object getTableValue() {
        return this.getValue();
    }

    public abstract TableCellRenderer getRenderer();

    public TableCellEditor getEditor(Component c) {
        return null;
    }
}

