/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.properties;

import edu.wpi.first.smartdashboard.properties.GenericProperty;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import java.awt.Component;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jfree.ui.ExtensionFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProperty
extends GenericProperty<String> {
    protected JFileChooser chooser;

    public FileProperty(PropertyHolder parent, String name) {
        super(String.class, parent, name);
        this.chooser = new JFileChooser();
    }

    public FileProperty(PropertyHolder parent, String name, String defaultValue) {
        super(String.class, parent, name, defaultValue);
        this.chooser = new JFileChooser((String)this.getValue());
    }

    @Override
    protected String transformValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof File) {
            return ((File)value).getPath();
        }
        return null;
    }

    public void addExtensionFilter(String description, String extension) {
        this.chooser.addChoosableFileFilter(new ExtensionFileFilter(description, extension.startsWith(".") ? extension : "." + extension));
    }

    @Override
    public TableCellRenderer getRenderer() {
        return null;
    }

    @Override
    public TableCellEditor getEditor(Component c) {
        return new FileTableCellEditor(c);
    }

    private class FileTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Component c;
        private JLabel label;

        public FileTableCellEditor(Component c) {
            this.c = c;
            this.label = new JLabel();
        }

        public Object getCellEditorValue() {
            return FileProperty.this.getValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            FileProperty.this.chooser.setSelectedFile(new File((String)FileProperty.this.getValue()));
            switch (FileProperty.this.chooser.showDialog(this.c, "Select")) {
                case 0: {
                    FileProperty.this.setValue(FileProperty.this.chooser.getSelectedFile());
                }
            }
            this.label.setText(((String)FileProperty.this.getValue()).toString());
            return this.label;
        }
    }
}

