/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.properties;

import edu.wpi.first.smartdashboard.properties.GenericProperty;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorProperty
extends GenericProperty<Color> {
    private ColorTableCellRenderer renderer;

    public ColorProperty(PropertyHolder parent, String name) {
        super(Color.class, parent, name);
    }

    public ColorProperty(PropertyHolder parent, String name, Color defaultValue) {
        super(Color.class, parent, name, defaultValue);
    }

    @Override
    protected Color transformValue(Object value) {
        if (value instanceof String) {
            try {
                String string = (String)value;
                int index = string.indexOf(46);
                int red = Integer.parseInt(string.substring(0, index));
                string = string.substring(index + 1);
                index = string.indexOf(46);
                int green = Integer.parseInt(string.substring(0, index));
                string = string.substring(index + 1);
                index = string.indexOf(46);
                int blue = Integer.parseInt(string.substring(0, index));
                int alpha = Integer.parseInt(string.substring(index + 1));
                return new Color(red, green, blue, alpha);
            }
            catch (Exception e) {
                return null;
            }
        }
        return (Color)super.transformValue(value);
    }

    @Override
    public String getSaveValue() {
        Color color = (Color)this.getValue();
        return color.getRed() + "." + color.getGreen() + "." + color.getBlue() + "." + color.getAlpha();
    }

    @Override
    public TableCellEditor getEditor(Component c) {
        return new ColorTableCellEditor(c);
    }

    @Override
    public TableCellRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new ColorTableCellRenderer();
        }
        return this.renderer;
    }

    class ColorTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        ColorTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setBackground((Color)value);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    class ColorTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JColorChooser colorChooser;
        private JDialog colorDialog;
        private JPanel panel = new JPanel();

        public ColorTableCellEditor(Component c) {
            this.colorChooser = new JColorChooser();
            this.colorDialog = JColorChooser.createDialog(c, "Color editor", true, this.colorChooser, new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ColorTableCellEditor.this.stopCellEditing();
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ColorTableCellEditor.this.cancelCellEditing();
                }
            });
            this.colorDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    ColorTableCellEditor.this.cancelCellEditing();
                }
            });
        }

        public boolean shouldSelectCell(EventObject av) {
            this.colorDialog.setVisible(true);
            return true;
        }

        public void cancelCellEditing() {
            this.colorDialog.setVisible(false);
            super.cancelCellEditing();
        }

        public boolean stopCellEditing() {
            this.colorDialog.setVisible(false);
            super.stopCellEditing();
            return true;
        }

        public Object getCellEditorValue() {
            return this.colorChooser.getColor();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.colorChooser.setColor((Color)value);
            return this.panel;
        }
    }
}

