/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.elements.EditableDisplayElement;
import edu.wpi.first.smartdashboard.properties.ColorProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.robot.Robot;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class TextBox
extends EditableDisplayElement
implements ActionListener {
    public static final DataType[] TYPES = new DataType[]{DataType.BASIC};
    public static final String NAME = "Text Box";
    public final ColorProperty background = new ColorProperty(this, "Background");
    private JTextField valueField;
    private String oldText;

    public void init() {
        this.setLayout(new BoxLayout(this, 0));
        JLabel nameLabel = new JLabel(this.getFieldName());
        this.valueField = new JTextField();
        this.update(this.background, this.valueField.getBackground());
        this.valueField.setEditable((Boolean)this.editable.getValue());
        this.valueField.setColumns(10);
        this.valueField.addActionListener(this);
        this.add(nameLabel);
        this.add(this.valueField);
        this.revalidate();
        this.repaint();
    }

    public void setValue(Object value) {
        this.oldText = value.toString();
        this.valueField.setText(this.oldText);
        this.revalidate();
        this.repaint();
    }

    public void propertyChanged(Property property) {
        if (property == this.background) {
            this.valueField.setBackground((Color)this.background.getValue());
        } else if (property == this.editable) {
            this.valueField.setEditable((Boolean)this.editable.getValue());
        }
    }

    public void actionPerformed(ActionEvent event) {
        String newText = this.valueField.getText();
        if (!newText.equals(this.oldText)) {
            if (this.getType().isChildOf(DataType.BOOLEAN)) {
                if (newText.equalsIgnoreCase("true")) {
                    this.setValue("true");
                    Robot.getTable().putBoolean(this.getFieldName(), true);
                } else if (newText.equalsIgnoreCase("false")) {
                    this.setValue("false");
                    Robot.getTable().putBoolean(this.getFieldName(), false);
                } else {
                    this.setValue(this.oldText);
                }
            } else if (this.getType().isChildOf(DataType.DOUBLE)) {
                try {
                    double value = Double.parseDouble(newText);
                    this.setValue(value);
                    Robot.getTable().putDouble(this.getFieldName(), value);
                }
                catch (NumberFormatException e) {
                    this.setValue(this.oldText);
                }
            } else if (this.getType().isChildOf(DataType.INTEGER)) {
                try {
                    int value = Integer.parseInt(newText);
                    this.setValue(value);
                    Robot.getTable().putInt(this.getFieldName(), value);
                }
                catch (NumberFormatException e) {
                    this.setValue(this.oldText);
                }
            } else if (this.getType().isChildOf(DataType.STRING)) {
                this.setValue(newText);
                Robot.getTable().putString(this.getFieldName(), newText);
            }
        }
        this.requestFocus();
    }
}

