/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.smartdashboard.gui.elements;

import edu.wpi.first.smartdashboard.gui.Widget;
import edu.wpi.first.smartdashboard.properties.DoubleProperty;
import edu.wpi.first.smartdashboard.properties.Property;
import edu.wpi.first.smartdashboard.properties.PropertyHolder;
import edu.wpi.first.smartdashboard.types.DataType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;

public class SimpleDial
extends Widget {
    public static final DataType[] TYPES = new DataType[]{DataType.NUMBER};
    public final DoubleProperty max = new DoubleProperty((PropertyHolder)this, "Upper Limit", 100.0);
    public final DoubleProperty min = new DoubleProperty((PropertyHolder)this, "Lower Limit", 0.0);
    public final DoubleProperty tickInterval = new DoubleProperty((PropertyHolder)this, "Tick Interval", 10.0);
    JPanel chartPanel;
    DefaultValueDataset data = new DefaultValueDataset(0.0);
    MeterPlot m_meter;
    Range m_plotRange;

    public void init() {
        this.setLayout(new BorderLayout());
        this.m_meter = new MeterPlot((ValueDataset)this.data);
        this.m_plotRange = new Range(this.min.getValue().doubleValue(), this.max.getValue().doubleValue());
        this.m_meter.setRange(this.m_plotRange);
        JFreeChart chart = new JFreeChart(this.getFieldName(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.m_meter, false);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setPreferredSize(new Dimension(250, 150));
        this.propertyChanged(this.tickInterval);
        this.add((Component)this.chartPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    public void setValue(Object value) {
        this.data.setValue((Number)value);
        this.revalidate();
        this.repaint();
    }

    public void propertyChanged(Property property) {
        if (property == this.min || property == this.max) {
            this.m_plotRange = new Range(this.min.getValue().doubleValue(), this.max.getValue().doubleValue());
            this.m_meter.setRange(this.m_plotRange);
        } else if (property == this.tickInterval) {
            this.m_meter.setTickSize(this.tickInterval.getValue().doubleValue());
        }
    }
}

